/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCharLiteral
implements OCLiteral {
    public static final OCCharLiteral BAD_LITERAL = new OCCharLiteral(CidrStringLiteralUtil.CidrCharType.CHAR_LITERAL, "", "");
    @NotNull
    public final CidrStringLiteralUtil.CidrCharType charType;
    @NotNull
    public final String prefix;
    @NotNull
    public final String contents;

    public OCCharLiteral(@NotNull CidrStringLiteralUtil.CidrCharType charType, @NotNull String prefix, @NotNull String contents) {
        this.charType = charType;
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (escaped) {
            return this.contents;
        }
        return EscapeUtil.unescapeAnsiStringCharacters((String)this.contents);
    }

    @NotNull
    public OCIntType getType(boolean isPlainOldC) {
        return OCStringCodec.getType(isPlainOldC ? this.charType.typePlainC : this.charType.typeCpp);
    }

    @Override
    @NotNull
    public OCType getType(@Nullable PsiFile file, boolean isPlainOldC, @NotNull Project project) {
        return this.getType(isPlainOldC);
    }
}

