/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoClassContributor;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.ui.OCClassChooserDialog;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private boolean myOnlyInProject;
    private Condition<OCSymbol> myCondition;

    public OCTypeReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory, boolean onlyInProject, Condition<OCSymbol> condition) {
        super(browseActionListener, editorTextField, factory);
        this.myOnlyInProject = onlyInProject;
        this.myCondition = condition;
    }

    public static OCTypeReferenceEditor create(@Nullable OCSymbol initialClass, @NotNull Condition<OCSymbol> condition, @Nullable PsiElement context, boolean onlyInProject, final @NotNull Project project) {
        final Ref result = Ref.create(null);
        Function documentFactory = s -> {
            OCCodeFragment fragment = OCElementFactory.getTypeCodeFragmentInWriteAction(s.trim(), project, context);
            return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        };
        final Condition symbolCondition = symbol -> {
            if (!condition.value(symbol)) {
                return false;
            }
            if (!onlyInProject) {
                return true;
            }
            return OCSearchScope.isInProjectSources(symbol, project);
        };
        OCTextFieldWithSymbolAutoCompletion textField = OCTextFieldWithSymbolAutoCompletion.create((Project)project, (OCFieldAdapter)OCFieldAdapterForSymbolName.INSTANCE, item -> symbolCondition.value((Object)item.getSymbol()));
        result.set((Object)new OCTypeReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCSymbol symbol = ((OCTypeReferenceEditor)((Object)result.get())).getClassDeclaration(project);
                OCClassChooserDialog dialog = new OCClassChooserDialog(OCRefactoringBundle.message("dialog.title.choose.containing.class", new Object[0]), project, new TreeChooser.Filter<OCSymbolHolderVirtualPsiElement>(){

                    public boolean isAccepted(OCSymbolHolderVirtualPsiElement element) {
                        return symbolCondition.value(element.getSymbol());
                    }
                }, symbol != null ? new OCSymbolHolderVirtualPsiElement(symbol, project) : null, (Condition<OCSymbol>)symbolCondition);
                dialog.showDialog();
                if (dialog.isOK()) {
                    ((OCTypeReferenceEditor)((Object)result.get())).setText(((OCSymbolHolderVirtualPsiElement)dialog.getSelected()).getSymbol().getPresentableName());
                }
            }
        }, (EditorTextField)textField, (Function<String, Document>)documentFactory, onlyInProject, (Condition<OCSymbol>)symbolCondition));
        if (initialClass != null) {
            textField.setText(initialClass.getPresentableName());
        }
        return (OCTypeReferenceEditor)((Object)result.get());
    }

    @Nullable
    public OCSymbol getClassDeclaration(@NotNull Project project) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        GlobalSearchScope scope = OCSearchScope.getGotoSymbolScope(project, !this.myOnlyInProject);
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(processor2, (Condition<? super T>[])new Condition[]{s -> !(s.getSymbol() instanceof OCClassSymbol) || ((OCClassSymbol)s.getSymbol()).getCategoryName() == null, Conditions.alwaysTrue()});
        new OCGotoClassContributor().processSymbolsByName(this.getText(), orderedProcessor, project, scope, this.myCondition, true);
        orderedProcessor.finish();
        OCSymbolNavigationItem value = (OCSymbolNavigationItem)processor2.getFoundValue();
        return value == null ? null : value.getSymbol();
    }
}

