/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCTypeEqualityAfterResolvingVisitor
extends OCTypeEqualityVisitor {
    private final boolean myAssumeNotResolvedTypesEquals;
    private final boolean myAssumeMagicTypesEquals;
    private final boolean myAssumeTollFreeTypesEquals;

    public OCTypeEqualityAfterResolvingVisitor(OCType type, boolean assumeNotResolvedTypeEquals, boolean assumeMagicTypeEquals, boolean assumeConstValueEquals, boolean assumeTollFreeTypesEquals, boolean checkArrayDecay, @NotNull OCResolveContext context) {
        super(type, true, assumeConstValueEquals, checkArrayDecay, context);
        this.myAssumeNotResolvedTypesEquals = assumeNotResolvedTypeEquals;
        this.myAssumeMagicTypesEquals = assumeMagicTypeEquals;
        this.myAssumeTollFreeTypesEquals = assumeTollFreeTypesEquals;
    }

    public OCTypeEqualityAfterResolvingVisitor(OCType type, boolean assumeNotResolvedTypeEquals, boolean assumeMagicTypeEquals, boolean assumeConstValueEquals, boolean assumeTollFreeTypesEquals, @NotNull OCResolveContext context) {
        this(type, assumeNotResolvedTypeEquals, assumeMagicTypeEquals, assumeConstValueEquals, assumeTollFreeTypesEquals, false, context);
    }

    public OCTypeEqualityAfterResolvingVisitor(OCType type, boolean assumeNotResolvedTypeEquals, @NotNull OCResolveContext context) {
        this(type, assumeNotResolvedTypeEquals, false, false, true, context);
    }

    @Override
    public boolean equal(OCType type, boolean checkCV) {
        if (this.myAssumeMagicTypesEquals && (this.myType instanceof OCMagicType || type instanceof OCMagicType || this.myType instanceof OCAutoType || type instanceof OCAutoType)) {
            return true;
        }
        this.myType = this.myType.resolve(this.myContext);
        OCType resolvedType = type.resolve(this.myContext);
        if (checkCV && this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (checkCV && this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        if (this.myType instanceof OCUnknownType || resolvedType instanceof OCUnknownType) {
            return true;
        }
        if (this.myAssumeNotResolvedTypesEquals && (this.myType instanceof OCReferenceType || resolvedType instanceof OCReferenceType)) {
            return true;
        }
        if (this.myType instanceof OCTypeParameterType && resolvedType instanceof OCTypeParameterType) {
            return true;
        }
        if (this.myAssumeTollFreeTypesEquals && OCTollFreeBridges.isCompatible(this.myType, resolvedType)) {
            return true;
        }
        return resolvedType.accept(this);
    }

    @Override
    public Boolean visitObjectType(OCObjectType type) {
        if (type == this.myType) {
            return true;
        }
        if (!(this.myType instanceof OCObjectType)) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!(type instanceof OCIdType && type.getAugmentedProtocols().isEmpty() || that instanceof OCIdType && that.getAugmentedProtocols().isEmpty() || OCTypeEqualityAfterResolvingVisitor.getProtocolNames(type).equals(OCTypeEqualityAfterResolvingVisitor.getProtocolNames(that)))) {
            return false;
        }
        OCInterfaceSymbol thisInterface = type.getInterface();
        OCInterfaceSymbol thatInterface = that.getInterface();
        if (thisInterface == null || thatInterface == null) {
            return thisInterface == thatInterface;
        }
        return Objects.equals(thisInterface.getName(), thatInterface.getName());
    }

    private static Set<String> getProtocolNames(OCObjectType type) {
        HashSet<String> result = new HashSet<String>();
        for (OCProtocolSymbol protocol : type.getAugmentedProtocols()) {
            result.add(protocol.getName());
        }
        return result;
    }

    @Override
    protected Boolean substitutionTypesEqual(@NotNull OCType thatSust, @NotNull OCType mySust, @NotNull OCResolveContext context) {
        return thatSust.accept(new OCTypeEqualityAfterResolvingVisitor(mySust, true, this.myAssumeMagicTypesEquals, this.myDontCheckCV, true, this.myContext));
    }
}

