/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMultiTypeSubstitution
extends OCTypeSubstitution {
    private final List<OCSimpleTypeSubstitution> mySubstitutions;

    public OCMultiTypeSubstitution(List<OCSimpleTypeSubstitution> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @Override
    public OCType substitute(@NotNull OCType type, final boolean overwriteSubstitution, final @NotNull OCResolveContext context) {
        return type.accept(new OCTypeSubstitution.TypeSubstituteVisitor(this, overwriteSubstitution, context){

            @Override
            public OCType visitTypeParameterType(OCTypeParameterType type) {
                OCType partiallySubstitutedType = null;
                for (OCSimpleTypeSubstitution substitution : OCMultiTypeSubstitution.this.mySubstitutions) {
                    if (partiallySubstitutedType != null) {
                        partiallySubstitutedType = substitution.substitute(partiallySubstitutedType, context);
                        continue;
                    }
                    OCTypeArgument arg = substitution.getSubstitutionFor(type.getSymbol());
                    if (arg == null) continue;
                    if (arg instanceof OCType) {
                        if (arg instanceof OCReferenceType) {
                            OCReferenceType result = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCMultiTypeSubstitution.this, overwriteSubstitution, context);
                            return result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull());
                        }
                        partiallySubstitutedType = (OCType)arg;
                        continue;
                    }
                    return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                }
                return partiallySubstitutedType != null ? partiallySubstitutedType.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull()) : type;
            }
        });
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        Set<OCTypeArgument> arguments = OCTypeUtils.newTypeSet();
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            arguments.addAll(substitution.getSubstitutedTypes());
        }
        return arguments;
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor2) {
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            if (substitution.processSubstitutions(processor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol argument) {
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            OCTypeArgument result = oCTypeSubstitution.getSubstitutionFor(argument);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            if (!oCTypeSubstitution.hasSubstitutionForName(name)) continue;
            return true;
        }
        return false;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCMultiTypeSubstitution f = (OCMultiTypeSubstitution)first;
        OCMultiTypeSubstitution s = (OCMultiTypeSubstitution)second;
        return c.equalLists(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, @NotNull OCResolveContext context) {
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        HashMap<OCTypeParameterSymbol, OCTypeArgument> unusedSubstitutions = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        ArrayList<Object> workset2 = new ArrayList<Object>();
        workset2.add(reference);
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            unusedSubstitutions.putAll(substitution.getSubstitutions());
        }
        while (!workset2.isEmpty()) {
            ArrayList<OCTypeArgument> newWorkset = new ArrayList<OCTypeArgument>();
            HashSet<OCTypeParameterSymbol> keysToRemove = new HashSet<OCTypeParameterSymbol>();
            for (OCTypeParameterSymbol key : unusedSubstitutions.keySet()) {
                OCTypeArgument value;
                if (!new OCSimpleTypeSubstitution(Collections.singletonMap(key, value = (OCTypeArgument)unusedSubstitutions.get(key))).dependsOn(workset2, context)) continue;
                map.put(key, value);
                newWorkset.add(value);
                keysToRemove.add(key);
            }
            for (OCTypeParameterSymbol key : keysToRemove) {
                unusedSubstitutions.remove(key);
            }
            workset2 = newWorkset;
        }
        return map.isEmpty() ? ID : new OCSimpleTypeSubstitution(map);
    }

    public String toString() {
        Function converter = substitution -> substitution.substList();
        return "{" + StringUtil.join((Collection)ContainerUtil.map(this.mySubstitutions, (Function)converter), (String)" // ") + "}";
    }

    public int hashCode() {
        return this.mySubstitutions != null ? this.mySubstitutions.hashCode() : 0;
    }

    public List<OCSimpleTypeSubstitution> getSubstitutions() {
        return this.mySubstitutions;
    }
}

