/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OCRealType
extends OCNumericType {
    public static final OCRealType FLOAT = new OCRealType(CTypeId.FLOAT, "float", "%f", false);
    public static final OCRealType DOUBLE = new OCRealType(CTypeId.DOUBLE, "double", "%lf", false);
    public static final OCRealType LONG_DOUBLE = new OCRealType(CTypeId.LONG_DOUBLE, "long double", "%Lf", false);
    public static final OCRealType COMPLEX_FLOAT = new OCRealType(CTypeId.FLOAT, "float", null, true);
    public static final OCRealType COMPLEX_DOUBLE = new OCRealType(CTypeId.DOUBLE, "double", null, true);
    public static final OCRealType COMPLEX_LONG_DOUBLE = new OCRealType(CTypeId.LONG_DOUBLE, "long double", null, true);
    private static final List<OCRealType> BASIC_TYPES = Arrays.asList(FLOAT, DOUBLE, LONG_DOUBLE);
    private boolean myComplex;
    private String myText;
    private String myFormatString;

    public OCRealType() {
    }

    @NotNull
    public List<OCRealType> getBasicTypes() {
        return BASIC_TYPES;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCRealType f = (OCRealType)first;
        OCRealType s = (OCRealType)second;
        if (!f.myTypeId.equals((Object)s.myTypeId)) {
            return false;
        }
        return Objects.equals(f.myText, s.myText);
    }

    @NotNull
    public static OCRealType literalType(@NotNull String text) {
        char suffix = text.charAt(text.length() - 1);
        if (suffix == 'l' || suffix == 'L') {
            return LONG_DOUBLE;
        }
        if (suffix == 'f' || suffix == 'F') {
            return FLOAT;
        }
        return DOUBLE;
    }

    public static OCRealType narrowestLiteralType(String text) {
        if (!Character.isDigit(text.charAt(text.length() - 1))) {
            return OCRealType.literalType(text);
        }
        try {
            BigDecimal dbl = new BigDecimal(text, MathContext.DECIMAL64);
            BigDecimal flt = new BigDecimal(text, MathContext.DECIMAL32);
            if (dbl.equals(flt)) {
                return FLOAT;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return DOUBLE;
    }

    private OCRealType(CTypeId precision, String text, String formatString, boolean complex) {
        this(precision, text, formatString, complex, false, false);
    }

    private OCRealType(CTypeId precision, String text, String formatString, boolean complex, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myFormatString = formatString;
        this.myTypeId = precision;
        this.myText = text;
        this.myComplex = complex;
    }

    public OCRealType cloneType(boolean isConst, boolean isVolatile) {
        return new OCRealType(this.getCTypeId(), this.getText(), this.getFormatString(), this.isComplex(), isConst, isVolatile);
    }

    @Override
    public boolean isComplex() {
        return this.myComplex;
    }

    public String getText() {
        return this.myText;
    }

    public OCRealType cloneWithComplexModifier() {
        if (this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = true;
        return clone;
    }

    public OCRealType cloneWithoutComplexModifier() {
        if (!this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = false;
        return clone;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitRealType(this);
    }

    @Override
    public int getRank(@NotNull OCResolveContext context) {
        return this.getSizeInBytes(context.getFile(), null, context.getProject()) << 6;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String getFormatString() {
        return this.myFormatString;
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        return "0";
    }

    @Override
    public int hashCode() {
        return (this.myComplex ? 997 : 991) * super.hashCode();
    }
}

