/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPointerType
extends OCType
implements ArcAnnotatedType {
    protected OCType myRefType;
    private ARCAttribute myARCAttribute;
    private OCType myClassQualifier;
    @Nullable
    private LengthOrNull myLengthInBrackets = null;
    public static final OCPointerType NULLPTR_T = OCPointerType.to(OCVoidType.instance());

    public OCPointerType() {
    }

    protected OCPointerType(OCType ref, @Nullable ARCAttribute attribute2, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile, nullability);
        this.myRefType = ref;
        this.myARCAttribute = attribute2;
        this.myClassQualifier = classQualifier;
    }

    public static OCPointerType to(@NotNull OCType ref) {
        return new OCPointerType(ref, null, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute2) {
        return new OCPointerType(ref, attribute2, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute2, @Nullable OCType classQualifier) {
        return new OCPointerType(ref, attribute2, classQualifier, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute2, @Nullable OCType classQualifier, boolean isConst, boolean isVolatile) {
        return new OCPointerType(ref, attribute2, classQualifier, null, isConst, isVolatile);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute2, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        return new OCPointerType(ref, attribute2, classQualifier, nullability, isConst, isVolatile);
    }

    public static OCType to(@NotNull OCType ref, int nTimes) {
        for (int i = 0; i < nTimes; ++i) {
            ref = OCPointerType.to(ref);
        }
        return ref;
    }

    @Override
    public void compact() {
        super.compact();
        this.myRefType.compact();
        if (this.myClassQualifier != null) {
            this.myClassQualifier.compact();
        }
    }

    public boolean isPointerToConst() {
        return this.myRefType.isConst();
    }

    public boolean isPointerToVolatile() {
        return this.myRefType.isVolatile();
    }

    @NotNull
    public OCType getRefType() {
        return this.myRefType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        return this.myRefType.getTerminalType();
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth() + 1;
    }

    public OCType getClassQualifier() {
        return this.myClassQualifier;
    }

    @Override
    public int hashCode() {
        return (this.baseHashCode() * 31 + this.myRefType.hashCode()) * 31 + (this.myClassQualifier != null ? this.myClassQualifier.hashCode() : 0);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPointerType f = (OCPointerType)first;
        OCPointerType s = (OCPointerType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (!c.equalObjects(f.myRefType, s.myRefType)) {
            return false;
        }
        return c.equalObjects(f.myClassQualifier, s.myClassQualifier);
    }

    @Override
    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    @NotNull
    public OCPointerType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        OCPointerType clone = (OCPointerType)this.getShallowCopy();
        clone.myARCAttribute = arcAttribute;
        return clone;
    }

    @Override
    @Nullable
    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitPointerType(this);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (this.equals(type, context)) {
            return this;
        }
        if (type instanceof OCMagicType) {
            return type;
        }
        if (this.isPointerToObject() && type.isPointerToObject() || type instanceof OCPointerType && this.myRefType.equals(((OCPointerType)type).getRefType(), false, context)) {
            return OCPointerType.to(this.myRefType.getLeastCommonType(((OCPointerType)type).getRefType(), context));
        }
        if (type.isNumberCompatible(context)) {
            return this;
        }
        if (type.isPointerCompatible(context)) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    public OCTypeCheckResult validateConstPointers(OCType type, @NotNull OCResolveContext context) {
        OCType lType = this;
        OCType rType = type;
        boolean arrayToPointerCastsAvailable = true;
        boolean leftAlwaysPointsToConst = true;
        boolean hasConstMismatch = false;
        boolean hasVolatileMismatch = false;
        boolean hasLengthMismatch = false;
        boolean incompatibleType = false;
        boolean unassignableArray = false;
        boolean isEquals = true;
        int pointersCnt = 0;
        while (lType instanceof OCPointerType && rType instanceof OCPointerType) {
            ++pointersCnt;
            OCPointerType lPtrType = lType;
            OCPointerType rPtrType = (OCPointerType)rType;
            if (!lPtrType.isPointerToConst() && rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (!lPtrType.isPointerToVolatile() && rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToConst() && !rPtrType.isPointerToConst() && !leftAlwaysPointsToConst) {
                hasConstMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToVolatile() && !rPtrType.isPointerToVolatile() && !leftAlwaysPointsToConst) {
                hasVolatileMismatch = true;
            }
            leftAlwaysPointsToConst &= lPtrType.isPointerToConst();
            if (lPtrType instanceof OCBlockPointerType != rPtrType instanceof OCBlockPointerType) {
                isEquals = false;
            }
            if (lPtrType instanceof OCArrayType) {
                OCArrayType lArrayType = (OCArrayType)lPtrType;
                if (pointersCnt > 1 && rPtrType instanceof OCArrayType) {
                    OCArrayType rArrayType = (OCArrayType)rPtrType;
                    if (lArrayType.getLength(context) != rArrayType.getLength(context)) {
                        hasLengthMismatch = true;
                    }
                } else if (lArrayType.hasLength()) {
                    unassignableArray = true;
                }
            } else if (rPtrType instanceof OCArrayType) {
                if (pointersCnt > 1 || !arrayToPointerCastsAvailable) {
                    incompatibleType = true;
                }
                arrayToPointerCastsAvailable = false;
            }
            lType = lPtrType.myRefType;
            rType = rPtrType.myRefType;
            if (lType instanceof OCCppReferenceType) {
                lType = ((OCCppReferenceType)lType).getRefType();
            }
            if (!(rType instanceof OCCppReferenceType)) continue;
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        isEquals = lType instanceof OCIntType && rType instanceof OCIntType ? (isEquals &= lType.equals(rType, false, context)) : (isEquals &= context != null && lType.equals(rType, false, context));
        boolean isLTypeVoidPtr = lType.isVoid() && pointersCnt == 1;
        OCTypeCheckResult generalErrorResult = new OCTypeCheckResult(OCTypeCheckState.ERROR);
        if (!(isEquals || isLTypeVoidPtr || lType instanceof OCMagicType || rType instanceof OCMagicType)) {
            return generalErrorResult;
        }
        if ((hasConstMismatch || hasVolatileMismatch) && !lType.isUnknown() && !rType.isUnknown()) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        if (hasLengthMismatch || incompatibleType || unassignableArray) {
            return generalErrorResult;
        }
        return OCTypeCheckResult.createOK();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        return false;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return this.myRefType.isUnresolved(context) || this.myClassQualifier != null && (!this.myClassQualifier.isCppStructType(context) || this.myClassQualifier.isUnresolved(context));
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return this.myRefType.isMagicInside(context) || this.myClassQualifier != null && this.myClassQualifier.isMagicInside(context);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        return this.myRefType.isSubclassOfMagic(context);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        return OCPointerType.to(this.myRefType.getGuessedUnmagicType());
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType instanceof OCObjectType;
    }

    @Override
    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context) {
        return this.myRefType.isCppStructType(context);
    }

    @Override
    public boolean isPointerToID(boolean withProtocols) {
        return this.myRefType instanceof OCIdType && (!withProtocols || !((OCIdType)this.myRefType).getAugmentedProtocols().isEmpty());
    }

    private boolean isRefTypeIntegral(@NotNull CTypeId id) {
        return this.myRefType instanceof OCIntType && ((OCIntType)this.myRefType).getCTypeId() == id;
    }

    @Override
    public boolean isPointerToChar() {
        return this.isRefTypeIntegral(CTypeId.CHAR) || this.isRefTypeIntegral(CTypeId.SIGNED_CHAR) || this.isRefTypeIntegral(CTypeId.WCHAR_T) || this.isRefTypeIntegral(CTypeId.CHAR16_T) || this.isRefTypeIntegral(CTypeId.CHAR32_T);
    }

    @Override
    public boolean isCString() {
        return this.isPointerToChar();
    }

    @Override
    public boolean isPointerToVoid() {
        return this.myRefType.isVoid();
    }

    @Override
    @NonNls
    public String getFormatString() {
        if (this.isClassType()) {
            return "%@";
        }
        if (this.myRefType.isChar()) {
            return "%s";
        }
        if (this.isRefTypeIntegral(CTypeId.WCHAR_T)) {
            return "%ls";
        }
        if (this.isPointerToObject()) {
            return this.getRefType().getFormatString();
        }
        return "%p";
    }

    public boolean isArrayLikeParameter() {
        return this.myLengthInBrackets != null;
    }

    @Nullable
    public OCExpressionSymbol getLengthInBrackets() {
        OCLog.LOG.assertTrue(this.myLengthInBrackets != null, (Object)"Must be called only on array-like parameters");
        return this.myLengthInBrackets.length;
    }

    public void setLengthInBrackets(@Nullable OCExpressionSymbol lengthInBrackets) {
        this.myLengthInBrackets = new LengthOrNull(lengthInBrackets);
    }

    @Nullable
    public LengthOrNull getLengthOrNull() {
        return this.myLengthInBrackets;
    }

    public void setLengthOrNull(LengthOrNull l) {
        this.myLengthInBrackets = l;
    }

    public static class LengthOrNull {
        @Nullable
        final OCExpressionSymbol length;

        public LengthOrNull(@Nullable OCExpressionSymbol length) {
            this.length = length;
        }
    }
}

