/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoType
extends OCType {
    @Nullable
    private OCType myIncompleteType;
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    private OCExpressionSymbol myExpressionSymbol;
    private OCExpression myExpressionElement;
    private OCLambdaExpression myLambdaExpression;
    private int myParameterIndex = -1;
    private boolean myNeedsAutoParamsResolving;
    @Nullable
    private OCQualifiedName myTypeConstraintName;

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, OCTypeSubstitution substitution, OCLambdaExpression lambdaExpression, int parameterIndex, boolean needsAutoParamsResolving, boolean isConst, boolean isVolatile, @Nullable OCQualifiedName typeConstraintName) {
        super(isConst, isVolatile);
        this.myIncompleteType = incompleteType;
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.mySubstitution = substitution;
        this.myLambdaExpression = lambdaExpression;
        this.myParameterIndex = parameterIndex;
        this.myNeedsAutoParamsResolving = needsAutoParamsResolving;
        this.myTypeConstraintName = typeConstraintName;
    }

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.myIncompleteType = incompleteType;
    }

    public OCAutoType(@NotNull OCAutoType origin, @NotNull OCTypeSubstitution substitution) {
        this.myIncompleteType = origin.getIncompleteType();
        this.myExpressionSymbol = origin.getExpressionSymbol();
        this.myExpressionElement = origin.getExpressionElement();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution);
        this.myTypeConstraintName = origin.getTypeConstraintName();
    }

    public OCAutoType(OCLambdaExpression lambdaExpression, int parameterIndex) {
        this.myLambdaExpression = lambdaExpression;
        this.myParameterIndex = parameterIndex;
    }

    public OCAutoType() {
    }

    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAutoType f = (OCAutoType)first;
        OCAutoType s = (OCAutoType)second;
        if (!c.equalObjects(f.myExpressionSymbol, s.myExpressionSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (this.myExpressionElement != s.myExpressionElement) {
            return false;
        }
        if (this.myLambdaExpression != s.myLambdaExpression) {
            return false;
        }
        if (this.myParameterIndex != s.myParameterIndex) {
            return false;
        }
        if (this.myNeedsAutoParamsResolving != s.myNeedsAutoParamsResolving) {
            return false;
        }
        return c.equalObjects(this.myTypeConstraintName, s.myTypeConstraintName);
    }

    @Nullable
    public OCType getIncompleteType() {
        return this.myIncompleteType;
    }

    @Nullable
    public OCExpressionSymbol getExpressionSymbol() {
        return this.myExpressionSymbol;
    }

    public void setExpressionSymbol(@NotNull OCExpressionSymbol expressionSymbol) {
        this.myExpressionSymbol = expressionSymbol;
    }

    public OCLambdaExpression getLambdaExpression() {
        return this.myLambdaExpression;
    }

    public int getParameterIndex() {
        return this.myParameterIndex;
    }

    public boolean needsAutoParamsResolving() {
        return this.myNeedsAutoParamsResolving;
    }

    public void setNeedsAutoParamsResolving(boolean needsAutoParamsResolving) {
        this.myNeedsAutoParamsResolving = needsAutoParamsResolving;
    }

    @Nullable
    public OCExpression getExpressionElement() {
        return this.myExpressionElement;
    }

    public void setTypeConstraintName(@Nullable OCQualifiedName typeConstraintName) {
        this.myTypeConstraintName = typeConstraintName;
    }

    @Nullable
    public OCQualifiedName getTypeConstraintName() {
        return this.myTypeConstraintName;
    }

    @Nullable
    public OCSymbol getDecltypeExpressionSymbol(@NotNull OCResolveContext context) {
        if (this.myExpressionSymbol instanceof OCReferenceExpressionSymbol) {
            OCReferenceExpressionSymbol referenceExpressionSymbol = (OCReferenceExpressionSymbol)this.myExpressionSymbol;
            return referenceExpressionSymbol.resolveToSymbol(context);
        }
        return null;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return !(this.myTypeConstraintName != null || this.myLambdaExpression != null && this.myParameterIndex != -1 || this.myExpressionSymbol != null && this.myNeedsAutoParamsResolving);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitAutoType(this);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + (this.myIncompleteType != null ? this.myIncompleteType.hashCode() : 0);
        result = 31 * result + (this.mySubstitution != null ? this.mySubstitution.hashCode() : 0);
        result = 31 * result + (this.myExpressionSymbol != null ? this.myExpressionSymbol.hashCode() : 0);
        result = 31 * result + this.myParameterIndex;
        result = 31 * result + (this.myNeedsAutoParamsResolving ? 0 : 1);
        result = 31 * result + (this.myTypeConstraintName != null ? this.myTypeConstraintName.hashCode() : 0);
        return result;
    }
}

