/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CTypeId {
    BOOL,
    SIGNED_CHAR(OCCompilerFeatures.TypeSize.CHAR),
    CHAR,
    CHAR8_T,
    CHAR16_T,
    CHAR32_T,
    WCHAR_T,
    SHORT,
    INT,
    LONG,
    SIZE_T,
    PTRDIFF_T,
    POINTER,
    LONG_LONG,
    INT128_T,
    FLOAT,
    DOUBLE,
    LONG_DOUBLE;

    @NotNull
    private final OCCompilerFeatures.TypeSize mySizeKey;

    private CTypeId(OCCompilerFeatures.TypeSize typeSize) {
        this.mySizeKey = typeSize;
    }

    private CTypeId() {
        this.mySizeKey = OCCompilerFeatures.TypeSize.valueOf((String)this.name());
    }

    public short getBytes(@Nullable PsiFile file, @Nullable OCInclusionContext context) {
        return (Short)OCCompilerFeaturesHelper.getFeatureForFile(file, context, this.mySizeKey);
    }

    public OCCompilerFeatures.TypeSize getDefaultTypeSize() {
        return this.mySizeKey;
    }

    public static boolean isImproperType(CTypeId type) {
        return type == SIZE_T || type == PTRDIFF_T;
    }
}

