/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.MetaData;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationAttributeService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationServiceImpl
implements SerializationService {
    private static final Logger LOG = Logger.getInstance(SerializationServiceImpl.class);
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute:";
    private static final FileAttribute ourFileTablesMetaAttribute = new FileAttribute("objc_file_symbol_tables_meta_attribute", FileSymbolTableSerializationVersion.INSTANCE.getVersion(), false);
    private final Stack<FileSymbolTableSerializer> mySerializerPool = new Stack();

    @Override
    public void serializeTables(@NotNull Project project, @NotNull String projectLocationHash, @NotNull Map<VirtualFile, FileSymbolTablesPack> tables, @NotNull ProgressIndicator indicator) {
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue2 = new ConcurrentLinkedQueue<VirtualFile>(tables.keySet());
        String keyForSerialization = this.getKeyForSerialization(projectLocationHash);
        FileAttribute cacheAttribute = this.getFileCacheAttributeForProjectKey(keyForSerialization);
        String basePath = project.getBasePath();
        LOG.assertTrue(basePath != null);
        this.performAsynchronously(project, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)serializer -> {
            VirtualFile file;
            boolean ok = true;
            while (ok && (file = (VirtualFile)queue2.poll()) != null) {
                indicator.checkCanceled();
                VirtualFile finalFile = file;
                ok = (Boolean)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    if (SerializationServiceImpl.shouldSerializeTable(finalFile)) {
                        try {
                            MetaData metaData = this.readMetaData((NotNullLazyValue<FileSymbolTableSerializer>)serializer, finalFile);
                            metaData.registerProject(projectLocationHash, basePath);
                            SerializationServiceImpl.writeMetaData((FileSymbolTableSerializer)((Object)((Object)((Object)serializer.getValue()))), finalFile, metaData);
                            FileSymbolTablesPack pack = (FileSymbolTablesPack)tables.get(finalFile);
                            SerializationServiceImpl.writePack(pack, finalFile, (FileSymbolTableSerializer)((Object)((Object)((Object)serializer.getValue()))), cacheAttribute);
                        }
                        catch (IOException e) {
                            LOG.error("Can't serialize file symbol table", (Throwable)e);
                            return false;
                        }
                    }
                    return true;
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    @Override
    @NotNull
    public Map<VirtualFile, FileSymbolTablesPack> deserializeTables(@NotNull Project project, @NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project);
        HashSet processedFiles = new HashSet();
        Set notLoaded = ContainerUtil.newConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset2 = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ContainerUtil.newConcurrentSet();
        MultiMap importsMap = new MultiMap();
        ConcurrentHashMap<VirtualFile, FileSymbolTablesPack> result = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
        long total = notLoaded.size();
        this.performAsynchronously(project, indicator, (Consumer<NotNullLazyValue<FileSymbolTableSerializer>>)((Consumer)serializer -> {
            try {
                SerializationSession session = new SerializationSession(projectLocationHash);
                while (true) {
                    VirtualFile file;
                    indicator.checkCanceled();
                    ArrayDeque arrayDeque = workset2;
                    synchronized (arrayDeque) {
                        if (workset2.isEmpty()) {
                            return;
                        }
                        file = (VirtualFile)workset2.pop();
                        if (!processedFiles.add(file)) {
                            continue;
                        }
                    }
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)ReadAction.compute(() -> {
                        indicator.checkCanceled();
                        if (!SerializationServiceImpl.shouldSerializeTable(file)) {
                            return null;
                        }
                        FileSymbolTablesPack p = this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer, session, file);
                        if (p == null) {
                            dirtySet.add(file);
                        }
                        return p;
                    });
                    if (pack == null) continue;
                    notLoaded.remove(file);
                    indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                    if (pack.isEmpty()) continue;
                    for (FileSymbolTable table : pack.tablesView()) {
                        table.processIncludes((Processor<? super OCSymbol>)((Processor)include -> {
                            ModuleMapManager.Cache cache;
                            ModuleMapSymbol module;
                            QualifiedName moduleName;
                            indicator.checkCanceled();
                            if (include instanceof OCIncludeSymbol) {
                                VirtualFile targetFile;
                                OCIncludeSymbol inc = (OCIncludeSymbol)include;
                                if (inc.isSymbolTableUsed() && (targetFile = inc.getTargetFile()) != null) {
                                    ArrayDeque arrayDeque = workset2;
                                    synchronized (arrayDeque) {
                                        workset2.push(targetFile);
                                        importsMap.putValue((Object)targetFile, (Object)file);
                                    }
                                }
                            } else if (include instanceof OCModuleImportSymbol && (moduleName = ((OCModuleImportSymbol)include).getModuleName()) != null && (module = (ModuleMapSymbol)ReadAction.compute(() -> SerializationServiceImpl.lambda$deserializeTables$3(cache = moduleMapManager.getGlobalCache(), moduleName))) != null) {
                                ArrayDeque arrayDeque = workset2;
                                synchronized (arrayDeque) {
                                    for (VirtualFile header : module.getIncludeHeaders()) {
                                        workset2.push(header);
                                        importsMap.putValue((Object)header, (Object)file);
                                    }
                                }
                            }
                            return true;
                        }));
                    }
                    result.put(file, pack);
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
                return;
            }
        }));
        workset2.addAll(dirtySet);
        while (!workset2.isEmpty()) {
            VirtualFile file = workset2.pop();
            for (VirtualFile dep : importsMap.get((Object)file)) {
                if (!dirtySet.add(dep)) continue;
                workset2.push(dep);
            }
        }
        for (VirtualFile file : dirtySet) {
            result.remove(file);
        }
        return result;
    }

    private void performAsynchronously(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Consumer<NotNullLazyValue<FileSymbolTableSerializer>> task) {
        Application application = ApplicationManager.getApplication();
        OCLog.LOG.assertTrue(application.isDispatchThread() || !application.isReadAccessAllowed() || indicator == ProgressManager.getInstance().getProgressIndicator());
        ArrayList futures = new ArrayList();
        OCBuildingActivityExecutionService executionService = OCBuildingActivityExecutionService.Companion.getInstance();
        ForkJoinPool executor = executionService.getExecutor();
        int threadCount = executionService.getThreadCount();
        for (int i = 0; i < threadCount; ++i) {
            futures.add(executor.submit(() -> {
                FileSymbolTableSerializer serializer = this.borrowSerializer(project);
                try {
                    task.consume((Object)NotNullLazyValue.createConstantValue((Object)((Object)serializer)));
                }
                finally {
                    this.returnSerializer(serializer);
                }
            }));
        }
        SmartList exceptions = new SmartList();
        for (Future future : futures) {
            try {
                ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future, (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable t) {
                exceptions.add(t.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file) {
        return file.isValid() && file instanceof VirtualFileWithId && !file.isDirectory();
    }

    @NotNull
    private String getKeyForSerialization(@NotNull String projectLocationHash) {
        return TABLES_KEY_PREFIX + projectLocationHash;
    }

    @NotNull
    private FileAttribute getFileCacheAttributeForProjectKey(@NotNull String key) {
        return SerializationAttributeService.getInstance().getFileCacheAttributeForProjectKey(key, FileSymbolTableSerializationVersion.INSTANCE.getVersion());
    }

    @Nullable
    private FileSymbolTablesPack readTablesForFile(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull SerializationSession session, @NotNull VirtualFile file) throws IOException {
        boolean metaDataChanged;
        String lastLocationHash;
        String keyForSerialization;
        FileSymbolTablesPack pack = null;
        MetaData metaData = this.readMetaData(serializer, file);
        boolean upToDate = metaData.isFileUpToDate();
        if (upToDate && (pack = this.readPack(serializer, keyForSerialization = this.getKeyForSerialization(session.getProjectLocationHash()), file)) == null && (lastLocationHash = metaData.getMostRecentLocationHash()) != null && (pack = this.readPack(serializer, keyForSerialization = this.getKeyForSerialization(lastLocationHash), file)) != null) {
            pack.markAsFallback();
        }
        if (metaDataChanged = metaData.evictProjects((projectKey, projectPath) -> {
            if (upToDate && session.projectExists(projectPath)) {
                return false;
            }
            FileAttribute attribute2 = this.getFileCacheAttributeForProjectKey(projectKey);
            attribute2.writeFileAttribute(file).close();
            return true;
        })) {
            SerializationServiceImpl.writeMetaData((FileSymbolTableSerializer)((Object)serializer.getValue()), file, metaData);
        }
        return pack;
    }

    @Nullable
    private FileSymbolTablesPack readPack(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull String keyForSerialization, @NotNull VirtualFile file) throws IOException {
        FileAttribute attribute2 = this.getFileCacheAttributeForProjectKey(keyForSerialization);
        try (AttributeInputStream dis = attribute2.readFileAttribute(file);){
            if (dis == null || dis.available() == 0) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long metaIndicesVersion = dis.readLong();
            if (metaIndicesVersion != FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            long savedTimestamp = dis.readLong();
            if (savedTimestamp != file.getTimeStamp()) {
                FileSymbolTablesPack fileSymbolTablesPack = null;
                return fileSymbolTablesPack;
            }
            FileSymbolTablesPack fileSymbolTablesPack = ((FileSymbolTableSerializer)((Object)serializer.getValue())).readSymbolTables((DataInputStream)dis, file);
            return fileSymbolTablesPack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePack(@NotNull FileSymbolTablesPack pack, @NotNull VirtualFile finalFile, @NotNull FileSymbolTableSerializer serializer, @NotNull FileAttribute cacheAttribute) throws IOException {
        try (AttributeOutputStream dos = cacheAttribute.writeFileAttribute(finalFile);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(finalFile.getTimeStamp());
            Object object = pack.getTablesAccessLock();
            synchronized (object) {
                serializer.writeSymbolTables((DataOutputStream)dos, pack);
                pack.setSerialized();
            }
        }
    }

    @NotNull
    private MetaData readMetaData(@NotNull NotNullLazyValue<FileSymbolTableSerializer> serializer, @NotNull VirtualFile file) throws IOException {
        try (AttributeInputStream dis = ourFileTablesMetaAttribute.readFileAttribute(file);){
            if (dis == null || dis.available() == 0) {
                MetaData metaData = new MetaData();
                return metaData;
            }
            long metaIndicesVersion = dis.readLong();
            long metaFileTimestamp = dis.readLong();
            boolean isUpToDate = metaIndicesVersion == FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion();
            isUpToDate = isUpToDate && metaFileTimestamp == file.getTimeStamp();
            MetaData metaData = ((FileSymbolTableSerializer)((Object)serializer.getValue())).readMetaData((DataInputStream)dis);
            if (metaData == null) {
                MetaData metaData2 = new MetaData();
                return metaData2;
            }
            metaData.setFileUpToDate(isUpToDate);
            MetaData metaData3 = metaData;
            return metaData3;
        }
    }

    private static void writeMetaData(@NotNull FileSymbolTableSerializer serializer, @NotNull VirtualFile file, @NotNull MetaData metaData) throws IOException {
        try (AttributeOutputStream dos = ourFileTablesMetaAttribute.writeFileAttribute(file);){
            dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
            dos.writeLong(file.getTimeStamp());
            serializer.writeMetaData((DataOutputStream)dos, metaData);
        }
    }

    @Override
    @Nullable
    public FileSymbolTablesPack deserializeTables(@NotNull Project project, @NotNull SerializationSession session, @NotNull VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (FileSymbolTablesPack)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            NotNullLazyValue serializer = NotNullLazyValue.lazy(() -> this.borrowSerializer(project));
            try {
                FileSymbolTablesPack p = this.readTablesForFile((NotNullLazyValue<FileSymbolTableSerializer>)serializer, session, file);
                if (p != null && !p.isEmpty()) {
                    FileSymbolTablesPack fileSymbolTablesPack = p;
                    return fileSymbolTablesPack;
                }
            }
            catch (IOException e) {
                LOG.error("Can't deserialize file symbol table", (Throwable)e);
            }
            finally {
                if (serializer.isComputed()) {
                    this.returnSerializer((FileSymbolTableSerializer)((Object)((Object)serializer.getValue())));
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileSymbolTableSerializer borrowSerializer(@NotNull Project project) {
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        synchronized (stack) {
            FileSymbolTableSerializer result = (FileSymbolTableSerializer)((Object)this.mySerializerPool.tryPop());
            if (result == null) {
                result = new FileSymbolTableSerializer();
            }
            result.setProject(project);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSerializer(@NotNull FileSymbolTableSerializer serializer) {
        Stack<FileSymbolTableSerializer> stack = this.mySerializerPool;
        synchronized (stack) {
            serializer.setProject(null);
            serializer.compact();
            this.mySerializerPool.push((Object)serializer);
        }
    }

    private static /* synthetic */ ModuleMapSymbol lambda$deserializeTables$3(ModuleMapManager.Cache cache, QualifiedName moduleName) throws RuntimeException {
        return cache.findModule(moduleName);
    }
}

