/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.scheduling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCAdditionalFileSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.SymbolScheduler;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.UtilKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CoroutineSymbolScheduler;", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/SymbolScheduler;", "cache", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;", "estimatedWorksetSize", "", "(Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;I)V", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "workerQuota", "process", "", "filesToProcess", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "symbolProcessor", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "Context", "intellij.c"})
public final class CoroutineSymbolScheduler
implements SymbolScheduler {
    @NotNull
    private final FileSymbolTablesCache cache;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    private final int workerQuota;

    public CoroutineSymbolScheduler(@NotNull FileSymbolTablesCache cache, int estimatedWorksetSize) {
        this.cache = cache;
        this.moduleMapManager = ModuleMapManager.Companion.getInstance(this.cache.getProject());
        this.workerQuota = UtilKt.calculateWorkerQuota(estimatedWorksetSize);
    }

    @Override
    public void process(@NotNull Set<? extends VirtualFile> filesToProcess, @NotNull Processor<OCSymbol> symbolProcessor) {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, filesToProcess, symbolProcessor, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CoroutineSymbolScheduler this$0;
            final /* synthetic */ Set<VirtualFile> $filesToProcess;
            final /* synthetic */ Processor<OCSymbol> $symbolProcessor;
            {
                this.this$0 = $receiver;
                this.$filesToProcess = $filesToProcess;
                this.$symbolProcessor = $symbolProcessor;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlockingCancellable = (CoroutineScope)this.L$0;
                        Object object2 = ProgressManager.getInstance();
                        CoreProgressManager coreProgressManager = object2 instanceof CoreProgressManager ? (CoreProgressManager)object2 : null;
                        Context context = this.this$0.new Context($this$runBlockingCancellable, coreProgressManager != null ? coreProgressManager.isCurrentThreadPrioritized() : false, this.$filesToProcess, this.$symbolProcessor);
                        object2 = this.$filesToProcess;
                        Context $this$invokeSuspend_u24lambda_u240 = context;
                        boolean bl = false;
                        Context.startProcessing$default($this$invokeSuspend_u24lambda_u240, $this$runBlockingCancellable, (Set)object2, false, 2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ ModuleMapManager access$getModuleMapManager$p(CoroutineSymbolScheduler $this) {
        return $this.moduleMapManager;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u00020\u0017*\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J$\u0010\u001b\u001a\u00020\u0017*\u00020\u00042\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\"\u0010\u001d\u001a\u00020\u0017*\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u001e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a(\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u000e \u000f*\u0012\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u000e0\b\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0010\u001a(\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u000e \u000f*\u0012\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u000e0\b\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CoroutineSymbolScheduler$Context;", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "callerScope", "Lkotlinx/coroutines/CoroutineScope;", "shouldPrioritize", "", "initialFilesToProcess", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "symbolProcessor", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CoroutineSymbolScheduler;Lkotlinx/coroutines/CoroutineScope;ZLjava/util/Set;Lcom/intellij/util/Processor;)V", "processed", "", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "processedModules", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "process", "symbol", "processModule", "Lcom/jetbrains/cidr/lang/symbols/objc/OCModuleImportSymbol;", "launchProcessing", "", "filesToProcess", "Lcom/google/common/collect/ImmutableList;", "expedite", "processFiles", "initialWorkset", "startProcessing", "mayExpedite", "intellij.c"})
    private final class Context
    implements Processor<OCSymbol> {
        @NotNull
        private final CoroutineScope callerScope;
        private final boolean shouldPrioritize;
        @NotNull
        private final Processor<OCSymbol> symbolProcessor;
        @NotNull
        private final Set<VirtualFile> processed;
        @NotNull
        private final Set<QualifiedName> processedModules;

        /*
         * WARNING - void declaration
         */
        public Context(CoroutineScope callerScope, @NotNull boolean shouldPrioritize, @NotNull Set<? extends VirtualFile> initialFilesToProcess, Processor<OCSymbol> symbolProcessor) {
            void $this$processed_u24lambda_u240;
            Set set;
            this.callerScope = callerScope;
            this.shouldPrioritize = shouldPrioritize;
            this.symbolProcessor = symbolProcessor;
            Set set2 = set = ContainerUtil.newConcurrentSet();
            Context context = this;
            boolean bl = false;
            $this$processed_u24lambda_u240.addAll((Collection)initialFilesToProcess);
            context.processed = set;
            this.processedModules = ContainerUtil.newConcurrentSet();
        }

        public final void startProcessing(@NotNull CoroutineScope $this$startProcessing, @NotNull Set<? extends VirtualFile> filesToProcess, boolean mayExpedite) {
            if (filesToProcess.isEmpty()) {
                return;
            }
            ImmutableList.Builder readyForProcessing = ImmutableList.builderWithExpectedSize((int)filesToProcess.size());
            ImmutableList.Builder withAdditionalTables = ImmutableList.builderWithExpectedSize((int)filesToProcess.size());
            for (VirtualFile virtualFile : filesToProcess) {
                ImmutableList.Builder builder2;
                ProgressManager.checkCanceled();
                boolean bl = OCAdditionalFileSymbolTableBuilder.Companion.shouldBuildAdditionalTables(CoroutineSymbolScheduler.this.cache.getProject(), virtualFile);
                if (!bl) {
                    builder2 = readyForProcessing;
                } else if (bl) {
                    builder2 = withAdditionalTables;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                builder2.add((Object)virtualFile);
            }
            ImmutableList filesWithAdditionalTables = withAdditionalTables.build();
            ImmutableList immutableList = readyForProcessing.build();
            if (!((Collection)immutableList).isEmpty()) {
                this.launchProcessing($this$startProcessing, (ImmutableList<VirtualFile>)immutableList, mayExpedite && filesWithAdditionalTables.isEmpty());
            }
            if (!((Collection)filesWithAdditionalTables).isEmpty()) {
                for (VirtualFile file : filesWithAdditionalTables) {
                    ProgressManager.checkCanceled();
                    OCAdditionalFileSymbolTableBuilder.Companion.buildAllAdditionalTables(CoroutineSymbolScheduler.this.cache.getProject(), file);
                }
                this.launchProcessing($this$startProcessing, (ImmutableList<VirtualFile>)filesWithAdditionalTables, mayExpedite && immutableList.isEmpty());
            }
        }

        public static /* synthetic */ void startProcessing$default(Context context, CoroutineScope coroutineScope, Set set, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            context.startProcessing(coroutineScope, set, bl);
        }

        private final void launchProcessing(CoroutineScope $this$launchProcessing, ImmutableList<VirtualFile> filesToProcess, boolean expedite) {
            CoroutineStart start = expedite ? CoroutineStart.UNDISPATCHED : CoroutineStart.DEFAULT;
            BuildersKt.launch((CoroutineScope)$this$launchProcessing, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)start, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, filesToProcess, expedite, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Context this$0;
                final /* synthetic */ ImmutableList<VirtualFile> $filesToProcess;
                final /* synthetic */ boolean $expedite;
                {
                    this.this$0 = $receiver;
                    this.$filesToProcess = $filesToProcess;
                    this.$expedite = $expedite;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            Context.access$processFiles(this.this$0, $this$launch, this.$filesToProcess, this.$expedite);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final void processFiles(CoroutineScope $this$processFiles, ImmutableList<? extends VirtualFile> initialWorkset, boolean expedite) {
            void shouldPrioritize$iv;
            boolean bl = !expedite && this.shouldPrioritize;
            CoroutineSymbolScheduler coroutineSymbolScheduler = CoroutineSymbolScheduler.this;
            boolean $i$f$prioritize = false;
            if (shouldPrioritize$iv != false) {
                ProgressManager.getInstance().computePrioritized(new ThrowableComputable(expedite, (ImmutableList)initialWorkset, coroutineSymbolScheduler, this, $this$processFiles){
                    final /* synthetic */ boolean $expedite$inlined;
                    final /* synthetic */ ImmutableList $initialWorkset$inlined;
                    final /* synthetic */ CoroutineSymbolScheduler this$0;
                    final /* synthetic */ Context this$1$inlined;
                    final /* synthetic */ CoroutineScope $this_processFiles$inlined;
                    {
                        this.$expedite$inlined = bl;
                        this.$initialWorkset$inlined = immutableList;
                        this.this$0 = coroutineSymbolScheduler;
                        this.this$1$inlined = context;
                        this.$this_processFiles$inlined = coroutineScope;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Unit compute() {
                        Pair pair;
                        ImmutableList<I> immutableList;
                        boolean bl = false;
                        if (this.$expedite$inlined) {
                            immutableList = UtilKt.peekWorkset(this.$initialWorkset$inlined, CoroutineSymbolScheduler.access$getWorkerQuota$p(this.this$0), (Function1)new Function1<ImmutableList<? extends VirtualFile>, Unit>(this.$this_processFiles$inlined, this.this$1$inlined){
                                final /* synthetic */ CoroutineScope $this_processFiles;
                                final /* synthetic */ Context this$0;
                                {
                                    this.$this_processFiles = $receiver;
                                    this.this$0 = $receiver2;
                                    super(1);
                                }

                                public final void invoke(@NotNull ImmutableList<? extends VirtualFile> it) {
                                    BuildersKt.launch$default((CoroutineScope)this.$this_processFiles, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                        int label;
                                        private /* synthetic */ Object L$0;
                                        final /* synthetic */ Context this$0;
                                        final /* synthetic */ ImmutableList<? extends VirtualFile> $it;
                                        {
                                            this.this$0 = $receiver;
                                            this.$it = $it;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                    Context.access$processFiles(this.this$0, $this$launch, this.$it, false);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value;
                                            return (Continuation)var3_3;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            });
                        } else {
                            void $this$splitWorkset$iv;
                            ImmutableList immutableList2 = this.$initialWorkset$inlined;
                            int quota$iv = CoroutineSymbolScheduler.access$getWorkerQuota$p(this.this$0);
                            boolean $i$f$splitWorkset = false;
                            ImmutableList workset$iv = $this$splitWorkset$iv;
                            while (true) {
                                ImmutableList right$iv;
                                if (UtilKt.access$splitWorkset(workset$iv, quota$iv) == null) {
                                    immutableList = workset$iv;
                                    break;
                                }
                                ImmutableList left$iv = (ImmutableList)pair.component1();
                                ImmutableList it = right$iv = (ImmutableList)pair.component2();
                                boolean bl2 = false;
                                BuildersKt.launch$default((CoroutineScope)this.$this_processFiles$inlined, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1$inlined, (ImmutableList<? extends VirtualFile>)it, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ Context this$0;
                                    final /* synthetic */ ImmutableList<? extends VirtualFile> $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                Context.access$processFiles(this.this$0, $this$launch, this.$it, false);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                workset$iv = left$iv;
                            }
                        }
                        ImmutableList<I> workset2 = immutableList;
                        for (VirtualFile file : workset2) {
                            for (FileSymbolTable table : CoroutineSymbolScheduler.access$getCache$p(this.this$0).allTablesForFile(file)) {
                                ProgressManager.checkCanceled();
                                pair = table.getSignature().getLanguageKind();
                                if (!(pair instanceof CLanguageKind ? true : pair instanceof CUDALanguageKind)) continue;
                                table.processFile((Processor<? super OCSymbol>)((Processor)this.this$1$inlined));
                            }
                        }
                        return Unit.INSTANCE;
                    }
                });
            } else {
                Pair pair;
                ImmutableList immutableList;
                boolean bl2 = false;
                if (expedite) {
                    immutableList = UtilKt.peekWorkset(initialWorkset, coroutineSymbolScheduler.workerQuota, (Function1)new /* invalid duplicate definition of identical inner class */);
                } else {
                    void $this$splitWorkset$iv;
                    UnmodifiableIterator unmodifiableIterator = initialWorkset;
                    int quota$iv = coroutineSymbolScheduler.workerQuota;
                    boolean $i$f$splitWorkset = false;
                    ImmutableList workset$iv = $this$splitWorkset$iv;
                    while (true) {
                        ImmutableList right$iv;
                        if (UtilKt.access$splitWorkset(workset$iv, quota$iv) == null) {
                            immutableList = workset$iv;
                            break;
                        }
                        ImmutableList left$iv = (ImmutableList)pair.component1();
                        ImmutableList it = right$iv = (ImmutableList)pair.component2();
                        boolean bl3 = false;
                        BuildersKt.launch$default((CoroutineScope)$this$processFiles, null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                        workset$iv = left$iv;
                    }
                }
                ImmutableList workset2 = immutableList;
                for (VirtualFile file : workset2) {
                    for (FileSymbolTable table : coroutineSymbolScheduler.cache.allTablesForFile(file)) {
                        ProgressManager.checkCanceled();
                        pair = table.getSignature().getLanguageKind();
                        if (!(pair instanceof CLanguageKind ? true : pair instanceof CUDALanguageKind)) continue;
                        table.processFile((Processor<? super OCSymbol>)((Processor)this));
                    }
                }
            }
        }

        public boolean process(@NotNull OCSymbol symbol) {
            return symbol instanceof OCModuleImportSymbol ? this.processModule((OCModuleImportSymbol)symbol) : this.symbolProcessor.process((Object)symbol);
        }

        private final boolean processModule(OCModuleImportSymbol symbol) {
            QualifiedName moduleName = symbol.getModuleName();
            if (moduleName == null || !this.processedModules.add(moduleName)) {
                return true;
            }
            BuildersKt.launch$default((CoroutineScope)this.callerScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(CoroutineSymbolScheduler.this, this, moduleName, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CoroutineSymbolScheduler this$0;
                final /* synthetic */ Context this$1;
                final /* synthetic */ QualifiedName $moduleName;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$moduleName = $moduleName;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            Set additionalFiles = new LinkedHashSet<E>();
                            ModuleMapManager.Cache globalCache = CoroutineSymbolScheduler.access$getModuleMapManager$p(this.this$0).getGlobalCache();
                            QualifiedName qualifiedName = this.$moduleName;
                            boolean $i$f$runReadAction = false;
                            ModuleMapSymbol moduleMapSymbol = (ModuleMapSymbol)ApplicationManager.getApplication().runReadAction(new Computable(globalCache, qualifiedName){
                                final /* synthetic */ ModuleMapManager.Cache $globalCache$inlined;
                                final /* synthetic */ QualifiedName $moduleName$inlined;
                                {
                                    this.$globalCache$inlined = cache;
                                    this.$moduleName$inlined = qualifiedName;
                                }

                                public final T compute() {
                                    boolean bl = false;
                                    return (T)this.$globalCache$inlined.findModule(this.$moduleName$inlined);
                                }
                            });
                            if (moduleMapSymbol == null) {
                                return Unit.INSTANCE;
                            }
                            ModuleMapSymbol module = moduleMapSymbol;
                            for (VirtualFile header : module.getIncludeHeaders()) {
                                ProgressManager.checkCanceled();
                                if (!Context.access$getProcessed$p(this.this$1).add(header)) continue;
                                additionalFiles.add(header);
                            }
                            this.this$1.startProcessing($this$launch, additionalFiles, false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return true;
        }

        public static final /* synthetic */ void access$processFiles(Context $this, CoroutineScope $receiver, ImmutableList initialWorkset, boolean expedite) {
            $this.processFiles($receiver, (ImmutableList<? extends VirtualFile>)initialWorkset, expedite);
        }

        public static final /* synthetic */ Set access$getProcessed$p(Context $this) {
            return $this.processed;
        }
    }
}

