/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.scheduling;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCAdditionalFileSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.CallerAwareJob;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.SymbolScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountedCompleter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler;", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/SymbolScheduler;", "cache", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;", "estimatedWorksetSize", "", "(Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;I)V", "process", "", "filesToProcess", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "symbolProcessor", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "MyJob", "intellij.c"})
public final class CallerAwareSymbolScheduler
implements SymbolScheduler {
    @NotNull
    private final FileSymbolTablesCache cache;
    private final int estimatedWorksetSize;

    public CallerAwareSymbolScheduler(@NotNull FileSymbolTablesCache cache, int estimatedWorksetSize) {
        this.cache = cache;
        this.estimatedWorksetSize = estimatedWorksetSize;
    }

    @Override
    public void process(@NotNull Set<? extends VirtualFile> filesToProcess, @NotNull Processor<OCSymbol> symbolProcessor) {
        new MyJob(this.cache, this.estimatedWorksetSize, symbolProcessor).process(filesToProcess);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003\u0018\u0019\u001aB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\r\u001a(\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u0010 \u0012*\u0012\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u00100\u0011\u00a2\u0006\u0002\b\u00100\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0013\u001a(\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u0010 \u0012*\u0012\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00100\u0011\u00a2\u0006\u0002\b\u00100\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob;", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "Ljava/lang/Void;", "cache", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;", "estimatedWorksetSize", "", "processor", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache;ILcom/intellij/util/Processor;)V", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "processed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "processedModules", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "process", "", "filesToProcess", "AdditionalTablesWorker", "FileWorker", "ModuleWorker", "intellij.c"})
    private static final class MyJob
    extends CallerAwareJob<Void> {
        @NotNull
        private final FileSymbolTablesCache cache;
        @NotNull
        private final Processor<OCSymbol> processor;
        @NotNull
        private final ModuleMapManager moduleMapManager;
        @NotNull
        private final Set<VirtualFile> processed;
        @NotNull
        private final Set<QualifiedName> processedModules;

        public MyJob(@NotNull FileSymbolTablesCache cache, int estimatedWorksetSize, @NotNull Processor<OCSymbol> processor2) {
            super(estimatedWorksetSize);
            this.cache = cache;
            this.processor = processor2;
            this.moduleMapManager = ModuleMapManager.Companion.getInstance(this.cache.getProject());
            this.processed = ContainerUtil.newConcurrentSet();
            this.processedModules = ContainerUtil.newConcurrentSet();
        }

        public final void process(@NotNull Set<? extends VirtualFile> filesToProcess) {
            this.processed.addAll((Collection<VirtualFile>)filesToProcess);
            this.run(new FileWorker(null, (ImmutableList<? extends VirtualFile>)ImmutableList.copyOf((Collection)filesToProcess)));
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003B#\u0012\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u00060\u0000R\u00020\u000f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\bH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\bH\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob$FileWorker;", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "Ljava/lang/Void;", "parent", "Ljava/util/concurrent/CountedCompleter;", "workset", "Lcom/google/common/collect/ImmutableList;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "additionalModulesWorkset", "", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "additionalTablesWorkset", "newWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob;", "process", "", "processingFinished", "intellij.c"})
        private final class FileWorker
        extends CallerAwareJob.IterativeWorker<VirtualFile> {
            @NotNull
            private final List<QualifiedName> additionalModulesWorkset;
            @NotNull
            private final List<VirtualFile> additionalTablesWorkset;

            public FileWorker(@NotNull CountedCompleter<?> parent, ImmutableList<? extends VirtualFile> workset2) {
                super(parent, workset2);
                this.additionalModulesWorkset = new ArrayList();
                this.additionalTablesWorkset = new ArrayList();
            }

            @NotNull
            protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset2) {
                return new FileWorker((CountedCompleter)this, workset2);
            }

            @Override
            protected void process(@NotNull ImmutableList<? extends VirtualFile> workset2) {
                Processor symbolProcessor = arg_0 -> FileWorker.process$lambda$0(MyJob.this, this, arg_0);
                for (VirtualFile file : workset2) {
                    if (OCAdditionalFileSymbolTableBuilder.Companion.shouldBuildAdditionalTables(MyJob.this.cache.getProject(), file)) {
                        this.additionalTablesWorkset.add(file);
                        continue;
                    }
                    for (FileSymbolTable table : MyJob.this.cache.allTablesForFile(file)) {
                        if (!(table.getSignature().getLanguageKind() instanceof CLanguageKind) && !(table.getSignature().getLanguageKind() instanceof CUDALanguageKind)) continue;
                        table.processFile((Processor<? super OCSymbol>)symbolProcessor);
                    }
                }
            }

            @Override
            protected void processingFinished() {
                if (!this.additionalModulesWorkset.isEmpty()) {
                    MyJob.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
                }
                if (!this.additionalTablesWorkset.isEmpty()) {
                    MyJob.this.scheduleOnCallerAsPending(this, new AdditionalTablesWorker(this, (ImmutableList<VirtualFile>)ImmutableList.copyOf((Collection)this.additionalTablesWorkset)));
                }
                this.propagateCompletion();
            }

            private static final boolean process$lambda$0(MyJob this$0, FileWorker this$1, OCSymbol symbol) {
                if (symbol instanceof OCModuleImportSymbol) {
                    QualifiedName moduleName = ((OCModuleImportSymbol)symbol).getModuleName();
                    if (moduleName != null && this$0.processedModules.add(moduleName)) {
                        this$1.additionalModulesWorkset.add(moduleName);
                    }
                } else {
                    return this$0.processor.process((Object)symbol);
                }
                return true;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob$AdditionalTablesWorker;", "Ljava/util/concurrent/CountedCompleter;", "Ljava/lang/Void;", "parent", "workset", "Lcom/google/common/collect/ImmutableList;", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "compute", "", "intellij.c"})
        private final class AdditionalTablesWorker
        extends CountedCompleter<Void> {
            @NotNull
            private final ImmutableList<VirtualFile> workset;

            public AdditionalTablesWorker(@NotNull CountedCompleter<?> parent, ImmutableList<VirtualFile> workset2) {
                super(parent);
                this.workset = workset2;
            }

            @Override
            public void compute() {
                for (VirtualFile file : this.workset) {
                    Project project = MyJob.this.cache.getProject();
                    VirtualFile virtualFile = file;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    OCAdditionalFileSymbolTableBuilder.Companion.buildAllAdditionalTables(project, virtualFile);
                }
                MyJob.this.forkAsPending(this, new FileWorker((CountedCompleter)this, this.workset));
                this.propagateCompletion();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob$ModuleWorker;", "Ljava/util/concurrent/CountedCompleter;", "Ljava/lang/Void;", "parent", "workset", "", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareSymbolScheduler$MyJob;Ljava/util/concurrent/CountedCompleter;Ljava/util/List;)V", "compute", "", "intellij.c"})
        private final class ModuleWorker
        extends CountedCompleter<Void> {
            @NotNull
            private final List<QualifiedName> workset;

            public ModuleWorker(@NotNull CountedCompleter<?> parent, List<QualifiedName> workset2) {
                super(parent);
                this.workset = workset2;
            }

            @Override
            public void compute() {
                ImmutableList.Builder additionalFiles = ImmutableList.builder();
                for (QualifiedName moduleName : this.workset) {
                    ModuleMapSymbol module;
                    ProgressManager.checkCanceled();
                    ModuleMapManager.Cache globalCache = MyJob.this.moduleMapManager.getGlobalCache();
                    boolean $i$f$runReadAction = false;
                    if ((ModuleMapSymbol)ApplicationManager.getApplication().runReadAction(new Computable(globalCache, moduleName){
                        final /* synthetic */ ModuleMapManager.Cache $globalCache$inlined;
                        final /* synthetic */ QualifiedName $moduleName$inlined;
                        {
                            this.$globalCache$inlined = cache;
                            this.$moduleName$inlined = qualifiedName;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)this.$globalCache$inlined.findModule(this.$moduleName$inlined);
                        }
                    }) == null) continue;
                    for (VirtualFile header : module.getIncludeHeaders()) {
                        if (!MyJob.this.processed.add(header)) continue;
                        additionalFiles.add((Object)header);
                    }
                }
                ImmutableList additionalWorkset = additionalFiles.build();
                if (!additionalWorkset.isEmpty()) {
                    MyJob.this.forkAsPending(this, new FileWorker((CountedCompleter)this, (ImmutableList<? extends VirtualFile>)additionalWorkset));
                }
                this.propagateCompletion();
            }
        }
    }
}

