/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolBuildingTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SingleTaskExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AtomicInteger myTaskCount = new AtomicInteger();
    @NotNull
    private final Object myLastTaskLock = ObjectUtils.sentinel((String)"todo");
    @Nullable
    private volatile SymbolBuildingTask myLastTask;
    private volatile int myLastTaskIndex;

    SingleTaskExecutor(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(final @NotNull Consumer<OCBuildingActivityProgressIndicator> task) {
        final int taskNumber = this.myTaskCount.incrementAndGet();
        new SymbolBuildingTask("rebuildSymbols", this.myProject){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                Object object = SingleTaskExecutor.this.myLastTaskLock;
                synchronized (object) {
                    if (taskNumber <= SingleTaskExecutor.this.myLastTaskIndex) {
                        return;
                    }
                    SingleTaskExecutor.this.myLastTask = this;
                    SingleTaskExecutor.this.myLastTaskIndex = SingleTaskExecutor.this.myTaskCount.get();
                }
                task.accept(indicator);
            }
        }.queue(this.myProject);
        Object object = this.myLastTaskLock;
        synchronized (object) {
            SymbolBuildingTask currentTask = this.myLastTask;
            if (currentTask != null && this.myLastTaskIndex < taskNumber) {
                if (currentTask.shouldCancel()) {
                    DumbService.getInstance((Project)this.myProject).cancelTask((DumbModeTask)currentTask);
                }
                this.myLastTask = null;
            }
        }
    }
}

