/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.RobustWorker;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public abstract class OCWorkerActivity
implements OCInitialBuildingActivity {
    @Override
    public void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        Project project = userData.getProject();
        AdditionalTaskProvider<?> taskProvider = this.getProvider(project, (ProgressIndicator)indicator, userData);
        if (taskProvider == null) {
            return;
        }
        try (CidrEventSpan ignored = new CidrEventSpan(taskProvider.getTraceCategory(), taskProvider.getTraceTitle(), null);){
            OCWorkerActivity.processTasks(project, indicator, 0.0, 1.0, taskProvider);
        }
    }

    @Nullable
    public abstract AdditionalTaskProvider<?> getProvider(@NotNull Project var1, @NotNull ProgressIndicator var2, @NotNull OCInitialBuildingInfo var3);

    public static void processTasks(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator, double from, double to, @NotNull TaskProvider<?> taskProvider) {
        OCWorkerActivity.runWithProgress(indicator, taskProvider.getIndicatorText(), from, to, () -> OCWorkerActivity.processFutures(project, indicator, taskProvider));
    }

    public static void runWithProgress(@NotNull OCBuildingActivityProgressIndicator indicator, @NlsContexts.ProgressText @NotNull String indicatorText, double from, double to, @NotNull Runnable task) {
        indicator.setText(indicatorText);
        indicator.startTiming(indicatorText);
        indicator.setIndeterminate(false);
        indicator.setInterval(from, to);
        indicator.setFraction(0.0);
        task.run();
        indicator.setText2(null);
        indicator.logTiming();
    }

    public static void runWithIndeterminateProgress(@NotNull OCBuildingActivityProgressIndicator indicator, @NlsContexts.ProgressText @NotNull String indicatorText, @NotNull Runnable task) {
        indicator.setText(indicatorText);
        indicator.setIndeterminate(true);
        indicator.startTiming(indicatorText);
        task.run();
        indicator.logTiming();
        indicator.setText2(null);
    }

    private static void processFutures(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator, @NotNull TaskProvider<?> taskProvider) {
        List<Future<?>> tasks = OCWorkerActivity.createTasks(taskProvider, (ProgressIndicator)indicator, project);
        for (Future<?> future : tasks) {
            ProgressIndicatorUtils.awaitWithCheckCanceled(future);
        }
        taskProvider.onCompletion();
    }

    @NotNull
    private static <T> List<Future<?>> createTasks(@NotNull TaskProvider<T> taskProvider, final @NotNull ProgressIndicator indicator, @NotNull Project project) {
        OCBuildingActivityExecutionService executionService = OCBuildingActivityExecutionService.Companion.getInstance();
        int threadCount = executionService.getThreadCount();
        ForkJoinPool executor = executionService.getExecutor();
        OCSymbolTablesBuildingActivity projectSymbolTableBuildingActivity = OCSymbolTablesBuildingActivity.getInstance(project);
        ImmutableList.Builder futures = ImmutableList.builderWithExpectedSize((int)threadCount);
        for (int i = 0; i < threadCount; ++i) {
            indicator.checkCanceled();
            final Supplier<T> itemProvider = taskProvider.getItemProvider();
            final Consumer<T> taskWorker = taskProvider.getWorker();
            RobustWorker worker = new RobustWorker<T>(){

                @Override
                @Nullable
                protected T nextItem() {
                    return itemProvider.get();
                }

                @Override
                protected void process(@NotNull T item) {
                    indicator.checkCanceled();
                    taskWorker.consume(item);
                }
            };
            if (!worker.hasNextItem()) continue;
            CancellablePromise future = taskProvider.requiresReadAction() ? ReadAction.nonBlocking((Runnable)OCSymbolTableBuildingUtil.withCustomLoopIndicator(worker)).expireWith((Disposable)projectSymbolTableBuildingActivity).wrapProgress(indicator).submit((Executor)executor) : executor.submit(() -> ProgressManager.getInstance().executeProcessUnderProgress(OCSymbolTableBuildingUtil.withCustomLoopIndicator(worker), indicator));
            futures.add(future);
        }
        return futures.build();
    }

    public static interface AdditionalTaskProvider<T>
    extends TaskProvider<T> {
        @NotNull
        public String getTraceTitle();

        @NotNull
        public String getTraceCategory();
    }

    public static interface TaskProvider<T> {
        public @NotNull Supplier<@Nullable T> getItemProvider();

        @NotNull
        public @NotNull Consumer<@NotNull T> getWorker();

        @NlsContexts.ProgressText
        @NotNull
        public String getIndicatorText();

        default public boolean requiresReadAction() {
            return true;
        }

        default public void onCompletion() {
        }
    }
}

