/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCClearingSymbolsActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCFileCollectingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCHeaderMapLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCIndexingStatisticsCollector;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapDeserializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapSerializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolSavingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.symbols.symtable.building.SingleTaskExecutor;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCSymbolTablesBuildingActivity
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SingleTaskExecutor myExecutor;

    public static OCSymbolTablesBuildingActivity getInstance(@NotNull Project project) {
        return (OCSymbolTablesBuildingActivity)project.getService(OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project) {
        this.myProject = project;
        this.myExecutor = new SingleTaskExecutor(project);
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(OCSymbolTablesBuildingMode.FAST);
    }

    public void rebuildSymbols(@NotNull OCSymbolTablesBuildingMode mode) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myExecutor.schedule(indicator -> this.buildSymbolsInternal((OCBuildingActivityProgressIndicator)((Object)indicator), mode));
    }

    private void buildSymbolsInternal(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCSymbolTablesBuildingMode mode) {
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            AllowedModules.Companion.setRebuildRequired(false);
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        long startTime = System.nanoTime();
        OCInitialBuildingInfo userInfo = new OCInitialBuildingInfo(this.myProject, mode);
        userInfo.setLocationHash(this.myProject.getLocationHash());
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeClearingSymbols", (Object)"");){
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.BeforeClearing);
        }
        OCClearingSymbolsActivity.build(indicator, userInfo);
        OCHeaderMapLoadingActivity.build(indicator, userInfo);
        OCFileCollectingActivity.build(indicator, userInfo);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeClearingSymbols", (Object)"");
        try {
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.AfterFileCollecting);
        }
        finally {
            ignored.close();
        }
        OCModuleMapDeserializationActivity.build(indicator, userInfo);
        OCSymbolLoadingActivity.build(indicator, userInfo);
        OCModuleMapBuildingActivity.build(indicator, userInfo);
        OCModuleMapSerializationActivity.build(indicator, userInfo);
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userInfo.getAllFiles());
        @NonNls String allFilesDescription = allFiles.size() + " project files";
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeSymbolBuilding", (Object)allFilesDescription);){
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.BeforeSymbols);
        }
        OCSymbolBuildingActivity.build(indicator, userInfo);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesAfterSymbolBuilding", (Object)allFilesDescription);
        try {
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.AfterSymbols);
        }
        finally {
            ignored.close();
        }
        Pair<Integer, Integer> fileStats = OCSymbolSavingActivity.build(indicator, userInfo);
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        OCIndexingStatisticsCollector.logSymbolBuilt(mode, durationMs, (Integer)fileStats.first, (Integer)fileStats.second);
        FileSymbolTable.reportStats(this.myProject);
        AllowedModules.Companion.setRebuildRequired(false);
    }

    public void dispose() {
    }
}

