/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCAdditionalFileSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.RobustWorker;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCSymbolTableBuilder {
    @NotNull
    private final OCBuildingActivityProgressIndicator myIndicator;
    @NotNull
    private final Project myProject;
    private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization = new MultiMap();

    OCSymbolTableBuilder(final @NotNull Project project, @NotNull OCBuildingActivityProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files, final boolean isSurrogate) {
        this.myIndicator = progressIndicator;
        this.myProject = project;
        final Iterator<VirtualFile> iterator2 = files.iterator();
        if (!iterator2.hasNext()) {
            return;
        }
        progressIndicator.checkCanceled();
        OCSymbolTableBuildingUtil.runCancelableReadAction(project, (ProgressIndicator)progressIndicator, new RobustWorker<VirtualFile>(){

            @Override
            @Nullable
            protected VirtualFile nextItem() {
                return iterator2.hasNext() ? (VirtualFile)iterator2.next() : null;
            }

            @Override
            protected void process(@NotNull VirtualFile virtualFile) {
                if (!virtualFile.isValid()) {
                    return;
                }
                PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (!(file instanceof OCConfigurationOwner)) {
                    return;
                }
                for (OCResolveConfiguration config : OCResolveConfigurations.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project)) {
                    OCLanguageKind kind = ((OCConfigurationOwner)file).getRootKind(config);
                    OCBuildFileCategory traits = new OCBuildFileCategory(config.getCompilerSettings(kind, virtualFile).getIndexingCluster(), kind);
                    OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(config, virtualFile, isSurrogate);
                    OCSymbolTableBuilder.this.myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                }
            }
        });
    }

    public void processBuildFiles(double from, double to) {
        final int totalFilesCount = this.myClusterization.values().size();
        Set traits = this.myClusterization.keySet();
        final AtomicInteger processedFiles = new AtomicInteger(0);
        final ArrayList<BuildFileProvider> clusterProviders = new ArrayList<BuildFileProvider>();
        HashSet notProcessedFiles = new HashSet();
        for (OCBuildFileCategory t : traits) {
            Collection files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
            notProcessedFiles.addAll(files);
            Iterator clusterIterator = files.iterator();
            clusterProviders.add(() -> {
                while (clusterIterator.hasNext()) {
                    OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                    Set set = notProcessedFiles;
                    synchronized (set) {
                        if (notProcessedFiles.contains(next)) {
                            notProcessedFiles.remove(next);
                            return next;
                        }
                    }
                }
                return null;
            });
        }
        final BuildFileProvider remainingProvider = () -> {
            Set set = notProcessedFiles;
            synchronized (set) {
                if (!notProcessedFiles.isEmpty()) {
                    OCBuildFileDescriptor next = (OCBuildFileDescriptor)notProcessedFiles.iterator().next();
                    notProcessedFiles.remove(next);
                    return next;
                }
            }
            return null;
        };
        final OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        OCWorkerActivity.processTasks(this.myProject, this.myIndicator, from, to, new OCWorkerActivity.TaskProvider<OCBuildFileDescriptor>(){

            @Override
            @NotNull
            public Supplier<OCBuildFileDescriptor> getItemProvider() {
                return new PrioritizedBuildFileProvider(clusterProviders, remainingProvider);
            }

            @Override
            @NotNull
            public Consumer<OCBuildFileDescriptor> getWorker() {
                return descriptor -> {
                    importGraph.buildSymbolAndRootHeaderCache(descriptor.myConfiguration, descriptor.myFile, descriptor.myIsSurrogate, (ProgressIndicator)OCSymbolTableBuilder.this.myIndicator);
                    OCAdditionalFileSymbolTableBuilder.buildAllAdditionalTables(OCSymbolTableBuilder.this.myProject, descriptor.myFile);
                    OCSymbolTableBuilder.this.myIndicator.setFraction((double)processedFiles.incrementAndGet() / (double)totalFilesCount);
                };
            }

            @Override
            @NotNull
            public String getIndicatorText() {
                return OCBundle.message("progress.text.updating.symbols", new Object[0]);
            }
        });
    }

    private static final class OCBuildFileCategory {
        private final Object myConfigurationCluster;
        private final OCLanguageKind myKind;

        private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind) {
            this.myConfigurationCluster = configurationCluster;
            this.myKind = kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OCBuildFileCategory category = (OCBuildFileCategory)o;
            if (this.myKind != category.myKind) {
                return false;
            }
            return Objects.equals(this.myConfigurationCluster, category.myConfigurationCluster);
        }

        public int hashCode() {
            int result = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
            result = 31 * result + (this.myKind != null ? this.myKind.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "OCBuildFileCategory{myConfigurationCluster=" + this.myConfigurationCluster + ", myKind=" + this.myKind + "}";
        }
    }

    @FunctionalInterface
    private static interface BuildFileProvider
    extends Supplier<OCBuildFileDescriptor> {
    }

    private static final class OCBuildFileDescriptor {
        private final VirtualFile myFile;
        private final OCResolveConfiguration myConfiguration;
        private final boolean myIsSurrogate;

        private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file, boolean isSurrogate) {
            this.myConfiguration = configuration;
            this.myFile = file;
            this.myIsSurrogate = isSurrogate;
        }
    }

    private static final class PrioritizedBuildFileProvider
    implements BuildFileProvider {
        private boolean myUseClusters = true;
        private Supplier<OCBuildFileDescriptor> myCurrentProvider;
        @NotNull
        private final Collection<BuildFileProvider> myProviders;
        @NotNull
        private final BuildFileProvider myBottomProvider;

        private PrioritizedBuildFileProvider(@NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
            this.myProviders = providers;
            this.myBottomProvider = bottomProvider;
        }

        @Override
        @Nullable
        public OCBuildFileDescriptor get() {
            OCBuildFileDescriptor fromCluster = this.nextFromProviders();
            return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCBuildFileDescriptor nextFromProviders() {
            if (!this.myUseClusters) {
                return null;
            }
            while (true) {
                BuildFileProvider provider2;
                OCBuildFileDescriptor next;
                if (this.myCurrentProvider != null && (next = this.myCurrentProvider.get()) != null) {
                    return next;
                }
                Collection<BuildFileProvider> collection = this.myProviders;
                synchronized (collection) {
                    Iterator<BuildFileProvider> iterator2 = this.myProviders.iterator();
                    if (!iterator2.hasNext()) {
                        break;
                    }
                    provider2 = iterator2.next();
                    iterator2.remove();
                }
                this.myCurrentProvider = provider2;
            }
            this.myUseClusters = false;
            return null;
        }
    }
}

