/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import org.jetbrains.annotations.NotNull;

public class OCSymbolLoadedNotifier {
    static void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator) {
        indicator.checkCanceled();
        OCSymbolTableBuildingUtil.runCancelableReadAction(project, (ProgressIndicator)indicator, () -> {
            if (project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
            cache.compact();
            cache.notifySymbolsLoaded();
        });
        Runnable runnable = () -> {
            if (project.isDisposed()) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
            cache.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeAndWait(runnable);
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
        }
    }
}

