/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIndexingStatisticsCollector
extends CounterUsagesCollector {
    public static final EventLogGroup GROUP = new EventLogGroup("oc.symbols", 3);
    public static final EnumEventField<OCSymbolTablesBuildingMode> MODE_FIELD = EventFields.Enum((String)"mode", OCSymbolTablesBuildingMode.class);
    public static final LongEventField DURATION_FIELD = EventFields.Long((String)"duration_ms");
    public static final StringEventField DURATION_GROUPED_FIELD = new DurationGroupField("duration_group");
    public static final IntEventField FILES_FIELD = EventFields.Int((String)"files");
    public static final IntEventField TABLES_FIELD = EventFields.Int((String)"tables");
    public static final StringEventField TABLES_GROUPED_FIELD = new TablesGroupField("tables_group");
    public static final VarargEventId SYMBOLS_BUILT_EVENT = GROUP.registerVarargEvent("built", new EventField[]{MODE_FIELD, DURATION_FIELD, DURATION_GROUPED_FIELD, FILES_FIELD, TABLES_FIELD, TABLES_GROUPED_FIELD});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logSymbolBuilt(@NotNull OCSymbolTablesBuildingMode mode, long duration, int files, int tables) {
        SYMBOLS_BUILT_EVENT.log(new EventPair[]{MODE_FIELD.with((Object)mode), DURATION_FIELD.with((Object)duration), DURATION_GROUPED_FIELD.with((Object)OCIndexingStatisticsCollector.toDurationGroup(duration)), FILES_FIELD.with((Object)files), TABLES_FIELD.with((Object)tables), TABLES_GROUPED_FIELD.with((Object)OCIndexingStatisticsCollector.toTablesGroup(tables))});
    }

    @NotNull
    private static String toDurationGroup(long milliseconds) {
        long seconds = milliseconds / 1000L;
        if (seconds < 10L) {
            return "<10s";
        }
        if (seconds < 60L) {
            return 10L * (seconds / 10L) + "s+";
        }
        long minutes = seconds / 60L;
        if (minutes < 5L) {
            return minutes + "m+";
        }
        if (minutes < 30L) {
            return ">" + 5L * (minutes / 5L) + "m";
        }
        return ">30m";
    }

    @NotNull
    private static String toTablesGroup(long tables) {
        if (tables == 0L) {
            return "0";
        }
        for (Integer threshold : Arrays.asList(10000, 5000, 2000, 1000, 500, 100, 10)) {
            if (tables < (long)threshold.intValue()) continue;
            return threshold + "+";
        }
        return "<10";
    }

    private static class DurationGroupField
    extends StringEventField {
        private DurationGroupField(@NotNull String name) {
            super(name);
        }

        @NotNull
        public List<String> getValidationRule() {
            return List.of("<{regexp#integer}s", "{regexp#integer}s+", "{regexp#integer}m+", ">{regexp#integer}m");
        }
    }

    private static class TablesGroupField
    extends StringEventField {
        private TablesGroupField(@NotNull String name) {
            super(name);
        }

        @NotNull
        public List<String> getValidationRule() {
            return List.of("{regexp#integer}", "<{regexp#integer}", "{regexp#integer}+");
        }
    }
}

