/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import org.jetbrains.annotations.NotNull;

class OCClearingSymbolsActivity {
    OCClearingSymbolsActivity() {
    }

    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        OCWorkerActivity.runWithIndeterminateProgress(indicator, OCBundle.message("symbol.table.activity.building.symbols", new Object[0]), () -> {
            indicator.checkCanceled();
            OCSymbolTableBuildingUtil.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
                if (indicator.isCanceled()) {
                    return;
                }
                Project project = userData.getProject();
                FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
                cache.notifySymbolsUnloaded();
                cache.clearAllTables();
                cache.reparseCachedPsiFiles();
                OCClearingSymbolsActivity.clearAllSymbolDependentCaches(project);
                ModuleMapCache.getInstance(project).reset();
                ModuleMapManager.getInstance(project).clearCache();
            });
            indicator.checkCanceled();
        });
    }

    private static void clearAllSymbolDependentCaches(@NotNull Project project) {
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(configuration);
            OCInclusionContext.clearSymbolTableConformanceCache(configuration);
            OCImportGraph.invalidateRootHeadersCache(configuration);
        }
        OCResolveRootAndConfigurationCache.getInstance(project).invalidateForAll();
    }
}

