/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCBuildingActivityProgressIndicator
extends DelegatingProgressIndicator {
    private static final ConcurrentHashMap<String, AtomicLong> ourTotalTimePerActivity = new ConcurrentHashMap();
    private static final AtomicLong ourTotalTime = new AtomicLong();
    private double myFromFraction;
    private double myToFraction = 1.0;
    private String lastActivity;
    private long activityStarted;

    OCBuildingActivityProgressIndicator(@NotNull ProgressIndicator indicator) {
        super(indicator);
    }

    public void startTiming(@NotNull @NonNls String activity) {
        this.activityStarted = System.currentTimeMillis();
        this.lastActivity = activity;
    }

    public void setText(@Nls @NlsContexts.ProgressText String text) {
        super.setText(text);
    }

    public void logTiming() {
        long now = System.currentTimeMillis();
        long time = now - this.activityStarted;
        AtomicLong totalActivityTime = ourTotalTimePerActivity.computeIfAbsent(this.lastActivity, s -> new AtomicLong(0L));
        totalActivityTime.addAndGet(time);
        ourTotalTime.addAndGet(time);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            OCLog.LOG.info("[Building Activity] " + this.lastActivity + " finished in " + StringUtil.formatDuration((long)time));
        }
    }

    public void setInterval(double from, double to) {
        this.myFromFraction = from;
        this.myToFraction = to;
    }

    public void setFraction(double fraction) {
        super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
    }

    @TestOnly
    public static void logStats(Logger logger) {
        @NonNls StringBuilder text = new StringBuilder();
        text.append("Total symbol building time: ").append(StringUtil.formatDuration((long)ourTotalTime.get())).append("\n");
        for (Map.Entry<String, AtomicLong> entry : ourTotalTimePerActivity.entrySet()) {
            text.append("\tTotal ").append(entry.getKey()).append(" time: ").append(StringUtil.formatDuration((long)entry.getValue().get())).append("\n");
        }
        logger.info(text.toString());
    }
}

