/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.MathUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCActivityLog;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "", "()V", "executor", "Ljava/util/concurrent/ForkJoinPool;", "getExecutor", "()Ljava/util/concurrent/ForkJoinPool;", "nameCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "assertParsingAndSymbolBuildingAllowed", "", "project", "Lcom/intellij/openapi/project/Project;", "getThreadCount", "", "userValue", "isBuildingThread", "", "isSymbolBuildingAllowed", "Companion", "OCBuildingThread", "intellij.c"})
public final class OCBuildingActivityExecutionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger nameCounter = new AtomicInteger();
    @NotNull
    private final ForkJoinPool executor = new ForkJoinPool(this.getThreadCount(), arg_0 -> OCBuildingActivityExecutionService.executor$lambda$0(this, arg_0), null, false);

    @NotNull
    public final ForkJoinPool getExecutor() {
        return this.executor;
    }

    public final int getThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        Integer n = userValue;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int userCpuCount = n2 != null ? n2 : userValue + cpuCount;
        return MathUtil.clamp((int)userCpuCount, (int)1, (int)cpuCount);
    }

    public final int getThreadCount() {
        RegistryValue registryValue = Registry.get((String)"cidr.indexer.thread.count");
        int userValue = ApplicationManager.getApplication().isHeadlessEnvironment() && !registryValue.isChangedFromDefault() ? 0 : registryValue.asInteger();
        return this.getThreadCount(userValue);
    }

    public final boolean isBuildingThread() {
        return Thread.currentThread() instanceof OCBuildingThread;
    }

    public final void assertParsingAndSymbolBuildingAllowed(@NotNull Project project) {
        ProgressManager.checkCanceled();
        if (this.isSymbolBuildingAllowed(project)) {
            return;
        }
        String logEntries = OCActivityLog.getEntries(project);
        String message = StringsKt.trimIndent((String)("\n      Symbol building is not allowed: " + System.currentTimeMillis() + " . \n      Loaded: " + FileSymbolTablesCache.getInstance(project).areSymbolsLoaded() + "\n      Dumb:   " + DumbService.isDumb((Project)project) + "\n      Previous activities: \n      " + logEntries + "\n    "));
        OCLog.LOG.error(message);
        throw new ProcessCanceledException(new Throwable(message));
    }

    public final boolean isSymbolBuildingAllowed(@NotNull Project project) {
        if (this.isBuildingThread()) {
            return true;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        return cache.areSymbolsLoaded();
    }

    private static final ForkJoinWorkerThread executor$lambda$0(OCBuildingActivityExecutionService this$0, ForkJoinPool it) {
        return new OCBuildingThread(it, this$0.nameCounter.getAndIncrement());
    }

    @NotNull
    public static final OCBuildingActivityExecutionService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$OCBuildingThread;", "Ljava/util/concurrent/ForkJoinWorkerThread;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "index", "", "(Ljava/util/concurrent/ForkJoinPool;I)V", "intellij.c"})
    private static final class OCBuildingThread
    extends ForkJoinWorkerThread {
        public OCBuildingThread(@NotNull ForkJoinPool pool, int index) {
            super(pool);
            this.setName("Cidr Symbol Building Thread (" + index + ")");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$Companion;", "", "()V", "executor", "Ljava/util/concurrent/ForkJoinPool;", "getExecutor", "()Ljava/util/concurrent/ForkJoinPool;", "instance", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OCBuildingActivityExecutionService getInstance() {
            boolean $i$f$service = false;
            Class<OCBuildingActivityExecutionService> serviceClass$iv = OCBuildingActivityExecutionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (OCBuildingActivityExecutionService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final ForkJoinPool getExecutor() {
            return this.getInstance().getExecutor();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

