/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapCacheBuildingSession;
import com.jetbrains.cidr.lang.symbols.symtable.building.CoolDownUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.building.ImpatientDeferredException;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.RecursiveSymbolBuilding;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.List;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u0003123B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u009d\u0001\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u000b\u0010\u001d\u001a\u00070\u0013\u00a2\u0006\u0002\b\u001e2Y\b\u0004\u0010\u001f\u001aS\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0015\u0012\u0013\u0018\u00010&\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00110 j\b\u0012\u0004\u0012\u00020\r`(H\u0082\bJ\u00a5\u0001\u0010)\u001a\u00020\u0011\"\u0004\b\u0000\u0010*2\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b+2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H*0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u000b\u0010\u001d\u001a\u00070\u0013\u00a2\u0006\u0002\b\u001e2W\u0010,\u001aS\u0012\u0013\u0012\u0011H*\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0015\u0012\u0013\u0018\u00010&\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00110 j\b\u0012\u0004\u0012\u0002H*`(H\u0002J4\u0010-\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J \u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002000\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity;", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityProgressIndicator;)V", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "myCoolDownUpdater", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/CoolDownUpdater;", "buildClusterization", "Lcom/google/common/collect/ImmutableListMultimap;", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapDescriptor;", "descriptors", "", "buildModuleMaps", "", "projectHash", "", "clusterizationMap", "from", "", "to", "collectHeadersSearchRoots", "getClusterization", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "iterateValidModuleMaps", "message", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "body", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "item", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "session", "Ljava/lang/Runnable;", "rescheduling", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/Task;", "processModuleMapBuilding", "T", "Lorg/jetbrains/annotations/NonNls;", "action", "processModuleMaps", "processModulesPerConfiguration", "setupConfigurationsClusterization", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ConfigurationItem;", "Companion", "ConfigurationItem", "ModuleMapBuilding", "intellij.c"})
public final class ModuleMapBuildingActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final OCBuildingActivityProgressIndicator indicator;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final CoolDownUpdater myCoolDownUpdater;

    public ModuleMapBuildingActivity(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator) {
        this.project = project;
        this.indicator = indicator;
        this.moduleMapManager = ModuleMapManager.Companion.getInstance(this.project);
        this.myCoolDownUpdater = new CoolDownUpdater(0L, 1, null);
    }

    public final void buildModuleMaps() {
        List<ModuleMapDescriptor> descriptors = this.collectHeadersSearchRoots();
        this.buildModuleMaps(descriptors);
    }

    private final List<ModuleMapDescriptor> collectHeadersSearchRoots() {
        return OCSymbolTableBuildingUtil.runCancelableReadAction(this.project, (ProgressIndicator)this.indicator, () -> ModuleMapBuildingActivity.collectHeadersSearchRoots$lambda$0(this));
    }

    private final void buildModuleMaps(List<ModuleMapDescriptor> descriptors) {
        String projectHash = OCSymbolTableBuildingUtil.runCancelableReadAction(this.project, (ProgressIndicator)this.indicator, () -> ModuleMapBuildingActivity.buildModuleMaps$lambda$1(this));
        ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap = this.buildClusterization(descriptors);
        int size = clusterizationMap.values().size();
        ModuleMapLog.LOG.info("Building module maps for " + size + " (root, configuration) pairs");
        this.buildModuleMaps(projectHash, clusterizationMap, 0.1, 0.7);
        this.processModuleMaps(projectHash, clusterizationMap, 0.7, 0.85);
        if (!ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            this.processModulesPerConfiguration(projectHash, 0.85, 0.9);
        }
    }

    private final void iterateValidModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to, String message, Function3<? super ModuleMapDescriptor, ? super SerializationSession, ? super Runnable, Unit> body) {
        boolean $i$f$iterateValidModuleMaps = false;
        int size = clusterizationMap.values().size();
        AtomicInteger processedCount = new AtomicInteger(0);
        this.processModuleMapBuilding(projectHash, clusterizationMap, from, to, message, (Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount, this, body, size){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            final /* synthetic */ Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit> $body;
            final /* synthetic */ int $size;
            {
                this.$processedCount = $processedCount;
                this.this$0 = $receiver;
                this.$body = $body;
                this.$size = $size;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ModuleMapDescriptor item, @NotNull SerializationSession session, @Nullable Runnable rescheduling) {
                void this_$iv;
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                this.$body.invoke((Object)item, (Object)session, (Object)rescheduling);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void buildModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to) {
        void this_$iv;
        ModuleMapBuildingActivity moduleMapBuildingActivity = this;
        String message$iv = OCBundle.message("building.module.maps", new Object[0]);
        boolean $i$f$iterateValidModuleMaps = false;
        int size$iv = clusterizationMap.values().size();
        AtomicInteger processedCount$iv = new AtomicInteger(0);
        super.processModuleMapBuilding(projectHash, clusterizationMap, from, to, message$iv, (Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount$iv, (ModuleMapBuildingActivity)this_$iv, size$iv, this){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0$inline_fun;
            final /* synthetic */ int $size;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            {
                this.$processedCount = $processedCount;
                this.this$0$inline_fun = $receiver;
                this.$size = $size;
                this.this$0 = moduleMapBuildingActivity;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ModuleMapDescriptor item, @NotNull SerializationSession session, @Nullable Runnable rescheduling) {
                void session2;
                void rescheduling2;
                void this_$iv;
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0$inline_fun);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0$inline_fun;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                Runnable runnable = rescheduling;
                SerializationSession serializationSession = session;
                ModuleMapDescriptor item2 = item;
                boolean bl = false;
                ModuleMapBuildingActivity.access$getModuleMapManager$p(this.this$0).buildModule(item2, (Runnable)rescheduling2, (SerializationSession)session2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void processModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to) {
        void this_$iv;
        ModuleMapBuildingActivity moduleMapBuildingActivity = this;
        String message$iv = OCBundle.message("processing.module.maps", new Object[0]);
        boolean $i$f$iterateValidModuleMaps = false;
        int size$iv = clusterizationMap.values().size();
        AtomicInteger processedCount$iv = new AtomicInteger(0);
        super.processModuleMapBuilding(projectHash, clusterizationMap, from, to, message$iv, (Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount$iv, (ModuleMapBuildingActivity)this_$iv, size$iv, this){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0$inline_fun;
            final /* synthetic */ int $size;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            {
                this.$processedCount = $processedCount;
                this.this$0$inline_fun = $receiver;
                this.$size = $size;
                this.this$0 = moduleMapBuildingActivity;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ModuleMapDescriptor item, @NotNull SerializationSession session, @Nullable Runnable rescheduling) {
                void session2;
                void rescheduling2;
                void this_$iv;
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0$inline_fun);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0$inline_fun;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                Runnable runnable = rescheduling;
                SerializationSession serializationSession = session;
                ModuleMapDescriptor item2 = item;
                boolean bl = false;
                ModuleMapBuildingActivity.access$getModuleMapManager$p(this.this$0).buildDependencies(item2, (Runnable)rescheduling2, (SerializationSession)session2);
            }
        });
    }

    private final void processModulesPerConfiguration(String projectHash, double from, double to) {
        ImmutableListMultimap<Object, ConfigurationItem> configurationsCluster = this.setupConfigurationsClusterization();
        AtomicInteger processedCount = new AtomicInteger(0);
        int size = configurationsCluster.values().size();
        this.processModuleMapBuilding(projectHash, configurationsCluster, from, to, OCBundle.message("processing.module.maps", new Object[0]), (Function3)new Function3<ConfigurationItem, SerializationSession, Runnable, Unit>(this, processedCount, size){
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ int $size;
            {
                this.this$0 = $receiver;
                this.$processedCount = $processedCount;
                this.$size = $size;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ConfigurationItem item, @NotNull SerializationSession serializationSession, @Nullable Runnable runnable) {
                void this_$iv;
                OCResolveConfiguration configuration = item.getConfiguration();
                OCBuildingActivityProgressIndicator oCBuildingActivityProgressIndicator = ModuleMapBuildingActivity.access$getIndicator$p(this.this$0);
                Object object = configuration;
                if (object == null || (object = object.getDisplayName()) == null) {
                    object = "";
                }
                oCBuildingActivityProgressIndicator.setText2((String)object);
                ModuleMapBuildingActivity.access$getModuleMapManager$p(this.this$0).cacheFor(configuration).getModules();
                int processedCountValue = this.$processedCount.incrementAndGet();
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
            }
        });
    }

    private final ImmutableListMultimap<Object, ConfigurationItem> setupConfigurationsClusterization() {
        ImmutableListMultimap.Builder builder2 = ImmutableListMultimap.builder();
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)this.project).getConfigurations()) {
            builder2.put(new Object(), (Object)new ConfigurationItem(configuration));
        }
        builder2.put(new Object(), (Object)new ConfigurationItem(null));
        return builder2.build();
    }

    private final ImmutableListMultimap<Object, ModuleMapDescriptor> buildClusterization(List<ModuleMapDescriptor> descriptors) {
        ImmutableListMultimap.Builder clusterization = ImmutableListMultimap.builder();
        for (ModuleMapDescriptor descriptor : descriptors) {
            OCResolveConfiguration configuration = descriptor.getConfiguration();
            Object cluster = this.getClusterization(configuration);
            clusterization.put(cluster, (Object)descriptor);
        }
        return clusterization.build();
    }

    private final <T> void processModuleMapBuilding(String projectHash, ImmutableListMultimap<Object, T> clusterizationMap, double from, double to, String message, Function3<? super T, ? super SerializationSession, ? super Runnable, Unit> action) {
        OCSymbolTableBuildingUtil.processRecursiveTasks(this.project, this.indicator, from, to, clusterizationMap, (arg_0, arg_1) -> ModuleMapBuildingActivity.processModuleMapBuilding$lambda$4((Function2)new Function2<ProgressIndicator, ProgressIndicator, RecursiveSymbolBuilding<T>>(this, message, projectHash, action){
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ String $projectHash;
            final /* synthetic */ Function3<T, SerializationSession, Runnable, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$projectHash = $projectHash;
                this.$action = $action;
                super(2);
            }

            public final RecursiveSymbolBuilding<T> invoke(@NotNull ProgressIndicator global, @NotNull ProgressIndicator read) {
                return new ModuleMapBuilding<T>(ModuleMapBuildingActivity.access$getProject$p(this.this$0), global, read, 1, this.$message, this.$projectHash, this.$action);
            }
        }, arg_0, arg_1));
    }

    private final Object getClusterization(OCResolveConfiguration configuration) {
        Object object = configuration.getCompilerSettings(ModuleMapUtil.getPreferredLanguageKind()).getIndexingCluster();
        if (object == null) {
            object = ObjectUtils.NULL;
        }
        return object;
    }

    private static final List collectHeadersSearchRoots$lambda$0(ModuleMapBuildingActivity this$0) {
        return this$0.moduleMapManager.getDescriptorsForInitialBuilding();
    }

    private static final String buildModuleMaps$lambda$1(ModuleMapBuildingActivity this$0) {
        return this$0.project.getLocationHash();
    }

    private static final RecursiveSymbolBuilding processModuleMapBuilding$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (RecursiveSymbolBuilding)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ CoolDownUpdater access$getMyCoolDownUpdater$p(ModuleMapBuildingActivity $this) {
        return $this.myCoolDownUpdater;
    }

    public static final /* synthetic */ OCBuildingActivityProgressIndicator access$getIndicator$p(ModuleMapBuildingActivity $this) {
        return $this.indicator;
    }

    public static final /* synthetic */ ModuleMapManager access$getModuleMapManager$p(ModuleMapBuildingActivity $this) {
        return $this.moduleMapManager;
    }

    public static final /* synthetic */ Project access$getProject$p(ModuleMapBuildingActivity $this) {
        return $this.project;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0098\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u0012\u000b\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e\u0012W\u0010\u000f\u001aS\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010j\b\u0012\u0004\u0012\u00028\u0000`\u0019\u00a2\u0006\u0002\u0010\u001aJ,\u0010\u001f\u001a\f0 R\b\u0012\u0004\u0012\u00028\u00000\u00022\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0014R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R_\u0010\u000f\u001aS\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010j\b\u0012\u0004\u0012\u00028\u0000`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ModuleMapBuilding;", "T", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding;", "project", "Lcom/intellij/openapi/project/Project;", "globalIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readIndicator", "maxLeafSize", "", "indicatorText", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "projectHash", "Lorg/jetbrains/annotations/NonNls;", "task", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "item", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "session", "Ljava/lang/Runnable;", "rescheduling", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/Task;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/progress/ProgressIndicator;ILjava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "isImpatient", "", "serializationSession", "Ljava/lang/ThreadLocal;", "createWorkerTask", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask;", "parent", "Ljava/util/concurrent/CountedCompleter;", "workset", "Lcom/google/common/collect/ImmutableList;", "intellij.c"})
    private static final class ModuleMapBuilding<T>
    extends RecursiveSymbolBuilding<T> {
        @NotNull
        private final Function3<T, SerializationSession, Runnable, Unit> task;
        @NotNull
        private final ThreadLocal<SerializationSession> serializationSession;
        private final boolean isImpatient;

        public ModuleMapBuilding(@NotNull Project project, @NotNull ProgressIndicator globalIndicator, @NotNull ProgressIndicator readIndicator, int maxLeafSize, @NotNull String indicatorText, @NotNull String projectHash, @NotNull Function3<? super T, ? super SerializationSession, ? super Runnable, Unit> task) {
            super(project, globalIndicator, readIndicator, maxLeafSize, indicatorText);
            this.task = task;
            this.serializationSession = ThreadLocal.withInitial(() -> ModuleMapBuilding.serializationSession$lambda$0(projectHash));
            this.isImpatient = Registry.is((String)"cidr.modulemaps.building.impatient", (boolean)true);
        }

        @Override
        @NotNull
        protected RecursiveSymbolBuilding.ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> parent, @NotNull ImmutableList<T> workset2) {
            return new RecursiveSymbolBuilding.ReadActionTask(this, parent, workset2){
                final /* synthetic */ ModuleMapBuilding<T> this$0;
                {
                    this.this$0 = $receiver;
                    super($receiver, $parent, $workset);
                }

                protected void computeInReadAction(T item) {
                    try {
                        ModuleMapBuilding.access$getTask$p(this.this$0).invoke(item, ModuleMapBuilding.access$getSerializationSession$p(this.this$0).get(), ModuleMapBuilding.access$isImpatient$p(this.this$0) ? () -> createWorkerTask.1.computeInReadAction$lambda$0(this, item) : null);
                    }
                    catch (ImpatientDeferredException e) {
                        this.addToPendingCount(1);
                    }
                }

                private static final void computeInReadAction$lambda$0(createWorkerTask.1 this$0, Object $item) {
                    this$0.reschedule(ImmutableList.of((Object)$item), 0);
                }
            };
        }

        private static final SerializationSession serializationSession$lambda$0(String $projectHash) {
            return new SerializationSession($projectHash);
        }

        public static final /* synthetic */ Function3 access$getTask$p(ModuleMapBuilding $this) {
            return $this.task;
        }

        public static final /* synthetic */ ThreadLocal access$getSerializationSession$p(ModuleMapBuilding $this) {
            return $this.serializationSession;
        }

        public static final /* synthetic */ boolean access$isImpatient$p(ModuleMapBuilding $this) {
            return $this.isImpatient;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ConfigurationItem;", "", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "intellij.c"})
    private static final class ConfigurationItem {
        @Nullable
        private final OCResolveConfiguration configuration;

        public ConfigurationItem(@Nullable OCResolveConfiguration configuration) {
            this.configuration = configuration;
        }

        @Nullable
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$Companion;", "", "()V", "buildModuleMaps", "", "descriptors", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        public final void buildModuleMaps(@NotNull List<ModuleMapDescriptor> descriptors, @NotNull Project project, @NotNull ProgressIndicator indicator) {
            new ModuleMapBuildingActivity(project, new OCBuildingActivityProgressIndicator(indicator)).buildModuleMaps(descriptors);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

