/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.preprocessor.OCProtectedIncludeStack;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalBlock;
import com.jetbrains.cidr.lang.psi.impl.OCEagerBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLazyElementBase;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.AstNamedNodeStructure;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.CountingPsiBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCContextSignatureBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTableProcessor;
import com.jetbrains.cidr.lang.symbols.symtable.TableBuildingItem;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTableProvider
implements FileSymbolTableProvider {
    private static final Map<Thread, OCProtectedIncludeStack> ourDebugSymbolBuildingStack = new HashMap<Thread, OCProtectedIncludeStack>();
    private static final Logger LOG = Logger.getInstance(OCSymbolTableProvider.class);

    @Override
    public boolean accepts(@NotNull PsiFile file) {
        return OCLanguageUtils.isSupported(file);
    }

    @Override
    public boolean accepts(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        OCLanguageKind languageKind = context.getLanguageKind();
        return (languageKind instanceof CLanguageKind || languageKind instanceof CUDALanguageKind) && this.accepts(file, context.getProject());
    }

    @Override
    public boolean accepts(@NotNull VirtualFile file, @NotNull Project project) {
        PsiFile cachedPsi = OCInclusionContextUtil.findCachedPsiFile(file, project);
        if (cachedPsi != null && this.accepts(cachedPsi)) {
            return true;
        }
        return OCLanguageUtils.isSupported(file);
    }

    @Override
    public boolean shouldPreProcess() {
        return true;
    }

    @Override
    public boolean shouldProcessPsiEvents(@NotNull PsiFile file) {
        return file instanceof OCFile;
    }

    @Override
    public boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement element = event.getParent();
        while (!(element instanceof PsiFile) && !(element instanceof PsiDirectory) && element != null) {
            if (element instanceof OCLocalBlock && !(element instanceof OCEagerBlockStatementImpl)) {
                return false;
            }
            element = element.getParent();
        }
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public FileSymbolTable calculateTable(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        String text;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText2(virtualFile.getName());
        }
        OCContextSignatureBuilder signatureBuilder = new OCContextSignatureBuilder(context.getLanguageKind(), context.getCurrentNamespace(), context.isSurrogate());
        TableBuildingItem item = new TableBuildingItem(virtualFile, context.getLanguageKind());
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(OCLanguageUtils.getSlowLanguage());
        assert (parserDefinition != null);
        OCInclusionContext currentFileContext = context.deriveButDontCopyTypes(false);
        currentFileContext.setSignatureBuilder(signatureBuilder);
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, virtualFile, OCSymbolTableProvider.getIncludeStackUnsafe());
        lexer.adjustNamespace();
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "readFileText", (Object)item);){
            text = FileSymbolTableHelper.getFileText(virtualFile, context.getProject()).toString();
        }
        boolean startSuccess = OCSymbolTableProvider.startBuildingSymbolTable(virtualFile);
        if (!startSuccess) {
            lexer = new OCPreprocessingLexer(currentFileContext, virtualFile, OCPreprocessingLexer.IncludePreprocessingMode.SKIP, OCSymbolTableProvider.getIncludeStackUnsafe(), 1);
            lexer.adjustNamespace();
        }
        try {
            CidrEventSpan span = new CidrEventSpan("symbols", "buildingSymbolTable", (Object)item);
            PsiBuilder b = OCSymbolTableProvider.createPsiBuilder(parserDefinition, lexer, text);
            try (CidrEventSpan ignored = new CidrEventSpan("symbols", "parseForSymbolTable", (Object)item);){
                new OCParsing(b, (IElementType)OCTokenTypes.OC_FILE, OCParsing.BlockParsingMode.SKIP).parseFileContents();
            }
            currentFileContext.setSignatureBuilder(null);
            assert (context.getLanguageKind() == currentFileContext.getLanguageKind());
            FlyweightCapableTreeStructure structure = b.getLightTree();
            FileSymbolTable answer = new FileSymbolTable(virtualFile, signatureBuilder.build(), OCSymbolTableProvider.getConsumedTokenRanges(b));
            CidrEventSpan ignored = new CidrEventSpan("symbols", "builderDriver", (Object)item);
            FileSymbolTable fileSymbolTable = OCSymbolTableProvider.buildTable(virtualFile, text, context, answer, structure, NodeStructure.LIGHTER_NODE_STRUCTURE);
            ignored.close();
            span.close();
            return fileSymbolTable;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            span.accept("aborted buildingSymbolTable", null);
                            throw t;
                        }
                    }
                    catch (Throwable throwable3) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
        }
        finally {
            OCSymbolTableProvider.finishBuildingSymbolTable(startSuccess);
        }
    }

    @NotNull
    private static PsiBuilder createPsiBuilder(ParserDefinition parserDefinition, OCPreprocessingLexer lexer, String text) {
        PsiBuilder baseBuilder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)lexer, (CharSequence)text);
        if (Registry.is((String)"cidr.debug.show.parser.rollbacks")) {
            return new CountingPsiBuilder(baseBuilder);
        }
        return baseBuilder;
    }

    @Nullable
    private static List<ConsumedTokenRange> getConsumedTokenRanges(@NotNull PsiBuilder b) {
        return b instanceof CountingPsiBuilder ? ((CountingPsiBuilder)b).getConsumedTokenRanges() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static OCProtectedIncludeStack getIncludeStackUnsafe() {
        Thread currentThread = Thread.currentThread();
        Map<Thread, OCProtectedIncludeStack> map = ourDebugSymbolBuildingStack;
        synchronized (map) {
            return ourDebugSymbolBuildingStack.computeIfAbsent(currentThread, k -> new OCProtectedIncludeStack());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean startBuildingSymbolTable(@NotNull VirtualFile virtualFile) {
        Thread currentThread = Thread.currentThread();
        Map<Thread, OCProtectedIncludeStack> map = ourDebugSymbolBuildingStack;
        synchronized (map) {
            OCProtectedIncludeStack stack = ourDebugSymbolBuildingStack.computeIfAbsent(currentThread, k -> new OCProtectedIncludeStack());
            return stack.push(virtualFile.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishBuildingSymbolTable(boolean popStack) {
        Thread currentThread = Thread.currentThread();
        Map<Thread, OCProtectedIncludeStack> map = ourDebugSymbolBuildingStack;
        synchronized (map) {
            OCProtectedIncludeStack stack = ourDebugSymbolBuildingStack.get(currentThread);
            assert (stack != null);
            if (popStack) {
                stack.pop();
                if (stack.isEmpty()) {
                    ourDebugSymbolBuildingStack.remove(currentThread);
                }
            }
        }
    }

    @Override
    @NotNull
    public FileSymbolTable calculateTableUsingPSI(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        FileSymbolTable answer = new FileSymbolTable(virtualFile, new ContextSignature());
        String text = file.getViewProvider().getContents().toString();
        return OCSymbolTableProvider.buildTable(virtualFile, text, context, answer, new ASTStructure((ASTNode)file.getNode()){

            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                return astNode instanceof OCLazyElementBase ? 0 : super.getChildren(astNode, into);
            }
        }, AstNamedNodeStructure.INSTANCE);
    }

    private static <T> FileSymbolTable buildTable(@NotNull VirtualFile file, String text, @NotNull OCInclusionContext context, FileSymbolTable answer, FlyweightCapableTreeStructure<T> structure, NodeStructure<T> nodeStructure) {
        OCInclusionContext buildCtx = context.deriveButDontCopyTypes(false);
        OCBuilderDriver<Object> driver = new OCBuilderDriver<Object>(file, buildCtx, text, structure, nodeStructure, new OCSymbolTableProcessor(answer), context.getProject());
        driver.processDeclarationsList(structure.getRoot());
        answer.sortSymbols();
        return answer;
    }

    @Override
    @NotNull
    public Set<VirtualFile> collectFilesToBuildTables(@NotNull Project project) {
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project);
        Set result = (Set)CollectionsKt.filterTo(allSourceFiles, new LinkedHashSet(), virtualFile -> FileSymbolTableHelper.isSourceFile(virtualFile, project));
        if (FileSymbolTablesCache.shouldBuildTablesForAllSystemHeaders()) {
            result.addAll(OCResolveConfigurations.getHeaderFilesToBuildSymbols((Project)project));
        }
        return result;
    }

    public static class DumpCurrentlyBuildingSymbols
    extends DumbAwareAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Map<Thread, OCProtectedIncludeStack> map = ourDebugSymbolBuildingStack;
            synchronized (map) {
                StringBuilder res = new StringBuilder(">>>>>>>>>>>>> Currently parsed files\n");
                for (Map.Entry<Thread, OCProtectedIncludeStack> entry : ourDebugSymbolBuildingStack.entrySet()) {
                    List<String> files = entry.getValue().getIncludeStack();
                    Thread thread = entry.getKey();
                    res.append(thread).append(" ").append((Object)thread.getState()).append(" (").append(files.size()).append(")").append("\n");
                    for (String file : files) {
                        res.append(file).append("\n");
                    }
                }
                res.append("<<<<<<<<<<<<<< End currently parsed files");
                LOG.warn(ThreadDumper.dumpThreadsToString());
                LOG.warn(res.toString());
            }
        }
    }
}

