/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCTemplateParameterListImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLocalTypes
extends OCRecursiveVisitor {
    private final Set<String> myLocalNames = new HashSet<String>();
    private Stack<OCCallable> myLocalScopes = new Stack();
    private final Set<OCCallable> myCallableHasUsing = new HashSet<OCCallable>();
    private static final NotNullLazyKey<OCLocalTypes, AnnotationSession> CACHE = NotNullLazyKey.create((String)"LOCAL_TYPES_DURING_ANNOTATION", dom -> {
        PsiFile file = dom.getFile();
        OCLocalTypes localTypes = new OCLocalTypes();
        file.accept((PsiElementVisitor)localTypes);
        localTypes.finish();
        return localTypes;
    });

    private OCLocalTypes() {
    }

    private void finish() {
        this.myLocalScopes = null;
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        super.visitStructLike(struct);
        if (!this.myLocalScopes.isEmpty() && struct.isDeclaration()) {
            this.myLocalNames.add(struct.getKind().getNameLowercase() + " " + struct.getName());
            if (!OCCodeInsightUtil.isInPlainOldC(struct)) {
                this.myLocalNames.add(struct.getName());
            }
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        super.visitDeclaration(declaration);
        if (!this.myLocalScopes.isEmpty() && declaration.isTypedef()) {
            OCDeclarator declarator;
            Iterator<OCDeclarator> iterator2 = declaration.getDeclarators().iterator();
            OCDeclarator oCDeclarator = declarator = iterator2.hasNext() ? iterator2.next() : null;
            if (declarator != null) {
                this.myLocalNames.add(declarator.getName());
            }
        }
    }

    private void processCallable(OCCallable callable) {
        this.myLocalScopes.push((Object)callable);
        this.visitElement(callable);
        this.myLocalScopes.pop();
    }

    @Override
    public void visitUsingStatement(OCCppUsingStatement usingStatement) {
        super.visitUsingStatement(usingStatement);
        if (!this.myLocalScopes.isEmpty()) {
            this.myCallableHasUsing.addAll((Collection<OCCallable>)this.myLocalScopes);
        }
    }

    @Override
    public void visitNamespaceAlias(OCCppNamespaceAlias namespaceAlias) {
        super.visitNamespaceAlias(namespaceAlias);
        if (!this.myLocalScopes.isEmpty()) {
            this.myLocalNames.add(namespaceAlias.getName());
        }
    }

    @Override
    public void visitMethod(OCMethod method) {
        this.processCallable(method);
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
        this.processCallable(functionDefinition);
    }

    @Override
    public void visitTemplateParameterList(OCTemplateParameterListImpl list) {
        for (OCTypeParameterDeclaration declarator : list.getTypeParameterDeclarations()) {
            this.myLocalNames.add(declarator.getName());
        }
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.processCallable(blockExpression);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.processCallable(lambdaExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Boolean canBeLocalType(OCFile file, @NotNull OCQualifiedName qn) {
        Object object = file.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file.getCurrentAnnotationSession();
            if (annotationSession != null) {
                Set<String> names = ((OCLocalTypes)((Object)OCLocalTypes.CACHE.getValue((UserDataHolder)annotationSession))).myLocalNames;
                for (OCQualifiedName cur = qn; cur != null; cur = cur.getQualifier()) {
                    if (!names.contains(cur.getName())) continue;
                    return true;
                }
                return false;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocalUsingStatement(OCFile file, @Nullable OCCallable callable) {
        if (callable == null) {
            return false;
        }
        Object object = file.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file.getCurrentAnnotationSession();
            if (annotationSession != null) {
                return ((OCLocalTypes)((Object)OCLocalTypes.CACHE.getValue((UserDataHolder)annotationSession))).myCallableHasUsing.contains(callable);
            }
        }
        return true;
    }
}

