/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableModificationTracker;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCLazyNamedSymbolCollection;
import com.jetbrains.cidr.lang.symbols.symtable.OCLazyNamedSymbolCollectionImpl;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.CallerAwareSymbolScheduler;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.CoroutineSymbolScheduler;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.SymbolScheduler;
import com.jetbrains.cidr.lang.util.OCConcurrentMostlySingularMultiUniqueMapBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OCGlobalProjectSymbolsBuilder
implements Processor<OCSymbol> {
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCClassSymbol> myCategoryToClass;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myTopLevelSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myMemberSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myCppMemberSymbols;
    @NotNull
    volatile OCConcurrentMostlySingularMultiUniqueMapBuilder<OCSymbol> myTypeAliases;
    @NotNull
    volatile Set<OCLazyNamedSymbol> myLazyNamedSymbols;
    @NotNull
    volatile Set<OCLazyNamedSymbol> myLazyNamedMemberSymbols;
    @NotNull
    volatile MultiMap<String, OCSymbol> mySuperTypeToClass;
    final long myVersion;
    public static final AtomicBoolean isBuilding = new AtomicBoolean(false);
    private static final ExecutorService ourCopyExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Copy Symbols Pool", (int)Integer.max(1, Integer.min(Runtime.getRuntime().availableProcessors() - 1, 4)));

    OCGlobalProjectSymbolsBuilder(long version) {
        this.myVersion = version;
    }

    @NotNull
    static OCGlobalProjectSymbolsCache.OCSymbols build(@NotNull Project project) {
        OCFileSymbolTableModificationTracker.log("{ build GST", new Object[0]);
        isBuilding.set(true);
        try {
            OCGlobalProjectSymbolsCache.OCSymbols oCSymbols;
            long st;
            long st2;
            long st1;
            block22: {
                OCFileSymbolTableModificationTracker FSTmt = OCFileSymbolTableModificationTracker.getInstance(project);
                FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
                OCFileSymbolTableModificationTracker.StateAndVersion stateAndVersion = FSTmt.getStateAndReset();
                OCFileSymbolTableModificationTracker.State buildState = stateAndVersion.state;
                long currentVersion = stateAndVersion.version;
                if (buildState.symbols != null && buildState.symbols.myVersion == currentVersion) {
                    OCLog.LOG.assertTrue(buildState.filesWithInvalidSymbolTable.isEmpty());
                    OCLog.LOG.assertTrue(buildState.filesWithNewSymbolTable.isEmpty());
                    OCGlobalProjectSymbolsCache.OCSymbols oCSymbols2 = buildState.symbols;
                    return oCSymbols2;
                }
                Set<VirtualFile> filesToAddToGlobalSymbols = buildState.filesWithNewSymbolTable;
                Set<Object> filesToFilterOutFromGlobalSymbols = buildState.filesWithInvalidSymbolTable;
                HashSet<VirtualFile> filesWithBuildTables = new HashSet<VirtualFile>(cache.getCachedFiles());
                OCGlobalProjectSymbolsCache.OCSymbols oldSymbols = buildState.symbols;
                if (oldSymbols == null) {
                    filesToAddToGlobalSymbols = filesWithBuildTables;
                    if (filesToAddToGlobalSymbols.isEmpty()) {
                        OCFileSymbolTableModificationTracker.log("fake GST run", new Object[0]);
                        OCGlobalProjectSymbolsCache.OCSymbols oCSymbols3 = new OCGlobalProjectSymbolsCache.OCSymbols(currentVersion);
                        return oCSymbols3;
                    }
                    filesToFilterOutFromGlobalSymbols = Collections.emptySet();
                    OCFileSymbolTableModificationTracker.log("full GST run", new Object[0]);
                } else {
                    filesToAddToGlobalSymbols.forEach(vf -> OCFileSymbolTableModificationTracker.log("file with new tables ", vf));
                    Set<VirtualFile> finalFilesToProcess = filesToAddToGlobalSymbols;
                    filesToFilterOutFromGlobalSymbols.forEach(vf -> {
                        OCFileSymbolTableModificationTracker.log("file with invalid tables ", vf);
                        if (filesWithBuildTables.contains(vf)) {
                            OCFileSymbolTableModificationTracker.log("file with valid tables ", vf);
                            finalFilesToProcess.add((VirtualFile)vf);
                        }
                    });
                    filesToAddToGlobalSymbols = finalFilesToProcess;
                    OCFileSymbolTableModificationTracker.log("optimal GST run", new Object[0]);
                }
                st1 = Long.MIN_VALUE;
                st2 = Long.MIN_VALUE;
                st = System.currentTimeMillis();
                try {
                    OCGlobalProjectSymbolsBuilder builder2 = new OCGlobalProjectSymbolsBuilder(currentVersion);
                    builder2.copyActualSymbolsToInitialState(oldSymbols, filesToFilterOutFromGlobalSymbols);
                    st1 = System.currentTimeMillis();
                    int estimatedWorksetSize = 3 * filesWithBuildTables.size();
                    boolean useNewScheduler = Registry.is((String)"cidr.global.project.symbols.cache.use.new.scheduler", (boolean)true);
                    OCFileSymbolTableModificationTracker.log(useNewScheduler ? "using new scheduler" : "using old scheduler", new Object[0]);
                    SymbolScheduler scheduler = useNewScheduler ? new CoroutineSymbolScheduler(cache, estimatedWorksetSize) : new CallerAwareSymbolScheduler(cache, estimatedWorksetSize);
                    scheduler.process(filesToAddToGlobalSymbols, builder2);
                    OCGlobalProjectSymbolsCache.OCSymbols newSymbols = builder2.create();
                    st2 = System.currentTimeMillis();
                    if (currentVersion != FSTmt.attachAndReturnCurrentVersion(newSymbols)) {
                        OCFileSymbolTableModificationTracker.log("dirty GST", new Object[0]);
                    }
                    oCSymbols = newSymbols;
                    if (st1 == Long.MIN_VALUE) break block22;
                }
                catch (ProcessCanceledException pce) {
                    try {
                        if (oldSymbols != null) {
                            FSTmt.restoreStateOnCancel(buildState, oldSymbols);
                            OCFileSymbolTableModificationTracker.log("cancel build GST safe", new Object[0]);
                        } else {
                            OCFileSymbolTableModificationTracker.log("cancel build GST with lost state: next is full GST run", new Object[0]);
                        }
                        throw pce;
                    }
                    catch (Throwable throwable) {
                        if (st1 != Long.MIN_VALUE) {
                            OCFileSymbolTableModificationTracker.log("GST: bulk copy: ", st1 - st);
                        }
                        if (st2 != Long.MIN_VALUE) {
                            OCFileSymbolTableModificationTracker.log("GST: process file tables: ", st2 - st1);
                            OCFileSymbolTableModificationTracker.log("GST: full creation: ", st2 - st);
                        } else {
                            OCFileSymbolTableModificationTracker.log("GST: canceled after: ", System.currentTimeMillis() - st);
                        }
                        throw throwable;
                    }
                }
                OCFileSymbolTableModificationTracker.log("GST: bulk copy: ", st1 - st);
            }
            if (st2 != Long.MIN_VALUE) {
                OCFileSymbolTableModificationTracker.log("GST: process file tables: ", st2 - st1);
                OCFileSymbolTableModificationTracker.log("GST: full creation: ", st2 - st);
            } else {
                OCFileSymbolTableModificationTracker.log("GST: canceled after: ", System.currentTimeMillis() - st);
            }
            return oCSymbols;
        }
        finally {
            isBuilding.set(false);
            OCFileSymbolTableModificationTracker.log("} build GST", new Object[0]);
        }
    }

    private void copyActualSymbolsToInitialState(@Nullable OCGlobalProjectSymbolsCache.OCSymbols oldSymbols, @NotNull Set<VirtualFile> filesToFilterOut) {
        if (oldSymbols == null) {
            this.myCategoryToClass = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(HashingStrategy.identity());
            this.myTopLevelSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(HashingStrategy.identity());
            this.myMemberSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(HashingStrategy.identity());
            this.myCppMemberSymbols = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(HashingStrategy.identity());
            this.myTypeAliases = OCConcurrentMostlySingularMultiUniqueMapBuilder.createBuilder(HashingStrategy.identity());
            this.myLazyNamedSymbols = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            this.myLazyNamedMemberSymbols = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            this.mySuperTypeToClass = new StringToSymbolConcurrentMultiMap();
        } else {
            Predicate<OCSymbol> isActualSymbol = filesToFilterOut.isEmpty() ? Predicates.alwaysTrue() : symbol -> !filesToFilterOut.contains(symbol.getContainingFile());
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            assert (progress != null);
            Object[] tasks = new Runnable[]{() -> {
                this.myTopLevelSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(HashingStrategy.identity(), oldSymbols.myTopLevelSymbols, isActualSymbol, progress);
            }, () -> {
                this.myCppMemberSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(HashingStrategy.identity(), oldSymbols.myCppMemberSymbols, isActualSymbol, progress);
            }, () -> {
                this.myMemberSymbols = OCGlobalProjectSymbolsBuilder.copyBuilder(HashingStrategy.identity(), oldSymbols.myMemberSymbols, isActualSymbol, progress);
            }, () -> {
                this.myCategoryToClass = OCGlobalProjectSymbolsBuilder.copyBuilder(HashingStrategy.identity(), oldSymbols.myCategoryToClass, isActualSymbol, progress);
            }, () -> {
                this.myTypeAliases = OCGlobalProjectSymbolsBuilder.copyBuilder(HashingStrategy.identity(), oldSymbols.myTypeAliases, isActualSymbol, progress);
            }, () -> {
                StringToSymbolConcurrentMultiMap superTypeToClass = new StringToSymbolConcurrentMultiMap(oldSymbols.mySuperTypeToClass.size());
                oldSymbols.mySuperTypeToClass.entrySet().forEach(entry -> ((Collection)entry.getValue()).forEach(symbol -> {
                    if (isActualSymbol.test((OCSymbol)symbol)) {
                        superTypeToClass.putValue((String)entry.getKey(), symbol);
                    }
                }));
                this.mySuperTypeToClass = superTypeToClass;
            }, () -> {
                Set lazyNamedSymbols = ConcurrentCollectionFactory.createConcurrentIdentitySet((int)oldSymbols.myLazyNamedSymbols.size());
                oldSymbols.myLazyNamedSymbols.process((Processor<? super OCLazyNamedSymbol>)((Processor)symbol -> {
                    if (isActualSymbol.test((OCSymbol)symbol)) {
                        lazyNamedSymbols.add(symbol);
                    }
                    return true;
                }), null);
                this.myLazyNamedSymbols = lazyNamedSymbols;
            }, () -> {
                Set lazyNamedMemberSymbols = ConcurrentCollectionFactory.createConcurrentIdentitySet((int)oldSymbols.myLazyNamedMemberSymbols.size());
                oldSymbols.myLazyNamedMemberSymbols.process((Processor<? super OCLazyNamedSymbol>)((Processor)symbol -> {
                    if (isActualSymbol.test((OCSymbol)symbol)) {
                        lazyNamedMemberSymbols.add(symbol);
                    }
                    return true;
                }), null);
                this.myLazyNamedMemberSymbols = lazyNamedMemberSymbols;
            }};
            ContainerUtil.map((Object[])tasks, task -> ourCopyExecutor.submit((Runnable)task)).forEach(future -> ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future));
        }
    }

    @NotNull
    private static <M> OCConcurrentMostlySingularMultiUniqueMapBuilder<M> copyBuilder(@NotNull HashingStrategy<M> strategy, @NotNull MostlySingularMultiMap<String, M> src, @NotNull Predicate<? super M> isActualSymbol, @NotNull ProgressIndicator progress) {
        int[] count = new int[]{0, 0};
        int valuesEstimate = OCConcurrentMostlySingularMultiUniqueMapBuilder.estimateValueCount(src);
        @NotNull OCConcurrentMostlySingularMultiUniqueMapBuilder<M> dest = new OCConcurrentMostlySingularMultiUniqueMapBuilder(src.size(), valuesEstimate, strategy);
        src.keySet().forEach(key -> src.processForKey(key, symbol -> {
            int n = count[1];
            count[1] = n + 1;
            if ((n & 0xFFFF) == 0) {
                progress.checkCanceled();
            }
            if (isActualSymbol.test((Object)symbol) && dest.addIfAbsent((String)key, (Object)symbol)) {
                count[0] = count[0] + 1;
            }
            return true;
        }));
        progress.checkCanceled();
        return dest;
    }

    @NotNull
    @Contract(value=" -> new")
    private OCGlobalProjectSymbolsCache.OCSymbols create() {
        MultiMap superTypeToClass = MultiMap.createSet();
        superTypeToClass.putAllValues(this.mySuperTypeToClass);
        OCLazyNamedSymbolCollection lazyNamedSymbols = this.myLazyNamedSymbols.isEmpty() ? OCLazyNamedSymbolCollection.EMPTY : new OCLazyNamedSymbolCollectionImpl(this.myLazyNamedSymbols);
        OCLazyNamedSymbolCollection lazyNamedMemberSymbols = this.myLazyNamedMemberSymbols.isEmpty() ? OCLazyNamedSymbolCollection.EMPTY : new OCLazyNamedSymbolCollectionImpl(this.myLazyNamedMemberSymbols);
        return new OCGlobalProjectSymbolsCache.OCSymbols(this.myCategoryToClass.build(), this.myTopLevelSymbols.build(), this.myMemberSymbols.build(), this.myCppMemberSymbols.build(), this.myTypeAliases.build(), (MultiMap<String, OCSymbol>)superTypeToClass, lazyNamedSymbols, lazyNamedMemberSymbols, this.myVersion);
    }

    public boolean process(@NotNull OCSymbol symbol) {
        if (symbol.getContainingFile() == null) {
            return true;
        }
        if (symbol instanceof OCLazyNamedSymbol) {
            if (!this.myLazyNamedSymbols.add((OCLazyNamedSymbol)symbol)) {
                return true;
            }
        } else {
            String name = symbol.getName();
            if (OCSymbolWithQualifiedName.isWithoutQualifier(symbol) ? !this.myTopLevelSymbols.addIfAbsent(name, symbol) : !this.myCppMemberSymbols.addIfAbsent(name, symbol)) {
                return true;
            }
        }
        if (symbol instanceof OCClassSymbol) {
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            String categoryName = classSymbol.getCategoryName();
            if (categoryName != null && !this.myCategoryToClass.addIfAbsent(categoryName, classSymbol)) {
                return true;
            }
            for (String superTypeName : classSymbol.getAllSuperTypeReferenceNames()) {
                if (superTypeName == null || superTypeName.isEmpty()) continue;
                this.mySuperTypeToClass.putValue((Object)superTypeName, (Object)symbol);
            }
            return classSymbol.processMembers(OCMemberSymbol.class, ocMemberSymbol -> {
                if (ocMemberSymbol instanceof OCLazyNamedSymbol) {
                    this.myLazyNamedMemberSymbols.add((OCLazyNamedSymbol)((Object)ocMemberSymbol));
                } else {
                    this.myMemberSymbols.addIfAbsent(ocMemberSymbol.getName(), (OCSymbol)ocMemberSymbol);
                }
                return true;
            });
        }
        if (symbol instanceof OCNamespaceSymbol) {
            return ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                public boolean process(OCSymbol ocSymbol) {
                    boolean isMember;
                    boolean bl = isMember = !(ocSymbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)ocSymbol).getQualifierParent() != null;
                    if (isMember && !OCGlobalProjectSymbolsBuilder.this.myCppMemberSymbols.addIfAbsent(ocSymbol.getName(), ocSymbol)) {
                        return true;
                    }
                    if (ocSymbol instanceof OCNamespaceSymbol) {
                        return ((OCNamespaceSymbol)ocSymbol).processMembers((String)null, this);
                    }
                    return true;
                }
            });
        }
        if (symbol.getKind().isTypedefOrAlias()) {
            String refName = symbol.getType().getName();
            this.myTypeAliases.addIfAbsent(refName, symbol);
        }
        return true;
    }

    private static final class StringToSymbolConcurrentMultiMap
    extends MultiMap<String, OCSymbol> {
        StringToSymbolConcurrentMultiMap(int size) {
            super(new ConcurrentHashMap(size));
        }

        StringToSymbolConcurrentMultiMap() {
            super(new ConcurrentHashMap());
        }

        @NotNull
        protected Collection<OCSymbol> createCollection() {
            return ConcurrentCollectionFactory.createConcurrentIdentitySet();
        }
    }
}

