/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.VirtualFileChangeListener;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapCacheBuildingSession;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLazyBlockStatementElementType;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.DirtyIncludesInvalidator;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildSymbolsVetoExtension;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.PeriodicBackgroundTask;
import com.jetbrains.cidr.lang.symbols.symtable.ProcessingDependencyGraph;
import com.jetbrains.cidr.lang.symbols.symtable.TableBuildingItem;
import com.jetbrains.cidr.lang.symbols.symtable.building.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class FileSymbolTablesCache
implements ProjectComponent {
    public static final Topic<PsiModificationTracker.Listener> OUT_OF_CODE_BLOCK_TOPIC = new Topic(PsiModificationTracker.Listener.class, Topic.BroadcastDirection.TO_PARENT);
    private static final Logger LOG = Logger.getInstance(FileSymbolTablesCache.class);
    private static final boolean USE_PSI_FOR_INVALIDATION = Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
    private static final boolean ARE_SYMBOLS_DISABLED = Registry.is((String)"cidr.disable.symbols", (boolean)false);
    private static volatile Boolean ourForceSymbolsLoadedInTests = null;
    private static final SymbolsProperties DEFAULT_SYMBOLS_PROPERTIES;
    private static volatile SymbolsProperties ourSymbolsProperties;
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
    private final FileSymbolTableUpdater myTableUpdater;
    private final Project myProject;
    private final Set<VirtualFile> myPendingReparses = new HashSet<VirtualFile>();
    private final Set<VirtualFile> myPendingPSIResets = new HashSet<VirtualFile>();
    private final Object mySerializationLock = new Object();
    private final PeriodicSerializationTask mySerializationTask = new PeriodicSerializationTask();
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final AtomicBoolean mySymbolsLoaded = new AtomicBoolean(false);
    private final ProcessingDependencyGraph<TableBuildingItem> myProcessingDependencyGraph = new ProcessingDependencyGraph();
    private final SerializationService mySerializationService;

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project) {
        return (FileSymbolTablesCache)project.getComponent(FileSymbolTablesCache.class);
    }

    public FileSymbolTablesCache(final @NotNull Project project) {
        this.myTableUpdater = new FileSymbolTableUpdater(project);
        this.myProject = project;
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiManager.dropPsiCaches();
                ((PsiModificationTracker.Listener)project.getMessageBus().syncPublisher(OUT_OF_CODE_BLOCK_TOPIC)).modificationCountChanged();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)new OCCodeBlockModificationListener(this.myProject));
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        this.listenOCWorkspaceChanges(connection);
        this.listenVFSChanges(connection);
        this.mySerializationService = SerializationService.getService();
    }

    private void listenOCWorkspaceChanges(MessageBusConnection connection) {
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                OCResolveRootAndConfigurationCache.getInstance(FileSymbolTablesCache.this.myProject).invalidateForAll();
                if (event.resolveConfigurationsChanged() || event.compilerSettingsChanged()) {
                    OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
                }
                FileSymbolTablesCache.this.incModificationCount();
            }

            public void selectedResolveConfigurationChanged() {
                OCResolveRootAndConfigurationCache.getInstance(FileSymbolTablesCache.this.myProject).invalidateForAll();
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }
        });
    }

    private void listenVFSChanges(MessageBusConnection connection) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false)).booleanValue()) {
            return;
        }
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VirtualFileChangeListener(true){
            private ClearTablesAndCollectNamesVisitor visitor;

            protected void begin() {
                this.visitor = new ClearTablesAndCollectNamesVisitor();
            }

            protected void onFileChange(@NotNull VirtualFile file, @NotNull VFileEvent event) {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                if (event.isFromSave()) {
                    return;
                }
                ClearTablesAndCollectNamesVisitor visitor = this.visitor;
                if (visitor != null) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)visitor);
                }
            }

            protected void done() {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                Set<String> toInvalidate = this.visitor.dirtyNames;
                boolean cacheCleared = this.visitor.cacheCleared;
                this.visitor = null;
                boolean includingFilesInvalidated = FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                if (includingFilesInvalidated || cacheCleared) {
                    FileSymbolTablesCache.this.incModificationCount();
                }
            }
        });
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        return this.myOutOfBlockModificationTracker;
    }

    public void projectOpened() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySerializationTask.schedule();
        }
    }

    public void projectClosed() {
        Disposer.dispose((Disposable)this.mySerializationTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldBuild(Predicate<@NotNull SymbolsProperties> predicate) {
        if (ARE_SYMBOLS_DISABLED) {
            return false;
        }
        if (OCBuildSymbolsVetoExtension.isVetoed()) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourSymbolsProperties == null || predicate.test(ourSymbolsProperties);
        }
    }

    public static boolean shouldBuildTables() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.buildSymbolsKind != SymbolsProperties.SymbolsKind.NO_SYMBOLS);
    }

    public static boolean shouldBuildTablesForAllSystemHeaders() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.buildSymbolsKind == SymbolsProperties.SymbolsKind.ALL_INCLUDING_UNUSED_SYSTEM_HEADERS);
    }

    private static boolean isSerializationEnabled() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.serializeSymbolTables);
    }

    private static boolean isDeserializationEnabled() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.deserializeSymbolTables);
    }

    @TestOnly
    @Nullable
    public static synchronized SymbolsProperties setShouldBuildTablesInTests(@Nullable SymbolsProperties properties) {
        SymbolsProperties prev = ourSymbolsProperties;
        ourSymbolsProperties = properties != null ? properties : DEFAULT_SYMBOLS_PROPERTIES;
        return prev;
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames) {
        return this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames, boolean isRelativePath) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dirtyNames.isEmpty()) {
            return false;
        }
        Set<VirtualFile> allCachedFiles = this.getCachedFiles();
        ImmutableList.Builder cachedFilesBuilder = ImmutableList.builderWithExpectedSize((int)allCachedFiles.size());
        for (VirtualFile cachedFile : allCachedFiles) {
            if (!cachedFile.isValid()) continue;
            cachedFilesBuilder.add((Object)cachedFile);
        }
        ImmutableList cachedFiles = cachedFilesBuilder.build();
        DirtyIncludesInvalidator invalidator = new DirtyIncludesInvalidator(this, dirtyNames, isRelativePath, cachedFiles.size());
        Collection<VirtualFile> pendingInvalidation = invalidator.collect((ImmutableList<VirtualFile>)cachedFiles);
        return this.invalidateDirtyIncludeFiles(pendingInvalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateDirtyIncludeFiles(@NotNull Collection<? extends VirtualFile> dirtyFiles) {
        boolean result = false;
        if (!dirtyFiles.isEmpty()) {
            HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
            for (VirtualFile virtualFile : dirtyFiles) {
                if (!this.invalidate(virtualFile, true, processedFiles, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(virtualFile);
                }
            }
            if (result) {
                OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
                OCResolveRootAndConfigurationCache.getInstance(this.myProject).invalidateForAll();
            }
        }
        this.schedulePSIUpdates();
        return result;
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Set<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return FileSymbolTableHelper.collectAllFilesToBuildTables(this.myProject);
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    @NotNull
    public @NotNull List<@NotNull VirtualFile> removeFilesFromCache(@NotNull @NotNull Iterable<@NotNull ? extends VirtualFile> files) {
        return CollectionsKt.filter(files, this::clearCache);
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file : this.myCache.keySet()) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            this.clearCache(file);
        }
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return this.forFile(virtualFile, context, null);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        Ref outTimeStamp;
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!FileSymbolTablesCache.shouldBuildTables() || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.mutablePackForFile(virtualFile, serializationSession);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null || context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel()) {
            return table;
        }
        return this.buildTableForFile(virtualFile, context, pack, (Ref<Integer>)outTimeStamp);
    }

    public boolean isBuildingTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCLanguageKind languageKind) {
        Thread currentThread = Thread.currentThread();
        TableBuildingItem item = new TableBuildingItem(virtualFile, languageKind);
        return this.myProcessingDependencyGraph.isAlreadyProcessing(item, currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileSymbolTable buildTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @NotNull FileSymbolTablesPack pack, @NotNull Ref<Integer> outTimeStamp) {
        FileSymbolTablesPack fileSymbolTablesPack;
        Object object;
        Thread currentThread = Thread.currentThread();
        TableBuildingItem item = new TableBuildingItem(virtualFile, context.getLanguageKind());
        ProcessingDependencyGraph.State state = null;
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "waitForPack", (Object)item);){
            object = pack;
            synchronized (object) {
                ProgressManager.checkCanceled();
                FileSymbolTable table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                if (table != null) {
                    FileSymbolTable fileSymbolTable = table;
                    return fileSymbolTable;
                }
                state = this.myProcessingDependencyGraph.startProcessing(item, currentThread, context.getImpatientRescheduling());
                while (state == ProcessingDependencyGraph.State.WAIT) {
                    pack.wait(50L);
                    ProgressManager.checkCanceled();
                    table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                    if (table != null) {
                        FileSymbolTable fileSymbolTable = table;
                        return fileSymbolTable;
                    }
                    if (!this.myProcessingDependencyGraph.retryStartProcessing(item, currentThread)) continue;
                    state = ProcessingDependencyGraph.State.ACQUIRED;
                }
            }
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        finally {
            if (state == ProcessingDependencyGraph.State.WAIT) {
                this.myProcessingDependencyGraph.stopWaiting(currentThread);
            }
        }
        FileSymbolTable builtTable = null;
        try {
            if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                OCBuildingActivityExecutionService.getInstance().assertParsingAndSymbolBuildingAllowed(this.myProject);
            }
            builtTable = FileSymbolTableHelper.calculateTable(virtualFile, context);
            context.addProcessedFile(virtualFile);
            object = builtTable;
            if (state != ProcessingDependencyGraph.State.ACQUIRED) {
                if (state != ProcessingDependencyGraph.State.RECURSIVE) return object;
                if (builtTable == null) return object;
            }
            fileSymbolTablesPack = pack;
        }
        catch (Throwable throwable) {
            if (state != ProcessingDependencyGraph.State.ACQUIRED) {
                if (state != ProcessingDependencyGraph.State.RECURSIVE) throw throwable;
                if (builtTable == null) throw throwable;
            }
            FileSymbolTablesPack fileSymbolTablesPack2 = pack;
            synchronized (fileSymbolTablesPack2) {
                if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                    this.myProcessingDependencyGraph.finishProcessing(item);
                    pack.notifyAll();
                }
                if (builtTable == null) throw throwable;
                pack.addCompactSynchronized(this.myProject, builtTable);
                this.notifyNewTables(virtualFile);
                throw throwable;
            }
        }
        synchronized (fileSymbolTablesPack) {
            if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                this.myProcessingDependencyGraph.finishProcessing(item);
                pack.notifyAll();
            }
            if (builtTable == null) return object;
            pack.addCompactSynchronized(this.myProject, builtTable);
            this.notifyNewTables(virtualFile);
            return object;
        }
    }

    private void notifyNewTables(@NotNull VirtualFile virtualFile) {
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasNewSymbolTableInPack(virtualFile);
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        FileSymbolTablesPack pack = this.packForFile(file);
        return pack != null ? pack.findConformingTable(context, 0, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingReparses.add(OCFileUtil.getVirtualFile(file));
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                this.myPendingReparses.add(OCFileUtil.getVirtualFile(file));
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        ArrayList<VirtualFile> toResetPSI;
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<VirtualFile> toReparse = new HashSet<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI = new ArrayList<VirtualFile>(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                FileViewProvider pp;
                if (!virtualFile.isValid() || (pp = fileManager.findCachedViewProvider(virtualFile)) == null) continue;
                OCLog.LOG.assertTrue(pp instanceof AbstractFileViewProvider, (Object)pp);
                for (PsiFile cached : ((AbstractFileViewProvider)pp).getCachedPsiFiles()) {
                    FileSymbolTablesCache.processDirtyFile(toReparse, cached, virtualFile);
                }
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file : toResetPSI) {
                    fileManager.setViewProvider(file, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static void processDirtyFile(@NotNull Set<VirtualFile> dirty, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        if (FileSymbolTableHelper.isSourceFile(virtualFile, file.getProject()) && file instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidate(@Nullable VirtualFile file, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        if (file == null || !processed.add(file)) {
            return false;
        }
        boolean result = this.clearCache(file);
        if (file.isValid() && FileSymbolTableHelper.isSourceFile(file, this.myProject)) {
            this.myTableUpdater.addFileForUpdate(file);
        }
        if (withIncludingFiles) {
            Collection configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance((Project)this.myProject);
            if (!OCRootUtil.isNeedToFindRoot(file, this.myProject)) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, file);
                }
            }
            if (!(configs = OCPCHCache.getBuildConfigurationByPchFile((VirtualFile)file, (Project)this.myProject)).isEmpty()) {
                Runnable runnable = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    List<VirtualFile> clearedFiles = this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    if (clearedFiles.isEmpty()) {
                        return;
                    }
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(clearedFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                }
            }
            HashSet<VirtualFile> includingFiles = new HashSet<VirtualFile>();
            if (USE_PSI_FOR_INVALIDATION) {
                PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file, this.myProject);
                if (psiFile instanceof OCFile) {
                    Collection<VirtualFile> includingFromPsi = ((OCFile)psiFile).resetIncludingFiles();
                    includingFiles.addAll(includingFromPsi);
                }
            } else {
                Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.getInstance(this.myProject).findImmediateIncludingFiles(file, false);
                includingFiles.addAll(immediateIncludingFiles);
            }
            for (VirtualFile including : includingFiles) {
                if (!this.invalidate(including, reparse, processed, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    dirtySet.add(including);
                }
            }
        }
        return result;
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        this.myTableUpdater.ensurePendingFilesProcessed(rootsOnly);
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull PsiFile file) {
        return this.allTablesForFile(OCFileUtil.getVirtualFile(file));
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        return pack != null ? pack.getTablesSynchronized() : ContainerUtil.emptyList();
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        return pack != null ? pack.getTablesCountSynchronized() : 0;
    }

    @Nullable
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        return (FileSymbolTablesPack)this.myCache.get(virtualFile);
    }

    @NotNull
    private FileSymbolTablesPack mutablePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.get(virtualFile);
        if (pack != null) {
            return pack;
        }
        FileSymbolTablesPack deserializedPack = this.deserializePackForFile(virtualFile, serializationSession);
        FileSymbolTablesPack newPack = deserializedPack != null ? deserializedPack : new FileSymbolTablesPack();
        return this.addDeserializedPack(virtualFile, newPack);
    }

    @NotNull
    private FileSymbolTablesPack addDeserializedPack(@NotNull VirtualFile virtualFile, @NotNull FileSymbolTablesPack newPack) {
        FileSymbolTablesPack prev = this.myCache.putIfAbsent(virtualFile, newPack);
        if (prev == null) {
            if (newPack.getTablesCountSynchronized() > 0) {
                newPack.onThaw(this.myProject);
                this.notifyNewTables(virtualFile);
            }
            return newPack;
        }
        return prev;
    }

    @Nullable
    private FileSymbolTablesPack deserializePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        if (serializationSession != null && FileSymbolTablesCache.isDeserializationEnabled() && virtualFile instanceof VirtualFileWithId) {
            return SerializationService.getService().deserializeTables(this.myProject, serializationSession, virtualFile);
        }
        return null;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove(this.myProject);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onAllSymbolTablesDropped();
    }

    private boolean clearCache(@NotNull VirtualFile file) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.remove(file);
        if (pack != null) {
            pack.onRemove(this.myProject);
            ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasInvalidSymbolTableInPack(file);
        }
        return pack != null;
    }

    private int fillCache(Map<VirtualFile, FileSymbolTablesPack> packs) {
        for (FileSymbolTablesPack pack : packs.values()) {
            pack.onThaw(this.myProject);
        }
        this.myCache.putAll(packs);
        return packs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        Object object = this.mySerializationLock;
        synchronized (object) {
            if (!FileSymbolTablesCache.isSerializationEnabled()) {
                return;
            }
            HashMap<VirtualFile, FileSymbolTablesPack> tables = new HashMap<VirtualFile, FileSymbolTablesPack>();
            for (VirtualFile file : files) {
                FileSymbolTablesPack pack = this.packForFile(file);
                if (pack == null) continue;
                tables.put(file, pack);
            }
            this.mySerializationService.serializeTables(this.myProject, projectLocationHash, tables, indicator);
        }
    }

    public static boolean areSymbolsLoaded(@NotNull Project project) {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance = (FileSymbolTablesCache)project.getComponent(FileSymbolTablesCache.class);
        return instance == null || !FileSymbolTablesCache.shouldBuildTables() || instance.mySymbolsLoaded.get();
    }

    public boolean areSymbolsLoaded() {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        return !FileSymbolTablesCache.shouldBuildTables() || this.mySymbolsLoaded.get();
    }

    public static boolean areSymbolsLoadedOrSymbolBuildingAllowed(@NotNull Project project) {
        return FileSymbolTablesCache.areSymbolsLoaded(project) || OCBuildingActivityExecutionService.getInstance().isSymbolBuildingAllowed(project);
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    public boolean isUpToDate(boolean rootsOnly) {
        return FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.myTableUpdater.isUpToDate(rootsOnly);
    }

    @TestOnly
    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    @TestOnly
    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    public void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    public void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void removeJunkTables(boolean includingUnused) {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeJunkTables(this.myProject, includingUnused);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        return result;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithNonFallbackTables(boolean withUsedTablesOnly) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            if (pack.isFallback() || withUsedTablesOnly && !pack.hasUsedTables()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        return result;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return 0L;
        }
        Map<VirtualFile, FileSymbolTablesPack> packs = this.mySerializationService.deserializeTables(this.myProject, projectLocationHash, filesToLoad, indicator, indicatorScale);
        return this.fillCache(packs);
    }

    public void deserializeTables(@NotNull SerializationSession session, @NotNull VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file) != null) {
            return;
        }
        FileSymbolTablesPack pack = this.deserializePackForFile(file, session);
        if (pack != null) {
            this.addDeserializedPack(file, pack);
        }
    }

    public void handleOutOfCodeBlockChange(@NotNull PsiFile file, boolean hasMacro) {
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        if (FileSymbolTableHelper.isSourceFile(virtualFile, file.getProject())) {
            if (this.invalidate(virtualFile, false, (Set<VirtualFile>)new SmartHashSet(), hasMacro)) {
                OCHeaderContextCache.invalidateHeaderContextsExcept(virtualFile, file.getProject());
                this.incModificationCount();
            }
            this.schedulePSIUpdates();
        }
        if (hasMacro) {
            OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
            OCResolveRootAndConfigurationCache.getInstance(file.getProject()).invalidateForAllExcept(virtualFile);
        }
    }

    public void incModificationCount() {
        this.myOutOfBlockModificationTracker.incModificationCount();
    }

    public void dumpStats(@Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalTables = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            List tables = pack.getTablesSynchronized();
            if (tables.size() > 1) {
                ++multiTableFiles;
                Function tablePrinter = table -> Integer.toString(table.getUsageCount());
                int symbolCount = 0;
                int contentsCount = 0;
                ReferenceOpenHashSet uniqueSymbols = new ReferenceOpenHashSet();
                HashSet<List<OCSymbol>> uniqueContents = new HashSet<List<OCSymbol>>();
                int uniqueContentsLength = 0;
                for (FileSymbolTable table2 : tables) {
                    List<OCSymbol> contents = table2.getContents();
                    symbolCount += contents.size();
                    uniqueSymbols.addAll(contents);
                    ++contentsCount;
                    if (!uniqueContents.add(contents)) continue;
                    uniqueContentsLength += contents.size();
                }
                totalSymbols += symbolCount;
                totalUniqueSymbols += uniqueSymbols.size();
                totalTables += contentsCount;
                totalContents += contentsCount;
                totalUniqueContents += uniqueContents.size();
                totalUniqueContentsLen += uniqueContentsLength;
                double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
                if (reuseFactor == 0.5) {
                    int br_1371 = 0;
                    ++br_1371;
                }
                if (reuseFactor < 0.005) {
                    int br_1379 = 0;
                    ++br_1379;
                }
                String num = String.format("%5d", totalFiles + 1);
                Object contentsReuseInfo = "";
                if (uniqueContents.size() != contentsCount) {
                    contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
                }
                String tableBaseInfo = file.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + (String)contentsReuseInfo + "] ";
                out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
                tables = ContainerUtil.sorted(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
                out.println(num + "    " + tableBaseInfo + StringUtil.join((Collection)tables, (Function)tablePrinter, (String)", "));
                continue;
            }
            ++totalTables;
        }
        out.println("============================");
        out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        out.println("uniqueMultiTables/totalMultiTables = " + totalUniqueContents + "/" + totalContents);
        out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
        out.println("uniqueTables/totalTables = " + (totalUniqueContents + totalFiles - multiTableFiles) + "/" + totalTables);
    }

    public void dumpTablePackStats(@NotNull VirtualFile file, @Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        out.println(file.getPath());
        List<FileSymbolTable> tables = this.allTablesForFile(file);
        out.println("Total: " + tables.size());
        int i = 0;
        for (FileSymbolTable table : tables) {
            out.println("=> " + i + " -> " + table.getContents().size() + " (valid: " + table.isValid() + ", fallback: " + table.isFallback() + ")");
            table.getSignature().dumpStats(out);
            ++i;
        }
    }

    static {
        ourSymbolsProperties = DEFAULT_SYMBOLS_PROPERTIES = ApplicationManager.getApplication().isUnitTestMode() ? SymbolsProperties.NO_SYMBOLS : null;
    }

    class PeriodicSerializationTask
    extends PeriodicBackgroundTask {
        PeriodicSerializationTask() {
        }

        @Override
        protected void runInBackground() {
            ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            indicator.setIndeterminate(false);
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (this.shouldStop() || !this.shouldRun()) {
                    return;
                }
                ArrayList<VirtualFile> fs = new ArrayList<VirtualFile>();
                for (VirtualFile file : FileSymbolTablesCache.this.myCache.keySet()) {
                    ProgressManager.checkCanceled();
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)FileSymbolTablesCache.this.myCache.get(file);
                    if (pack == null || !pack.shouldSerialize()) continue;
                    fs.add(file);
                }
                if (fs.isEmpty()) {
                    return;
                }
                String projectHash = FileSymbolTablesCache.this.myProject.getLocationHash();
                FileSymbolTablesCache.this.serializeTables(projectHash, fs, (ProgressIndicator)indicator);
            }, (ProgressIndicator)indicator);
        }

        @Override
        protected boolean shouldStop() {
            return !FileSymbolTablesCache.this.myProject.isOpen() || FileSymbolTablesCache.this.myProject.isDisposed();
        }

        @Override
        protected boolean shouldRun() {
            return super.shouldRun() && FileSymbolTablesCache.isSerializationEnabled() && !DumbService.isDumb((Project)FileSymbolTablesCache.this.myProject) && FileSymbolTablesCache.this.isUpToDate();
        }
    }

    private static class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Project myProject;
        private final Key<String> FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");

        private OCCodeBlockModificationListener(@NotNull Project project) {
            this.myProject = project;
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            PsiFile file = this.getFile(event);
            if (file == null) {
                return;
            }
            if (!FileSymbolTableHelper.isSourceFile(file)) {
                return;
            }
            if (!(event.getParent() instanceof PsiDirectory) && !FileSymbolTableHelper.shouldProcessPsiEvent(file)) {
                return;
            }
            boolean shouldCheckDocCreation = ApplicationManager.getApplication().isInternal();
            Document docToCheck = shouldCheckDocCreation ? PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file) : null;
            Delta delta = this.processChange(event, file);
            if (delta != null && delta.shift != 0) {
                this.validate(file, delta.start, delta.shift);
            }
            if (event.isGenericChange() && (stamp = (String)file.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file))) {
                    this.getFileSymbolTablesCache().handleOutOfCodeBlockChange(file, true);
                }
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
            if (shouldCheckDocCreation && docToCheck == null && PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file) != null) {
                LOG.error("documents must not be created during event processing: " + event);
            }
        }

        @NotNull
        private FileSymbolTablesCache getFileSymbolTablesCache() {
            return FileSymbolTablesCache.getInstance(this.myProject);
        }

        @Nullable
        private Delta processChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: 
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(event, file);
                    return null;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    return null;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: 
                case CHILDREN_CHANGED: {
                    return this.processChildChange(event, file);
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    this.getFileSymbolTablesCache().incModificationCount();
                    return null;
                }
            }
            LOG.error("Unknown code:" + event.getCode());
            return null;
        }

        @Nullable
        private PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
            PsiFile childFile;
            PsiFile file = event.getFile();
            if (file != null) {
                return file;
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = childFile = child != null ? child.getContainingFile() : null;
            if (childFile != null) {
                return childFile;
            }
            PsiElement parent = event.getParent();
            return parent != null ? parent.getContainingFile() : null;
        }

        @Nullable
        private Delta processChildChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.isGenericChange()) {
                return null;
            }
            if (this.isOutOfCodeBlockChange(event, file)) {
                this.getFileSymbolTablesCache().handleOutOfCodeBlockChange(file, false);
                return null;
            }
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            int offset = event.getOffset();
            switch (event.getCode()) {
                case CHILD_ADDED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength());
                }
                case CHILD_REMOVED: {
                    return new Delta(offset, -event.getOldLength());
                }
                case CHILD_REPLACED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength() - event.getOldLength());
                }
                case CHILDREN_CHANGED: {
                    assert (parent != null);
                    return new Delta(offset, parent.getTextLength() - event.getOldLength());
                }
            }
            OCLog.LOG.error("unexpected event code: " + event.getCode());
            return null;
        }

        private boolean checkInvalid(@NotNull PsiTreeChangeEvent event, @NotNull PsiElement psi) {
            if (!psi.isValid()) {
                LOG.warn("Invalid PSI in OCCodeBlockModificationListener.treeChanged: " + psi + ", event: " + event);
                return true;
            }
            return false;
        }

        private void processBeforeChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE && event.getParent() instanceof PsiFile) {
                return;
            }
            boolean isFile = event.getChild() instanceof PsiFile;
            if (!isFile && !(file instanceof OCCodeFragment) && file.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file));
            }
        }

        private boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @Nullable PsiFile file) {
            if (file instanceof OCCodeFragment) {
                return false;
            }
            PsiElement element = event.getParent();
            if (element instanceof PsiFileSystemItem) {
                return true;
            }
            if (element == null || element.getParent() == null) {
                return false;
            }
            return FileSymbolTableHelper.isOutOfCodeBlockChange(event, element.getContainingFile());
        }

        @NotNull
        private String macroStamp(PsiFile file) {
            if (!(file instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file.getNode(), acc);
            return acc.toString();
        }

        private void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (elementType instanceof OCLazyBlockStatementElementType) {
                return;
            }
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private void validate(@NotNull PsiFile file, int start, int lengthShift) {
            FileSymbolTablesPack pack = this.getFileSymbolTablesCache().packForFile(OCFileUtil.getVirtualFile(file));
            if (pack != null) {
                pack.updateOffsetsSynchronized(start, lengthShift);
            }
        }
    }

    public static final class SymbolsProperties {
        public static final SymbolsProperties NO_SYMBOLS = new SymbolsProperties(SymbolsKind.NO_SYMBOLS, false, false);
        @NotNull
        private final SymbolsKind buildSymbolsKind;
        private final boolean deserializeSymbolTables;
        private final boolean serializeSymbolTables;

        public SymbolsProperties(@NotNull SymbolsKind buildSymbolKind, boolean deserializeSymbolTables, boolean serializeSymbolTables) {
            this.buildSymbolsKind = buildSymbolKind;
            this.deserializeSymbolTables = deserializeSymbolTables;
            this.serializeSymbolTables = serializeSymbolTables;
        }

        public static enum SymbolsKind {
            NO_SYMBOLS,
            ONLY_USED,
            ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;

        }
    }

    private static final class Delta {
        final int start;
        final int shift;

        private Delta(int start, int shift) {
            this.start = start;
            this.shift = shift;
        }
    }

    private final class ClearTablesAndCollectNamesVisitor
    extends VirtualFileVisitor<Object> {
        @NotNull
        final Set<String> dirtyNames;
        boolean cacheCleared;

        private ClearTablesAndCollectNamesVisitor() {
            super(new VirtualFileVisitor.Option[0]);
            this.dirtyNames = CollectionFactory.createFilePathSet();
            this.cacheCleared = false;
        }

        @Nullable
        public Collection<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
            return file.isDirectory() ? ((NewVirtualFile)file).getCachedChildren() : null;
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            if (file.isDirectory()) {
                return true;
            }
            if (FileSymbolTablesCache.this.clearCache(file)) {
                this.cacheCleared = true;
                FileSymbolTablesCache.this.addFileToCache(file);
            }
            this.dirtyNames.add(file.getName());
            return true;
        }
    }
}

