/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.EmptySymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u0015H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0015H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0015\u001a\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0015\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u001a\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0015\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableProvider;", "providers", "", "getProviders", "()Ljava/util/List;", "calculateTable", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "calculateTableUsingPSI", "file", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "collectAllFilesToBuildTables", "", "project", "Lcom/intellij/openapi/project/Project;", "findProvider", "Lcom/intellij/psi/PsiFile;", "getFileText", "", "getProvider", "isOutOfCodeBlockChange", "", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "isPreProcessable", "isSourceFile", "missingProvider", "Lcom/jetbrains/cidr/lang/symbols/symtable/EmptySymbolTableProvider;", "shouldProcessPsiEvent", "intellij.c"})
@JvmName(name="FileSymbolTableHelper")
public final class FileSymbolTableHelper {
    @JvmField
    @NotNull
    public static final ExtensionPointName<FileSymbolTableProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.symbolTableProvider");

    public static final boolean isSourceFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return FileSymbolTableHelper.findProvider(virtualFile, project) != null;
    }

    public static final boolean isSourceFile(@NotNull PsiFile file) {
        return FileSymbolTableHelper.findProvider(file) != null;
    }

    @NotNull
    public static final CharSequence getFileText(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return FileContentSnapshot.get(virtualFile, project).getText();
    }

    @NotNull
    public static final FileSymbolTable calculateTable(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return FileSymbolTableHelper.getProvider(virtualFile, context).calculateTable(virtualFile, context);
    }

    @NotNull
    public static final FileSymbolTable calculateTableUsingPSI(@NotNull OCFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return FileSymbolTableHelper.getProvider(file).calculateTableUsingPSI(file, virtualFile, context);
    }

    public static final boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
        return FileSymbolTableHelper.getProvider(file).isOutOfCodeBlockChange(event);
    }

    public static final boolean isPreProcessable(@NotNull VirtualFile file, @NotNull Project project) {
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file, project);
        return fileSymbolTableProvider != null ? fileSymbolTableProvider.shouldPreProcess() : false;
    }

    public static final boolean shouldProcessPsiEvent(@NotNull PsiFile file) {
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file);
        return fileSymbolTableProvider != null ? fileSymbolTableProvider.shouldProcessPsiEvents(file) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<VirtualFile> collectAllFilesToBuildTables(@NotNull Project project) {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = FileSymbolTableHelper.getProviders();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.collectFilesToBuildTables(project);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    private static final FileSymbolTableProvider findProvider(PsiFile file) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final FileSymbolTableProvider findProvider(VirtualFile file, Project project) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file, project)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final FileSymbolTableProvider getProvider(PsiFile file) {
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file);
        if (fileSymbolTableProvider == null) {
            fileSymbolTableProvider = FileSymbolTableHelper.missingProvider(file.getVirtualFile());
        }
        return fileSymbolTableProvider;
    }

    private static final FileSymbolTableProvider getProvider(VirtualFile file, OCInclusionContext context) {
        FileSymbolTableProvider fileSymbolTableProvider;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file, context)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((fileSymbolTableProvider = (FileSymbolTableProvider)v0) == null) {
            fileSymbolTableProvider = FileSymbolTableHelper.missingProvider(file);
        }
        return fileSymbolTableProvider;
    }

    private static final EmptySymbolTableProvider missingProvider(VirtualFile file) {
        EmptySymbolTableProvider emptySymbolTableProvider;
        EmptySymbolTableProvider it = emptySymbolTableProvider = EmptySymbolTableProvider.INSTANCE;
        boolean bl = false;
        OCLog.LOG.error(StringsKt.trimIndent((String)("\n    FileSymbolTable was asked for a symbol table of file \"" + file.getName() + "\" of " + file.getClass() + ". \n    No provider accepted it. \n  ")));
        return emptySymbolTableProvider;
    }

    private static final List<FileSymbolTableProvider> getProviders() {
        return EP_NAME.getExtensionList();
    }
}

