/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapHeaderResolve;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.CallerAwareJob;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DirtyIncludesInvalidator
extends CallerAwareJob<Collection<VirtualFile>> {
    @NotNull
    private final FileSymbolTablesCache myCache;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final MyConcurrentObjBoolMap<QualifiedName> moduleDirtyCache = new MyConcurrentObjBoolMap();
    @NotNull
    private final Set<String> myDirtyNames;
    private final boolean myIsRelativePath;

    DirtyIncludesInvalidator(@NotNull FileSymbolTablesCache cache, @NotNull Set<String> dirtyNames, boolean isRelativePath, int estimatedWorksetSize) {
        super(estimatedWorksetSize);
        this.myCache = cache;
        this.moduleMapManager = ModuleMapManager.getInstance(cache.getProject());
        this.myDirtyNames = dirtyNames;
        this.myIsRelativePath = isRelativePath;
    }

    @NotNull
    Collection<VirtualFile> collect(@NotNull ImmutableList<VirtualFile> workset2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (Collection)this.run(new FileWorker(null, workset2));
    }

    private static final class MyConcurrentObjBoolMap<T> {
        @NotNull
        private final Object2ByteOpenHashMap<T> map = new Object2ByteOpenHashMap();
        @NotNull
        private final Lock r;
        @NotNull
        private final Lock w;

        MyConcurrentObjBoolMap() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.w = lock.writeLock();
            this.r = lock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Boolean getBoolean(@NotNull T key) {
            this.r.lock();
            try {
                byte b = this.map.getByte(key);
                Boolean bl = b == 0 ? null : Boolean.valueOf(b > 0);
                return bl;
            }
            finally {
                this.r.unlock();
            }
        }

        void putBoolean(@NotNull T key, boolean value) {
            this.w.lock();
            try {
                this.map.put(key, (byte)(value ? 1 : -1));
            }
            finally {
                this.w.unlock();
            }
        }
    }

    private final class FileWorker
    extends CallerAwareJob.IterativeWorker<VirtualFile> {
        @NotNull
        private final Map<QualifiedName, Collection<VirtualFile>> additionalModulesWorkset;
        @NotNull
        private final Set<QualifiedName> newModulesImportedByFile;
        @NotNull
        private final List<VirtualFile> result;

        private FileWorker(@NotNull FileWorker parent, ImmutableList<? extends VirtualFile> workset2) {
            super(DirtyIncludesInvalidator.this, parent, workset2);
            this.additionalModulesWorkset = new HashMap<QualifiedName, Collection<VirtualFile>>();
            this.newModulesImportedByFile = new HashSet<QualifiedName>();
            this.result = new ArrayList<VirtualFile>();
        }

        @Nullable
        private FileWorker getParent() {
            return (FileWorker)this.getCompleter();
        }

        @NotNull
        protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset2) {
            return new FileWorker(this, workset2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(@NotNull ImmutableList<? extends VirtualFile> workset2) {
            block3: for (VirtualFile file : workset2) {
                this.newModulesImportedByFile.clear();
                for (FileSymbolTable table : DirtyIncludesInvalidator.this.myCache.allTablesForFile(file)) {
                    for (OCSymbol include : table.getContents()) {
                        if (!(include instanceof OCIncludeSymbol ? this.isIncludeDirty((OCIncludeSymbol)include) : include instanceof OCModuleImportSymbol && this.isModuleDirty((OCModuleImportSymbol)include))) continue;
                        List<VirtualFile> list = this.result;
                        synchronized (list) {
                            this.result.add(file);
                            continue block3;
                        }
                    }
                }
                for (QualifiedName moduleName : this.newModulesImportedByFile) {
                    this.additionalModulesWorkset.computeIfAbsent(moduleName, m -> new SmartList()).add(file);
                }
            }
        }

        private boolean isIncludeDirty(@NotNull OCIncludeSymbol includeSymbol) {
            return DirtyIncludesInvalidator.this.myDirtyNames.contains(DirtyIncludesInvalidator.this.myIsRelativePath ? includeSymbol.getRelativePath() : includeSymbol.getLastPathComponent());
        }

        private boolean isModuleDirty(@NotNull OCModuleImportSymbol include) {
            QualifiedName moduleName = include.getModuleName();
            if (moduleName == null) {
                return false;
            }
            Boolean dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName);
            if (dirty == null) {
                this.newModulesImportedByFile.add(moduleName);
            }
            return dirty == Boolean.TRUE;
        }

        @Override
        protected void processingFinished() {
            if (!this.additionalModulesWorkset.isEmpty()) {
                DirtyIncludesInvalidator.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
            }
            this.tryComplete();
        }

        @Override
        public void onCompletion(@NotNull CountedCompleter<?> caller) {
            FileWorker parent = this.getParent();
            if (parent != null && !this.result.isEmpty()) {
                parent.propagateResults(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void propagateResults(Collection<VirtualFile> childResults) {
            List<VirtualFile> list = this.result;
            synchronized (list) {
                this.result.addAll(childResults);
            }
        }

        @Override
        public List<VirtualFile> getRawResult() {
            return this.result;
        }
    }

    private final class ModuleWorker
    extends CountedCompleter<Collection<VirtualFile>>
    implements BiConsumer<QualifiedName, Collection<VirtualFile>> {
        @NotNull
        private final Map<QualifiedName, Collection<VirtualFile>> workset;
        @NotNull
        private final Set<VirtualFile> result;

        private ModuleWorker(@NotNull FileWorker parent, Map<QualifiedName, Collection<VirtualFile>> workset2) {
            super(parent);
            this.result = new HashSet<VirtualFile>();
            this.workset = workset2;
        }

        @NotNull
        private FileWorker getParent() {
            return (FileWorker)this.getCompleter();
        }

        @Override
        public void compute() {
            AlreadyComputedRemover remover = new AlreadyComputedRemover();
            DirtyIncludesInvalidator.this.moduleDirtyCache.r.lock();
            try {
                this.workset.forEach(remover);
            }
            finally {
                DirtyIncludesInvalidator.this.moduleDirtyCache.r.unlock();
            }
            this.workset.forEach(this);
            this.tryComplete();
        }

        @Override
        public void accept(@NotNull QualifiedName moduleName, @NotNull Collection<VirtualFile> files) {
            if (files.isEmpty()) {
                return;
            }
            ModuleMapManager.Cache globalCache = DirtyIncludesInvalidator.this.moduleMapManager.getGlobalCache();
            ModuleMapSymbol module = globalCache.findModule(moduleName);
            if (module != null) {
                for (String name : DirtyIncludesInvalidator.this.myIsRelativePath ? ModuleMapHeaderResolve.getIncludeHeaderRelativePaths(module) : ContainerUtil.map(module.getIncludeHeaders(), VirtualFile::getName)) {
                    if (!DirtyIncludesInvalidator.this.myDirtyNames.contains(name)) continue;
                    DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, true);
                    this.result.addAll(files);
                    return;
                }
            }
            DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, false);
        }

        @Override
        public Set<VirtualFile> getRawResult() {
            return this.result;
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (!this.result.isEmpty()) {
                this.getParent().propagateResults(this.result);
            }
        }

        private class AlreadyComputedRemover
        implements BiConsumer<QualifiedName, Collection<VirtualFile>> {
            private AlreadyComputedRemover() {
            }

            @Override
            public void accept(@NotNull QualifiedName moduleName, @NotNull Collection<VirtualFile> files) {
                Boolean dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName);
                if (dirty == null) {
                    return;
                }
                if (dirty.booleanValue()) {
                    ModuleWorker.this.result.addAll(files);
                }
                files.clear();
            }
        }
    }
}

