/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.search.OCSearchHelper;
import com.jetbrains.cidr.lang.symbols.OCNonNavigatableSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableModificationTracker;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGlobalProjectSymbolsCache<T extends OCSymbol, S extends Symbols<T>> {
    @NotNull
    private final CachedValue<S> myGlobalSymbols;
    @NotNull
    private final ReentrantLock myGlobalSymbolsLock = new ReentrantLock();
    @NotNull
    private final CachedValue<MultiMap<String, T>> myGlobalShortNames;
    @NotNull
    private final ReentrantLock myGlobalShortNamesLock = new ReentrantLock();

    protected <Impl extends AbstractGlobalProjectSymbolsCache<T, S>> AbstractGlobalProjectSymbolsCache(@NotNull Class<Impl> clazz, @NotNull Project project) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        OCFileSymbolTableModificationTracker FSTmt = OCFileSymbolTableModificationTracker.getInstance(project);
        this.myGlobalSymbols = manager.createCachedValue(() -> {
            if (!FileSymbolTablesCache.areSymbolsLoaded(project)) {
                throw IndexNotReadyException.create();
            }
            S symbols = this.buildGlobalSymbols(project);
            return CachedValueProvider.Result.create(symbols, (Object[])new Object[]{FSTmt});
        }, false);
        this.myGlobalShortNames = manager.createCachedValue(() -> {
            assert (FileSymbolTablesCache.areSymbolsLoaded(project)) : "Symbols must be loaded";
            MultiMap result = new MultiMap();
            AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, symbol -> {
                if (!(symbol instanceof OCNonNavigatableSymbol)) {
                    result.putValue((Object)symbol.getName(), symbol);
                }
                return true;
            }, null);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{FSTmt});
        }, false);
    }

    @Nullable
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> T findNearestTopLevelSymbol(@NotNull Class<Impl> clazz, @NotNull Project project, @Nullable String name, @Nullable Condition<? super T> condition, @Nullable VirtualFile contextFile) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor<T>((Processor)finder, true, new Condition[]{symbol -> Objects.equals(symbol.getContainingFile(), contextFile), symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Objects.equals(file.getNameWithoutExtension(), contextFile.getNameWithoutExtension());
        }, symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Objects.equals(file.getParent(), contextFile.getParent());
        }, symbol -> {
            VirtualFile symbolFile = symbol.getContainingFile();
            return OCSearchHelper.areFromSameProject(project, contextFile, symbolFile);
        }, Conditions.alwaysTrue()}){

            @Override
            @NotNull
            public Collection<T> sort(Collection<T> collection) {
                ArrayList list = new ArrayList(collection);
                list.sort(Comparator.comparingInt(Object::hashCode));
                return list;
            }
        };
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, symbol -> {
            if (condition != null && !condition.value(symbol)) {
                return true;
            }
            if (OCSearchHelper.isFromWrongSDK(project, symbol, contextFile)) {
                return true;
            }
            return orderedProcessor.process(symbol);
        }, name, true);
        orderedProcessor.finish();
        return (T)((OCSymbol)finder.getFoundValue());
    }

    @NotNull
    public static <T> T getInstance(@NotNull Class<T> clazz, @NotNull Project project) {
        return (T)project.getComponent(clazz);
    }

    @NotNull
    protected S getGlobalSymbols() {
        return (S)((Symbols)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalSymbolsLock, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, () -> (Symbols)this.myGlobalSymbols.getValue()));
    }

    @Nullable
    protected S getUpToDateGlobalSymbols() {
        return (S)((Symbols)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalSymbolsLock, (int)0, (TimeUnit)TimeUnit.MILLISECONDS, () -> (Symbols)ObjectUtils.doIfNotNull((Object)this.myGlobalSymbols.getUpToDateOrNull(), Supplier::get)));
    }

    @NotNull
    protected MultiMap<String, T> getGlobalShortNames() {
        return (MultiMap)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalShortNamesLock, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, () -> (MultiMap)this.myGlobalShortNames.getValue());
    }

    @NotNull
    protected abstract S buildGlobalSymbols(@NotNull Project var1);

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name) {
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, true);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name) {
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, false);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processByQualifiedName(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @NotNull String name) {
        Collection iterable = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalShortNames().get((Object)name);
        return iterable.isEmpty() || ContainerUtil.process((Iterable)iterable, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache> boolean processAliasNamesForType(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull String name, @NotNull Processor<? super String> processor2) {
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        return ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalSymbols().processAliasNamesForType(name, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name, boolean topLevelOnly) {
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        Object symbols = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalSymbols();
        if (topLevelOnly) {
            return symbols.processTopLevel(processor2, name);
        }
        return symbols.processAllSymbols(processor2, name);
    }

    @NotNull
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> Set<String> getAllSymbolNames(@NotNull Class<Impl> clazz, @NotNull Project project) {
        return ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalShortNames().keySet();
    }

    public static interface Symbols<T> {
        public boolean processAliasNamesForType(@NotNull String var1, @NotNull Processor<? super String> var2);

        public boolean processTopLevel(@NotNull Processor<? super T> var1, @Nullable String var2);

        public boolean processAllSymbols(@NotNull Processor<? super T> var1, @Nullable String var2);
    }
}

