/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCPropertySymbol
extends OCMemberSymbol,
OCSymbolWithSubstitution {
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_WITH_VALUE = EnumSet.of(PropertyAttribute.GETTER, PropertyAttribute.SETTER);
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_FOR_OBJECT = EnumSet.of(FlagAttribute.RETAIN, PropertyAttribute.STRONG, PropertyAttribute.COPY);
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_AFTER_LLVM_30 = EnumSet.of(FlagAttribute.STRONG, PropertyAttribute.WEAK, PropertyAttribute.UNSAFE_UNRETAINED);

    public boolean hasAttribute(@NotNull PropertyAttribute var1);

    @Nullable
    public String getAttributeValue(@NotNull ValueAttribute var1);

    @NotNull
    default public FlagAttribute getAttributeOfGroup(@NotNull FlagAttribute defaultAttribute, @NotNull OCType type, @NotNull PsiElement context) {
        return OCPropertySymbolImpl.getAttributeOfGroup(this, defaultAttribute, type, context);
    }

    public boolean isOptional();

    @Override
    default public boolean isStatic() {
        return this.hasAttribute(PropertyAttribute.CLASS);
    }

    default public boolean isReadonly() {
        return this.hasAttribute(PropertyAttribute.READONLY);
    }

    default public boolean isRetained() {
        return this.hasAttribute(PropertyAttribute.RETAIN) || this.hasAttribute(PropertyAttribute.COPY);
    }

    @NotNull
    default public String getGetterName() {
        String getter = this.getAttributeValue(PropertyAttribute.GETTER);
        return getter != null ? getter : this.getName();
    }

    @NotNull
    default public String getSetterName() {
        String setter = this.getAttributeValue(PropertyAttribute.SETTER);
        return setter != null ? setter + ":" : OCNameSuggester.getObjCSetterFromGetter(this.getName());
    }

    default public boolean processAccessorMethods(@NotNull Processor<? super OCMethodSymbol> processor2, boolean searchSubclasses, @NotNull Project project) {
        return OCPropertySymbolImpl.processAccessorMethods(this, processor2, searchSubclasses, project);
    }

    default public boolean processSynthesizes(@NotNull Processor<? super OCSynthesizeSymbol> processor2, @NotNull Project project) {
        return OCPropertySymbolImpl.processSynthesizes(this, processor2, project);
    }

    @Nullable
    default public OCInstanceVariableSymbol getAssociatedIvar(@NotNull Project project) {
        return OCPropertySymbolImpl.getAssociatedIvar(this, project);
    }

    default public boolean hasAllAccessorsImplemented(boolean treatSynthesizeAsAccessors, @NotNull Project project) {
        return OCPropertySymbolImpl.hasAllAccessorsImplemented(this, treatSynthesizeAsAccessors, project);
    }

    @Nullable
    default public OCPropertySymbol getAssociatedPropertyInPrivateCategory(@NotNull Project project) {
        return OCPropertySymbolImpl.getAssociatedPropertyInPrivateCategory(this, project);
    }

    public static final class FlagAttribute
    extends Enum<FlagAttribute>
    implements PropertyAttribute {
        public static final /* enum */ FlagAttribute NONATOMIC = new FlagAttribute(PropertyAttribute.Group.ATOMICITY);
        public static final /* enum */ FlagAttribute ATOMIC = new FlagAttribute(PropertyAttribute.Group.ATOMICITY);
        public static final /* enum */ FlagAttribute READONLY = new FlagAttribute(PropertyAttribute.Group.WRITEABILITY);
        public static final /* enum */ FlagAttribute READWRITE = new FlagAttribute(PropertyAttribute.Group.WRITEABILITY);
        public static final /* enum */ FlagAttribute ASSIGN = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute COPY = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute RETAIN = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute WEAK = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute STRONG = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute UNSAFE_UNRETAINED = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute NONNULL = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULLABLE = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULL_RESETTABLE = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULL_UNSPECIFIED = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute CLASS = new FlagAttribute(PropertyAttribute.Group.STATICNESS);
        private final PropertyAttribute.Group myGroup;
        private static final /* synthetic */ FlagAttribute[] $VALUES;

        public static FlagAttribute[] values() {
            return (FlagAttribute[])$VALUES.clone();
        }

        public static FlagAttribute valueOf(String name) {
            return Enum.valueOf(FlagAttribute.class, name);
        }

        private FlagAttribute(PropertyAttribute.Group group) {
            this.myGroup = group;
        }

        @Override
        @NotNull
        public PropertyAttribute.Group getGroup() {
            return this.myGroup;
        }

        @Override
        @NotNull
        public String getTokenName() {
            return StringUtil.toLowerCase((String)this.name());
        }

        @NotNull
        public ARCAttribute getIvarCompatibleARCAttribute() {
            return switch (this) {
                case ASSIGN, UNSAFE_UNRETAINED -> ARCAttribute.UNSAFE_UNRETAINED;
                case WEAK -> ARCAttribute.WEAK;
                case STRONG, COPY, RETAIN -> ARCAttribute.STRONG;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
        }

        public int getSemanticsGroup() {
            return switch (this) {
                case STRONG, RETAIN -> 0;
                case COPY -> 1;
                default -> 2;
            };
        }

        @Nullable
        public PropertySemantics getSemanticsAttribute() {
            return switch (this) {
                case ASSIGN, UNSAFE_UNRETAINED -> PropertySemantics.ASSIGN;
                case COPY -> PropertySemantics.COPY;
                case RETAIN -> PropertySemantics.RETAIN;
                case WEAK -> PropertySemantics.WEAK;
                case STRONG -> PropertySemantics.STRONG;
                default -> null;
            };
        }

        private static /* synthetic */ FlagAttribute[] $values() {
            return new FlagAttribute[]{NONATOMIC, ATOMIC, READONLY, READWRITE, ASSIGN, COPY, RETAIN, WEAK, STRONG, UNSAFE_UNRETAINED, NONNULL, NULLABLE, NULL_RESETTABLE, NULL_UNSPECIFIED, CLASS};
        }

        static {
            $VALUES = FlagAttribute.$values();
        }
    }

    public static interface PropertyAttribute {
        public static final FlagAttribute NONATOMIC = FlagAttribute.NONATOMIC;
        public static final FlagAttribute ATOMIC = FlagAttribute.ATOMIC;
        public static final FlagAttribute READONLY = FlagAttribute.READONLY;
        public static final FlagAttribute READWRITE = FlagAttribute.READWRITE;
        public static final FlagAttribute ASSIGN = FlagAttribute.ASSIGN;
        public static final FlagAttribute COPY = FlagAttribute.COPY;
        public static final FlagAttribute RETAIN = FlagAttribute.RETAIN;
        public static final FlagAttribute WEAK = FlagAttribute.WEAK;
        public static final FlagAttribute STRONG = FlagAttribute.STRONG;
        public static final FlagAttribute UNSAFE_UNRETAINED = FlagAttribute.UNSAFE_UNRETAINED;
        public static final FlagAttribute NONNULL = FlagAttribute.NONNULL;
        public static final FlagAttribute NULLABLE = FlagAttribute.NULLABLE;
        public static final FlagAttribute NULL_RESETTABLE = FlagAttribute.NULL_RESETTABLE;
        public static final FlagAttribute NULL_UNSPECIFIED = FlagAttribute.NULL_UNSPECIFIED;
        public static final FlagAttribute CLASS = FlagAttribute.CLASS;
        public static final ValueAttribute GETTER = ValueAttribute.GETTER;
        public static final ValueAttribute SETTER = ValueAttribute.SETTER;

        @NotNull
        public Group getGroup();

        @NotNull
        public String getTokenName();

        public static enum Group {
            ATOMICITY,
            WRITEABILITY,
            ARC,
            GETTER,
            SETTER,
            NULLABILITY,
            STATICNESS;

        }
    }

    public static enum ValueAttribute implements PropertyAttribute
    {
        GETTER(PropertyAttribute.Group.GETTER),
        SETTER(PropertyAttribute.Group.SETTER);

        private final PropertyAttribute.Group myGroup;

        private ValueAttribute(PropertyAttribute.Group group) {
            this.myGroup = group;
        }

        @Override
        @NotNull
        public PropertyAttribute.Group getGroup() {
            return this.myGroup;
        }

        @Override
        @NotNull
        public String getTokenName() {
            return StringUtil.toLowerCase((String)this.name());
        }
    }

    public static enum PropertySemantics {
        DEFAULT,
        STRONG,
        WEAK,
        ASSIGN,
        RETAIN,
        COPY;


        @Nullable
        public PropertyAttribute getPropertyAttribute() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> null;
                case STRONG -> PropertyAttribute.STRONG;
                case WEAK -> PropertyAttribute.WEAK;
                case ASSIGN -> PropertyAttribute.ASSIGN;
                case RETAIN -> PropertyAttribute.RETAIN;
                case COPY -> PropertyAttribute.COPY;
            };
        }
    }
}

