/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSymbolImpl
extends OCMemberSymbolImpl
implements OCMethodSymbol {
    private boolean myStatic;
    private boolean myOptional;
    private boolean myVararg;
    private OCType myReturnType;
    private OCSymbol myOriginalSymbol;
    private List<OCMethodSymbol.SelectorPartSymbol> mySelectors;
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCMethodSymbolImpl() {
    }

    protected OCMethodSymbolImpl(@NotNull OCMethodSymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        this(origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.myParent, origin.myStatic, origin.myOptional, origin.myVararg, origin.myReturnType, new ArrayList<OCMethodSymbol.SelectorPartSymbol>(origin.mySelectors), origin.myOriginalSymbol);
        this.mySubstitution = substitution;
    }

    @Override
    @NotNull
    public OCMethodSymbolImpl cloneWithSubstitution(@NotNull OCTypeSubstitution substitution) {
        return new OCMethodSymbolImpl(this, substitution);
    }

    public OCMethodSymbolImpl(VirtualFile file, long offset, @Nullable String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, boolean isStatic, boolean isOptional, boolean isVararg, @NotNull OCType returnType, @NotNull List<OCMethodSymbol.SelectorPartSymbol> selectors, @Nullable OCSymbol originalSymbol) {
        super(file, offset, name, attributes, parent);
        this.myStatic = isStatic;
        this.myOriginalSymbol = originalSymbol;
        this.myReturnType = returnType;
        this.myOptional = isOptional;
        this.myVararg = isVararg;
        this.mySelectors = ContainerUtil.trimToSize(selectors);
        for (OCMethodSymbol.SelectorPartSymbol selector : selectors) {
            OCDeclaratorSymbol parameter = selector.getParameterWithoutSubstitution();
            if (!(parameter instanceof OCDeclaratorSymbolImpl)) continue;
            ((OCDeclaratorSymbolImpl)parameter).setParentMethod(this);
        }
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMethodSymbolImpl f = (OCMethodSymbolImpl)first;
        OCMethodSymbolImpl s = (OCMethodSymbolImpl)second;
        if (f.myOptional != s.myOptional) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        if (f.myVararg != s.myVararg) {
            return false;
        }
        if (!c.equalObjects(f.myOriginalSymbol, s.myOriginalSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.myReturnType, s.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalLists(f.mySelectors, s.mySelectors);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myReturnType.compact();
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.compact();
        }
    }

    @Override
    @NotNull
    public Class<? extends PsiElement> getPsiElementClass() {
        return this.getOriginalSymbol() == null ? OCMethod.class : OCDeclarator.class;
    }

    @Override
    @NotNull
    public OCType getReturnType(@Nullable OCObjectType receiverType, @NotNull Project project) {
        return OCMethodSymbolImpl.inferReturnType(this, this.myReturnType, receiverType, project);
    }

    @NotNull
    public static OCType inferReturnType(@NotNull OCMethodSymbol self, @NotNull OCType rawReturnType, @Nullable OCObjectType receiverType, @NotNull Project project) {
        if (rawReturnType instanceof OCReferenceType && rawReturnType.getName().equals("instancetype")) {
            if (receiverType != null && receiverType.getClassSymbol() != null && receiverType.getClassSymbol().isSubclass(self.getParent(), project)) {
                return OCPointerType.to(receiverType).cloneWithNullability(rawReturnType.getNullability());
            }
            OCPointerType type = OCPointerType.to(self.getParent().getType());
            OCType clone = type.cloneWithAliasName("instancetype");
            clone.attachNullability(rawReturnType.getNullability());
            return clone;
        }
        return self.getSubstitution().substitute(rawReturnType);
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isVararg() {
        return this.myVararg;
    }

    public static boolean isFactoryMethod(@NotNull OCMethodSymbol self) {
        String className = StringUtil.trimStart((String)self.getParent().getName(), (String)"NS");
        String selector = self.getName();
        if (self.isStatic()) {
            List classWords = NameUtil.nameToWordsLowerCase((String)className);
            List selectorWords = NameUtil.nameToWordsLowerCase((String)selector);
            String word = (String)ContainerUtil.getFirstItem((List)selectorWords);
            if ("default".equalsIgnoreCase(word) || "common".equalsIgnoreCase(word) || "shared".equalsIgnoreCase(word) || "main".equalsIgnoreCase(word)) {
                selectorWords.remove(0);
            }
            if (classWords.isEmpty() || selectorWords.isEmpty()) {
                return false;
            }
            block0: for (int wordCount = 1; wordCount <= Math.min(classWords.size(), selectorWords.size()); ++wordCount) {
                for (int i = 0; i < wordCount; ++i) {
                    String classWord = (String)classWords.get(classWords.size() - wordCount + i);
                    String selectorWord = (String)selectorWords.get(i);
                    if (!selectorWord.equals(classWord)) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPredeclaration() {
        return !(this.getParent() instanceof OCImplementationSymbol);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.doComputeIcon();
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result = this.doComputeIconFullAndNow(project);
        if (result == null) {
            return null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    private Icon doComputeIcon() {
        OCPropertySymbol property = this.getGeneratedFromProperty();
        return property != null ? property.getBaseIcon() : OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    private Icon doComputeIconFullAndNow(@NotNull Project project) {
        OCPropertySymbol associatedProperty;
        OCMethodSymbol associatedMethod;
        OCPropertySymbol property = this.getGeneratedFromProperty();
        if (property != null) {
            return property.computeFullIconNow(null, project);
        }
        if (this.myParent instanceof OCImplementationSymbol && (associatedMethod = this.getAssociatedSymbol((PsiElement)this.myParent.getContainingPsiFile(project), project)) != null && (associatedProperty = associatedMethod.getGeneratedFromProperty()) != null) {
            return associatedProperty.computeFullIconNow(null, project);
        }
        return OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.METHOD;
    }

    @Override
    public OCSymbol getOriginalSymbol() {
        return this.myOriginalSymbol;
    }

    @Override
    public boolean isSynthetic() {
        return this.getOriginalSymbol() != null;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return super.isForbiddenByARC(context) || "dealloc".equals(this.myName) && OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile());
    }

    public static boolean isAccessorWithAliasedName(@NotNull OCMethodSymbol self, @NotNull Project project) {
        OCPropertySymbol property = self.getGeneratedFromProperty();
        if (property == null) {
            return false;
        }
        OCResolveContext context = OCResolveContext.forSymbol(self, project);
        if (self.isGetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER) != null;
        }
        if (self.isSetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) != null;
        }
        return false;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    @NotNull
    public List<OCMethodSymbol.SelectorPartSymbol> getSelectors() {
        return this.mySubstitution == OCTypeSubstitution.ID ? this.mySelectors : ContainerUtil.map(this.mySelectors, symbol -> symbol.cloneWithSubstitution(this.mySubstitution));
    }

    @Override
    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return ContainerUtil.map(this.mySelectors, symbol -> this.mySubstitution.substitute(symbol.getParameter()));
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        return (this.myStatic ? "+" : "-") + "[" + this.myParent.getName() + " " + this.getName() + "]";
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@NotNull Project project) {
        return this.getAssociatedSymbol(null, project);
    }

    @Nullable
    public static OCMethodSymbol getAssociatedSymbol(final @NotNull OCMethodSymbol self, @Nullable PsiElement context, @NotNull Project project) {
        OCClassSymbol parentAssociate = (OCClassSymbol)self.getParent().getAssociatedSymbol(project);
        if (parentAssociate == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == self.isStatic();
            }
        };
        parentAssociate.processCategories((Processor<? super OCClassSymbol>)((Processor)arg_0 -> OCMethodSymbolImpl.lambda$getAssociatedSymbol$2(self, (CommonProcessors.FindFirstProcessor)processor2, arg_0)), true, context, project);
        return (OCMethodSymbol)processor2.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), methodSymbol -> methodSymbol.isStatic() != this.isStatic() || processor2.process((Object)this.mySubstitution.substitute(methodSymbol)), false, project);
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        return this.getReturnType(context.getProject()).resolve(context);
    }

    @Override
    @NotNull
    public OCType getEffectiveType(@NotNull Project project) {
        return this.getReturnType(project);
    }

    private static /* synthetic */ boolean lambda$getAssociatedSymbol$2(OCMethodSymbol self, CommonProcessors.FindFirstProcessor processor2, OCClassSymbol symbol) {
        return self.getSubstitution().substitute(symbol).processMembers(self.getName(), OCMethodSymbol.class, processor2);
    }
}

