/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassSymbolImpl
extends OCSymbolWithQualifiedNameImpl
implements OCClassSymbol {
    @Nullable
    private String myCategoryName;
    @Nullable
    private MostlySingularMultiMap<String, OCMemberSymbol> myMembers;
    @NotNull
    private List<String> myProtocolNames;
    @Nullable
    private OCReferenceType mySuperType;

    public OCClassSymbolImpl(@Nullable VirtualFile file, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String categoryName, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType superType) {
        super(file, offset, null, OCQualifiedName.interned(name), attributes, null);
        this.myCategoryName = OCNamesInterner.intern((String)categoryName);
        this.myMembers = members;
        this.myProtocolNames = protocolNames;
        this.mySuperType = superType;
    }

    public OCClassSymbolImpl() {
    }

    @Override
    @Nullable
    public String getCategoryName() {
        return this.myCategoryName;
    }

    public void setSuperType(@NotNull OCReferenceType type) {
        assert (this.mySuperType == null) : "Super type is already set";
        this.mySuperType = type;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        assert (this.mySuperType != null) : "Super type has to be set in symbol builder";
        return this.mySuperType;
    }

    @Override
    @NotNull
    public OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy getDefaultArgumentsRemovalStrategy() {
        return OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.ALL_MATCH;
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        OCSymbolOffsetUtil.updateOffset(this.myMembers, start, lengthShift);
    }

    @Override
    public void compact() {
        super.compact();
        OCNamespaceSymbol.compactMembersMultiMap(this.myMembers);
    }

    @Override
    @NotNull
    public List<String> getProtocolNames() {
        return this.myProtocolNames;
    }

    @Override
    public boolean isPredeclaration() {
        return this.myMembers == null;
    }

    @Override
    public int getMembersCount() {
        return this.myMembers != null ? this.myMembers.size() : 0;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result = super.hashCodeExcludingOffset();
        result = 31 * result + this.getMembersCount();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getMembersCount() == ((OCClassSymbol)o).getMembersCount();
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCClassSymbolImpl f = (OCClassSymbolImpl)first;
        OCClassSymbolImpl s = (OCClassSymbolImpl)second;
        if (!Objects.equals(f.myCategoryName, s.myCategoryName)) {
            return false;
        }
        if (!Comparing.equal(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.mySuperType, s.mySuperType)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable @NonNls String memberName, @Nullable Class<? extends T> memberClass, @NotNull Processor<? super T> processor2) {
        Processor myProcessor;
        if (this.myMembers == null) {
            return true;
        }
        Processor processor3 = myProcessor = memberClass != null ? member -> !memberClass.isAssignableFrom(member.getClass()) || processor2.process(member) : processor2;
        if (memberName == null) {
            return this.myMembers.processAllValues(myProcessor);
        }
        return this.myMembers.processForKey((Object)memberName, myProcessor);
    }

    public static boolean processAllMethods(@NotNull OCClassSymbol self, @Nullable String methodName, @NotNull Processor<OCMethodSymbol> processor2, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        boolean isAmongBaseProtocols;
        boolean bl = isAmongBaseProtocols = self instanceof OCProtocolSymbol && baseProtocols != null && baseProtocols.contains(self.getName());
        if (!self.processMembers(methodName, OCMethodSymbol.class, symbol -> isAmongBaseProtocols && !symbol.isOptional() || processor2.process(symbol))) {
            return false;
        }
        if (isAmongBaseProtocols) {
            baseProtocols.addAll(self.getProtocolNames());
        }
        for (String protocolName : self.getProtocolNames()) {
            CommonProcessors.FindFirstProcessor<OCSymbol> resolver = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCProtocolSymbol && !symbol.isPredeclaration();
                }
            };
            OCResolveUtil.processGlobalSymbols(protocolName, context, (Processor<OCSymbol>)resolver);
            if (!resolver.isFound() || ((OCProtocolSymbol)resolver.getFoundValue()).processAllMethods(methodName, processor2, baseProtocols, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean processCategories(@NotNull OCClassSymbol self, @NotNull Processor<? super OCClassSymbol> processor2, boolean fromSameParentClass, @Nullable PsiElement context, @NotNull Project project) {
        if (!processor2.process((Object)self)) {
            return false;
        }
        Processor filterProcessor = symbol -> {
            if (!(!(symbol instanceof OCClassSymbol) || fromSameParentClass && !symbol.getClass().equals(self.getClass()) || symbol.isPredeclaration() || symbol.equals(self))) {
                return processor2.process((Object)((OCClassSymbol)symbol));
            }
            return true;
        };
        if (context == null) {
            return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)filterProcessor, self.getName());
        }
        return OCResolveUtil.processGlobalSymbols(self.getName(), null, context.getContainingFile(), self.getOffset(), (Processor<OCSymbol>)filterProcessor);
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> !this.isSameSymbol((OCSymbol)symbol, project) || processor2.process(symbol)), this.getName());
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol(@NotNull Project project) {
        return (OCClassSymbol)super.getDefinitionSymbol(project);
    }

    @Nullable
    protected MostlySingularMultiMap<String, OCMemberSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    public static <T extends OCClassSymbol> T getMainSymbol(@NotNull OCClassSymbol self, @Nullable T symbol, @NotNull Project project) {
        if (symbol == null) {
            return null;
        }
        if (self.getCategoryName() == null) {
            return symbol;
        }
        CommonProcessors.FindFirstProcessor<OCClassSymbol> finder = new CommonProcessors.FindFirstProcessor<OCClassSymbol>(){

            protected boolean accept(OCClassSymbol each) {
                return each.getCategoryName() == null;
            }
        };
        symbol.processCategories((Processor<OCClassSymbol>)finder, true, null, project);
        return (T)((OCClassSymbol)finder.getFoundValue());
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myCategoryName == null ? super.getBaseIcon() : CidrLangIcons.CodeAssistantClassExtension;
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        Icon icon = result = this.myCategoryName == null ? super.computeFullIconNow(symbolElement, project) : CidrLangIcons.CodeAssistantClassExtension;
        if (result == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        OCType type = super.getResolvedType(context, ignoringImports);
        return type instanceof OCObjectType ? (OCObjectType)type : null;
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol, @NotNull Project project) {
        return symbol instanceof OCClassSymbol && this.isSameClass((OCClassSymbol)symbol);
    }

    public static boolean isSameCategory(@NotNull OCClassSymbol self, @Nullable OCSymbol symbol) {
        if (symbol instanceof OCClassSymbol && self.getName().equals(symbol.getName())) {
            String myCategory = StringUtil.notNullize((String)self.getCategoryName());
            String hisCategory = ((OCClassSymbol)symbol).getCategoryName() == null ? "" : ((OCClassSymbol)symbol).getCategoryName();
            return myCategory.equals(hisCategory);
        }
        return false;
    }

    public static boolean isSubclass(@NotNull OCClassSymbol symbol, final @NotNull OCClassSymbol ancestor, final @NotNull Project project) {
        final String ancestorName = ancestor.getName();
        if (symbol.isSameClass(ancestor) || ancestorName.equals("id")) {
            return true;
        }
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance(project);
        boolean ancestorIsInLibraries = scopeService.isInLibraries(ancestor);
        if (!ancestorIsInLibraries && ancestor.getCategoryName() != null) {
            OCInterfaceSymbol mainInterface = ancestor.getMainInterface(project);
            ancestorIsInLibraries = scopeService.isInLibraries(mainInterface);
        }
        class DFS {
            final Set<OCClassSymbol> processedClasses = new HashSet<OCClassSymbol>();
            final Stack<OCClassSymbol> stack = new Stack();
            boolean wasProcessed;

            DFS() {
            }

            <T extends OCClassSymbol> boolean traverse(String name, Class<T> clazz) {
                if (name.equals(ancestorName) && clazz == OCProtocolSymbol.class == ancestor instanceof OCProtocolSymbol) {
                    return true;
                }
                this.wasProcessed = false;
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, new OCCommonProcessors.TypeFilteredProcessor(t -> {
                    if (!t.isPredeclaration()) {
                        this.wasProcessed = true;
                        if (!this.processedClasses.contains(t)) {
                            this.processedClasses.add((OCClassSymbol)t);
                            this.stack.push(t);
                        }
                    }
                    return true;
                }, clazz), name);
                return false;
            }
        }
        DFS dfs = new DFS();
        if (symbol instanceof OCProtocolSymbol) {
            if (dfs.traverse(symbol.getName(), OCProtocolSymbol.class)) {
                return true;
            }
        } else {
            if (dfs.traverse(symbol.getName(), OCInterfaceSymbol.class)) {
                return true;
            }
            if (!dfs.wasProcessed && dfs.traverse(symbol.getName(), OCImplementationSymbol.class)) {
                return true;
            }
        }
        while (!dfs.stack.isEmpty()) {
            OCClassSymbol curClass = (OCClassSymbol)dfs.stack.pop();
            if (!ancestorIsInLibraries && scopeService.isInLibraries(curClass)) continue;
            if (curClass instanceof OCInterfaceSymbol || curClass instanceof OCImplementationSymbol) {
                if (dfs.traverse(curClass.getSuperClassName(), OCInterfaceSymbol.class)) {
                    return true;
                }
                if (!dfs.wasProcessed && dfs.traverse(curClass.getSuperClassName(), OCImplementationSymbol.class)) {
                    return true;
                }
            }
            for (String protocolName : curClass.getProtocolNames()) {
                if (!dfs.traverse(protocolName, OCProtocolSymbol.class)) continue;
                return true;
            }
        }
        return false;
    }
}

