/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnaryExpressionSymbolBase
extends OCExpressionSymbol {
    protected OCElementType myOperator;
    protected OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbolBase() {
    }

    public OCUnaryExpressionSymbolBase(@Nullable VirtualFile file, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol operand) {
        super(file, offset);
        this.myOperator = operator;
        this.myOperand = operand;
    }

    @NotNull
    public abstract OCOperatorReference.OperatorPlacement getOperatorPlacement();

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbolBase firstSymbol = (OCUnaryExpressionSymbolBase)first;
        OCUnaryExpressionSymbolBase secondSymbol = (OCUnaryExpressionSymbolBase)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    protected abstract OCType getResolvedType(OCType var1, @NotNull OCResolveContext var2);

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType opType = this.myOperand.getResolvedType(context);
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if ((symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context)) != null) {
            return symbol.getType().getReturnType().resolve(context);
        }
        return this.getResolvedType(opType, context);
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType opType = this.myOperand.getResolvedType(context);
        OCType customReturnType = null;
        if (opType != null && (symbol = this.tryResolveOperator(context, opType)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        return new Info(opType, customReturnType);
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context) {
        OCType opType = this.myOperand.getResolvedType(context);
        return this.tryResolveOperator(context, opType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context, @Nullable OCType opType) {
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if (opType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context);
        }
        return null;
    }

    public OCElementType getOperator() {
        return this.myOperator;
    }

    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myOperator.getName() + this.myOperand.getPresentableName();
    }

    private static final class Info {
        @Nullable
        public final OCType opType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType opType, @Nullable OCType customReturnType) {
            this.opType = opType;
            this.customReturnType = customReturnType;
        }
    }
}

