/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionSymbol
extends OCExpressionSymbol {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private OCFunctionSymbol myFunctionSymbol;
    private List<OCDeclaratorSymbol> myParameters;
    private List<OCDeclaratorSymbol> myLocalVarsAndParams;
    private List<OCExpressionSymbol> myReturnExpressions;
    private Map<OCType, OCType> myAutoParamsMapping;
    public static final Comparator<OCDeclaratorSymbol> variablesComparator = Comparator.comparing(OCSymbol::getName).thenComparingLong(OCSymbol::getComplexOffset);

    public OCLambdaExpressionSymbol() {
    }

    public OCLambdaExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull List<OCExpressionSymbol> returnExpressions, @NotNull List<OCDeclaratorSymbol> parameters, @NotNull List<OCDeclaratorSymbol> localVarsAndParams, @Nullable List<OCType> parameterTypes, @Nullable OCType returnType) {
        super(file, offset);
        this.myReturnExpressions = returnExpressions;
        this.myParameters = parameters;
        this.myLocalVarsAndParams = localVarsAndParams;
        this.myParameterTypes = parameterTypes;
        this.myReturnType = returnType;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLambdaExpressionSymbol firstSymbol = (OCLambdaExpressionSymbol)first;
        OCLambdaExpressionSymbol secondSymbol = (OCLambdaExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myParameterTypes, secondSymbol.myParameterTypes)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myParameters, secondSymbol.myParameters)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLocalVarsAndParams, secondSymbol.myLocalVarsAndParams)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnType, secondSymbol.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnExpressions, secondSymbol.myReturnExpressions)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myFunctionSymbol, secondSymbol.myFunctionSymbol);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.LAMBDA;
    }

    public List<OCDeclaratorSymbol> getParameters() {
        return this.myParameters;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getLocalVarsAndParams() {
        return this.myLocalVarsAndParams;
    }

    public void setFunctionSymbol(@NotNull OCFunctionSymbol functionSymbol) {
        this.myFunctionSymbol = functionSymbol;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (this.myParameterTypes != null && this.myParameterTypes.stream().anyMatch(OCTypeUtils::hasAutoInside) && !this.myReturnExpressions.isEmpty()) {
            Map<OCType, OCType> map = OCTypeUtils.newTypesMap();
            List<OCType> newParameterTypes = this.myParameterTypes.stream().map(t -> OCTypeUtils.replaceAutoTypesWithTypeParameters(t, map, context.getProject())).collect(Collectors.toList());
            OCLambdaExpressionSymbol newSymbol = new OCLambdaExpressionSymbol(this.myFile, this.myComplexOffset, this.myReturnExpressions, this.myParameters, this.myLocalVarsAndParams, newParameterTypes, this.myReturnType);
            newSymbol.myAutoParamsMapping = map;
            OCAutoType result = new OCAutoType(newSymbol, null, null, false, false);
            result.setNeedsAutoParamsResolving(true);
            return result;
        }
        OCType returnType = this.myReturnType;
        if (returnType == null) {
            for (OCExpressionSymbol expression : this.myReturnExpressions) {
                if (this.myFunctionSymbol != null) {
                    context.pushOuterFunction(this.myFunctionSymbol);
                }
                OCType type = expression.getResolvedType(context);
                type = OCTypeUtils.decayType(type, context.getProject());
                if (this.myFunctionSymbol != null) {
                    context.popOuterFunction();
                }
                if (returnType == null) {
                    returnType = type;
                    continue;
                }
                if (type != null && type.isUnknown() || returnType.equals(type, context)) continue;
                return OCUnknownType.INSTANCE;
            }
            if (returnType == null) {
                returnType = OCVoidType.instance();
            }
        }
        return this.myFunctionSymbol != null ? returnType : context.getSubstitution().substitute(OCPointerType.to(new OCFunctionType(returnType, this.getResolvedParameterTypes(context))), context);
    }

    private List<OCType> getResolvedParameterTypes(@NotNull OCResolveContext context) {
        return this.myParameterTypes.stream().map(p -> p.resolve(context)).collect(Collectors.toList());
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments) {
        return this.getResolvedType(context, arguments, false);
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments, boolean failIfNotUnified) {
        if (this.myParameterTypes.size() != arguments.getCount()) {
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        for (int i = 0; i < this.myParameterTypes.size(); ++i) {
            OCTypeOwner expression;
            OCType type = arguments.getTypes().get(i);
            OCTypeOwner oCTypeOwner = expression = arguments.getExprs() != null ? arguments.getExprs().get(i) : null;
            if (OCSimpleTypeSubstitution.unify(this.myParameterTypes.get(i), type, expression, map, null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) continue;
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        context = context.substitute(OCSimpleTypeSubstitution.create(map), false, true);
        context.setAutoParamsTypeMapping(this.myAutoParamsMapping);
        return this.getResolvedType(context);
    }

    @NotNull
    public List<OCExpressionSymbol> getReturnExpressions() {
        return this.myReturnExpressions;
    }

    public OCFunctionSymbol getFunctionSymbol() {
        return this.myFunctionSymbol;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context) {
        return OCTypeUtils.getNonInitializedParametersCount(this.myParameters, context);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myFunctionSymbol != null ? this.myFunctionSymbol.getPresentableName() : "<lambda>";
    }
}

