/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCalleeSymbol;
    private List<OCExpressionSymbol> myArguments;

    public OCCallExpressionSymbol() {
    }

    public OCCallExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCExpressionSymbol calleeSymbol, @NotNull List<OCExpressionSymbol> arguments) {
        super(file, offset);
        this.myCalleeSymbol = calleeSymbol;
        this.myArguments = arguments;
    }

    @Override
    public void compact() {
        super.compact();
        this.myArguments = ContainerUtil.trimToSize(this.myArguments);
    }

    public OCExpressionSymbol getCalleeSymbol() {
        return this.myCalleeSymbol;
    }

    @Override
    @NotNull
    public List<OCExpressionSymbol> getArguments() {
        return this.myArguments;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCallExpressionSymbol firstSymbol = (OCCallExpressionSymbol)first;
        OCCallExpressionSymbol secondSymbol = (OCCallExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCalleeSymbol, secondSymbol.myCalleeSymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalCall(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> arguments;
        OCType callerType;
        OCSymbol callerSymbol = null;
        if (this.myCalleeSymbol == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.myCalleeSymbol instanceof OCReferenceExpressionSymbol) {
            OCReferenceType type;
            OCType resolved;
            callerSymbol = ((OCReferenceExpressionSymbol)this.myCalleeSymbol).resolveToSymbol(context);
            OCResolveContext newContext = callerSymbol != null ? context.useFor(callerSymbol) : null;
            OCType oCType = callerType = callerSymbol != null ? OCTypeUtils.getSymbolType(callerSymbol, context).resolve(newContext) : null;
            if (callerType instanceof OCCppReferenceType) {
                callerType = ((OCCppReferenceType)callerType).getRefType();
            }
            if (OCTypeUtils.isUnresolvedLambdaAutoType(callerType) && (arguments = this.getArgumentList(context)) != null) {
                callerType = OCTypeUtils.resolveLambdaAutoType(callerType, context, arguments, false);
            }
            if (callerType instanceof OCPointerType) {
                callerType = ((OCPointerType)callerType).getRefType();
            }
            if (callerType instanceof OCFunctionType) {
                return OCCallExpressionImpl.getCallExprType(callerType, callerSymbol, context);
            }
            if (callerSymbol == null && !(resolved = (type = ((OCReferenceExpressionSymbol)this.myCalleeSymbol).asTypeReference()).resolve(context)).isUnknown()) {
                return resolved;
            }
        }
        OCSymbol calleeResolvedSymbol = null;
        if (this.myCalleeSymbol instanceof OCQualifiedExpressionSymbol) {
            Pair<OCSymbol, OCType> pair = ((OCQualifiedExpressionSymbol)this.myCalleeSymbol).getResolvedSymbolAndType(context);
            calleeResolvedSymbol = (OCSymbol)pair.first;
            callerType = (OCType)pair.second;
        } else {
            callerType = this.myCalleeSymbol.getResolvedType(context);
        }
        callerType = callerType.getTerminalType();
        if (callerType instanceof OCFunctionType) {
            OCSymbol dummyFunction;
            OCSymbol oCSymbol = dummyFunction = calleeResolvedSymbol instanceof OCFunctionSymbol ? calleeResolvedSymbol : new OCFunctionSymbol(null, 0L, null, OCQualifiedName.with(null), Collections.emptyList(), null, 0, 0, Collections.emptyList(), (OCFunctionType)callerType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, null);
            if (this.resolveOverloads(Collections.singletonList(dummyFunction), context) == null) {
                return OCUnknownType.INSTANCE;
            }
        } else if (callerType instanceof OCStructType) {
            arguments = this.getArgumentList(context);
            if (arguments == null) {
                return OCUnknownType.INSTANCE;
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCExpressionSymbol> expressions = null;
            types.add(callerType);
            types.addAll(arguments.getTypes());
            if (arguments.getExprs() != null) {
                expressions = new ArrayList<OCExpressionSymbol>();
                expressions.add(null);
                expressions.addAll(arguments.getExprs());
            }
            OCResolveContext newContext = (callerSymbol = OCOperatorReference.resolveOperator("()", OCOperatorReference.OperatorPlacement.POSTFIX, types, expressions, context)) != null ? context.useFor(callerSymbol) : null;
            callerType = callerSymbol != null ? OCTypeUtils.getSymbolType(callerSymbol, context).resolve(newContext) : null;
        }
        return callerType != null ? OCCallExpressionImpl.getCallExprType(callerType, callerSymbol, context) : OCUnknownType.INSTANCE;
    }

    @Nullable
    public OCArgumentsList<OCExpressionSymbol> getArgumentList(@NotNull OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(this.myArguments, context);
        for (OCType type : arguments.getTypes()) {
            if (!(type instanceof OCTypeParameterType)) continue;
            context.addTypeDependency(((OCTypeParameterType)type).getSymbol());
        }
        for (OCType type : arguments.getTypes()) {
            if (type != null) continue;
            return null;
        }
        return arguments;
    }

    @Nullable
    public OCSymbol resolveOverloads(Collection<OCSymbol> symbols, OCResolveContext context) {
        OCFunctionSymbol outerFunction;
        OCArgumentsList<OCExpressionSymbol> argumentList = this.getArgumentList(context);
        OCType leftType = null;
        OCExprValueCategory leftValueCategory = null;
        if (this.myCalleeSymbol instanceof OCQualifiedExpressionSymbol) {
            OCExpressionSymbol qualifier = ((OCQualifiedExpressionSymbol)this.myCalleeSymbol).getQualifier();
            OCSymbol qualifierSymbol = qualifier instanceof OCReferenceExpressionSymbol ? ((OCReferenceExpressionSymbol)qualifier).resolveToSymbol(context) : null;
            leftType = qualifierSymbol != null ? qualifierSymbol.getType().resolve(context) : null;
            leftValueCategory = OCExprValueCategory.classify(qualifier, context);
        }
        if ((outerFunction = context.peekOuterFunction()) != null) {
            if (leftType == null) {
                OCSymbolWithQualifiedName owner = outerFunction.getResolvedOwner(context, false);
                leftType = owner != null ? owner.getType() : null;
                leftValueCategory = null;
            }
            if (leftType != null) {
                leftType = leftType.cloneWithAddedCVQualifiers(outerFunction.getType().getCVQualifiers(), context.getProject());
            }
        }
        return argumentList != null ? OCResolveOverloadsUtil.resolveOverloads(symbols, argumentList, leftType, leftValueCategory, null, true, true, context, null) : null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myCalleeSymbol.getPresentableName() + "(" + StringUtil.join(this.myArguments, OCSymbol::getPresentableName, (String)", ") + ")";
    }
}

