/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCArraySelectionExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArrayIndexExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myArraySymbol;
    private OCExpressionSymbol myIndexSymbol;

    public OCArrayIndexExpressionSymbol() {
    }

    public OCArrayIndexExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCExpressionSymbol arraySymbol, @NotNull OCExpressionSymbol indexSymbol) {
        super(file, offset);
        this.myArraySymbol = arraySymbol;
        this.myIndexSymbol = indexSymbol;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCArrayIndexExpressionSymbol firstSymbol = (OCArrayIndexExpressionSymbol)first;
        OCArrayIndexExpressionSymbol secondSymbol = (OCArrayIndexExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myArraySymbol, secondSymbol.myArraySymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myIndexSymbol, secondSymbol.myIndexSymbol);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.getResolvedTypeWithKind((OCResolveContext)context).type;
    }

    @NotNull
    public ResolveResult getResolvedTypeWithKind(@NotNull OCResolveContext context) {
        OCType arrayType = this.myArraySymbol.getResolvedType(context);
        OCType indexType = this.myIndexSymbol.getResolvedType(context);
        if (arrayType instanceof OCCppReferenceType) {
            arrayType = ((OCCppReferenceType)arrayType).getRefType();
        }
        if (arrayType instanceof OCStructType) {
            OCType operatorType;
            OCFunctionSymbol operator = OCOperatorReference.resolveOperator("[]", OCOperatorReference.OperatorPlacement.POSTFIX, Arrays.asList(arrayType, indexType), Arrays.asList(this.myArraySymbol, this.myIndexSymbol), context);
            OCResolveContext newContext = operator != null ? context.useFor(operator) : null;
            OCType oCType = operatorType = operator != null ? OCTypeUtils.getSymbolType(operator, context).resolve(newContext) : null;
            if (operatorType != null) {
                return new ResolveResult(Kind.Custom, OCCallExpressionImpl.getCallExprType(operatorType, operator, context));
            }
        }
        return new ResolveResult(Kind.Builtin, OCArraySelectionExpressionImpl.getArrayIndexExprType(arrayType, context));
    }

    public OCExpressionSymbol getIndexSymbol() {
        return this.myIndexSymbol;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myArraySymbol.getPresentableName() + "[" + this.myIndexSymbol.getPresentableName() + "]";
    }

    public static class ResolveResult {
        @NotNull
        public final Kind kind;
        @NotNull
        public final OCType type;

        public ResolveResult(@NotNull Kind kind, @NotNull OCType type) {
            this.kind = kind;
            this.type = type;
        }
    }

    public static enum Kind {
        Builtin,
        Custom;

    }
}

