/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorSymbolImpl
extends OCTemplateSymbolImpl
implements OCDeclaratorSymbol {
    private OCType myType;
    private OCSymbolKind mySymbolKind;
    private int myPropertiesAndAttributes;
    @Nullable
    private ComplexTextRange myScope;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @Nullable
    private OCMethodSymbol myParentMethod;
    protected OCInitializerSymbol myInitializer;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private OCSymbol myUsingParent;

    public OCDeclaratorSymbolImpl() {
    }

    public OCDeclaratorSymbolImpl(VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType, @Nullable OCInitializerSymbol initializer, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, int declaratorProperties, int declaratorAttributes, @Nullable ComplexTextRange scope, @Nullable OCVisibility visibility) {
        super(file, offset, parent, name, templateParameters, attributes, visibility);
        this.myType = type;
        this.myInitializer = initializer;
        this.mySymbolKind = declaratorType;
        this.myPropertiesAndAttributes = declaratorProperties | declaratorAttributes;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
    }

    public OCDeclaratorSymbolImpl(String name, @NotNull OCType type, OCSymbolKind declaratorType) {
        this(null, 0L, null, OCQualifiedName.interned(name), Collections.emptyList(), type, declaratorType, null, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
    }

    public OCDeclaratorSymbolImpl(VirtualFile file, long offset, OCSymbolWithQualifiedName parent, String name, @NotNull List<String> attributes, @NotNull OCType type, OCSymbolKind declaratorType) {
        this(file, offset, parent, OCQualifiedName.interned(name), attributes, type, declaratorType, null, Collections.emptyList(), Collections.emptyList(), 0, 0, null, null);
    }

    protected OCDeclaratorSymbolImpl(@NotNull OCDeclaratorSymbolImpl origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        super(origin.getContainingFile(), origin.getComplexOffset(), parent, origin.getQualifiedName(), origin.getTemplateParameters(), origin.getAttributes(), origin.getVisibility());
        this.myType = origin.getType();
        this.myInitializer = origin.getInitializer();
        this.mySymbolKind = origin.getKind();
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.myScope = origin.getScope();
        this.mySubstitution = substitution;
        this.myTemplateSpecialization = origin.getTemplateSpecialization();
    }

    @Override
    @NotNull
    public OCDeclaratorSymbolImpl cloneWithSubstitution(@NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        return new OCDeclaratorSymbolImpl(this, substitution, parent);
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
        if (this.myInitializer != null) {
            this.myInitializer.compact();
        }
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCDeclaratorSymbolImpl f = (OCDeclaratorSymbolImpl)first;
        OCDeclaratorSymbolImpl s = (OCDeclaratorSymbolImpl)second;
        if (f.mySymbolKind != s.mySymbolKind) {
            return false;
        }
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.myInitializer, s.myInitializer)) {
            return false;
        }
        if (!c.equalObjects(f.myParentMethod, s.myParentMethod)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.mySubstitution.substitute(this.myType);
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isTemplateSymbol() {
        return super.isTemplateSymbol() || this.myTemplateSpecialization != null;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project) {
        OCType type = this.getType().accept(new OCTypeParameterResolveVisitor(this.getContainingPsiFile(project)));
        return OCDocUtil.parameterSignature(type.getName(), this.getName());
    }

    @Override
    public boolean isSynthetic() {
        return this.hasProperty(OCDeclaratorSymbol.Property.IS_SYNTHETIC);
    }

    @Override
    @NotNull
    public Class<? extends PsiElement> getPsiElementClass() {
        return this.myParentMethod != null ? OCMethodSelectorPart.class : super.getPsiElementClass();
    }

    public void setType(@NotNull OCType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.mySymbolKind;
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst() || this.isConstexpr() || this.mySymbolKind == OCSymbolKind.ENUM_CONST;
    }

    @Override
    public boolean hasAttribute(@NotNull OCSymbolAttribute attribute2) {
        return !this.hasProperty(OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX) && (this.myPropertiesAndAttributes & attribute2.getMask()) != 0;
    }

    @Override
    public boolean hasProperty(@NotNull OCDeclaratorSymbol.Property property) {
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project) {
        OCParameterList parameterList;
        if (this.myComplexOffset != -1L || !this.hasProperty(OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX)) {
            return super.locateDefinition(project);
        }
        PsiElement parentElement = this.myParent.locateDefinition(project);
        if (parentElement instanceof OCDeclarator && (parameterList = ((OCDeclarator)parentElement).getParameterList()) != null && this.getIndexOfParameter() < parameterList.getParameters().size()) {
            return parameterList.getParameters().get(this.getIndexOfParameter());
        }
        return null;
    }

    private int getIndexOfParameter() {
        if (this.hasProperty(OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX)) {
            return this.myPropertiesAndAttributes & ~OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX.getMask();
        }
        throw new RuntimeException("Parameters must have IS_ENCODED_PARAM_INDEX property set");
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result = super.hashCodeExcludingOffset();
        if (this.myComplexOffset == -1L && this.hasProperty(OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX)) {
            result = 31 * result + this.getIndexOfParameter();
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.myComplexOffset == -1L && this.hasProperty(OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX)) {
            result = 31 * result + this.myParent.getOffset();
        }
        return result;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }

    @Override
    public boolean isDefinition() {
        return super.isDefinition() && this.myScope == null;
    }

    @Override
    public OCInitializerSymbol getInitializer() {
        return this.myInitializer;
    }

    @Override
    @Nullable
    public OCExpressionSymbol getInitializerExpression() {
        if (this.myInitializer instanceof OCExpressionSymbol) {
            return (OCExpressionSymbol)this.myInitializer;
        }
        return null;
    }

    @Nullable
    public static OCDeclaratorSymbol getDeclarationInParent(@NotNull OCDeclaratorSymbol self, @NotNull OCResolveContext context) {
        if (self.getQualifier() == null) {
            return self;
        }
        OCSymbolWithQualifiedName owner = self.getResolvedOwner(context);
        Ref result = new Ref(null);
        if (owner instanceof OCStructSymbol) {
            ((OCStructSymbol)owner).processMembers(self.getName(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCDeclaratorSymbolImpl) {
                    result.set((Object)((OCDeclaratorSymbol)symbol));
                    return false;
                }
                return true;
            }));
        }
        return (OCDeclaratorSymbol)result.get();
    }

    public static boolean resolveIsStatic(@NotNull OCDeclaratorSymbol self, @NotNull OCResolveContext context) {
        if (self.isFriendOrStatic() || self.getQualifier() == null) {
            return self.isFriendOrStatic();
        }
        OCDeclaratorSymbol predef = self.getDeclarationInParent(context);
        return predef != null && predef.isFriendOrStatic();
    }

    @Override
    public Icon getBaseIcon() {
        Icon icon = this.getKind().getIcon();
        if (this.isConst() && this.getKind() != OCSymbolKind.ENUM_CONST) {
            icon = OCIcons.getConstIconWithTooltip(icon, this.getKind());
        }
        if (this.isFriendOrStatic()) {
            icon = OCIcons.getStaticIcon(icon);
        }
        return OCIcons.getVisibilityIcon(this.getVisibility(), icon);
    }

    public void setParentMethod(@Nullable OCMethodSymbol parentMethod) {
        this.myParentMethod = parentMethod;
    }

    @Override
    public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        if (this.mySymbolKind != OCSymbolKind.PARAMETER) {
            return super.processAssociatedSymbols(processor2, project);
        }
        if (this.myParentMethod != null) {
            OCMethodSymbol parentAssociate = this.myParentMethod.getAssociatedSymbol(project);
            if (parentAssociate == null) {
                return true;
            }
            int indexInParent = 0;
            for (OCMethodSymbol.SelectorPartSymbol selector : this.myParentMethod.getSelectors()) {
                if (this.equals(selector.getParameter())) break;
                ++indexInParent;
            }
            if (indexInParent >= this.myParentMethod.getSelectors().size()) {
                return true;
            }
            OCDeclaratorSymbol parameter = parentAssociate.getSelectors().get(indexInParent).getParameter();
            return parameter == null || processor2.process((Object)parameter);
        }
        if (this.myParent instanceof OCFunctionSymbol) {
            int parameterIndex = this.getIndexOfParameter();
            return this.myParent.processAssociatedSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCFunctionSymbol && parameterIndex != -1 && parameterIndex < ((OCFunctionSymbol)symbol).getParameterSymbols().size()) {
                    return processor2.process((Object)((OCFunctionSymbol)symbol).getParameterSymbols().get(parameterIndex));
                }
                return true;
            }), project);
        }
        return true;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2, PsiFile file, @NotNull Project project) {
        if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
            if (this.myParentMethod != null) {
                OCSymbol associatedSymbol = this.getAssociatedSymbol(project);
                return processor2.process((Object)this) && (associatedSymbol == null || processor2.process((Object)associatedSymbol));
            }
            if (this.myParent instanceof OCFunctionSymbol) {
                return processor2.process((Object)this) && this.processAssociatedSymbols(processor2, project);
            }
        }
        return super.processSameSymbols(processor2, file, project);
    }

    @NotNull
    public OCDeclaratorSymbolImpl setProperty(OCDeclaratorSymbol.Property property) {
        this.myPropertiesAndAttributes |= property.getMask();
        return this;
    }

    @NotNull
    public OCDeclaratorSymbolImpl setVisibility(OCVisibility visibility) {
        this.myVisibility = visibility;
        return this;
    }

    public OCDeclaratorSymbolImpl setUsingParent(OCSymbol usingParent) {
        this.myUsingParent = usingParent;
        return this;
    }

    @Override
    @Nullable
    public OCSymbol getUsingParent() {
        if (this.isFromUsing()) {
            return this.myUsingParent;
        }
        return null;
    }
}

