/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithParentAndSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCDeclaratorSymbol
extends OCSymbolWithQualifiedName,
OCSymbolWithParentAndSubstitution,
OCTemplateSymbol {
    public boolean hasAttribute(@NotNull OCSymbolAttribute var1);

    public boolean hasProperty(@NotNull Property var1);

    @Nullable
    public OCInitializerSymbol getInitializer();

    @Nullable
    public OCExpressionSymbol getInitializerExpression();

    default public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    default public boolean isMutable() {
        return this.hasAttribute(OCSymbolAttribute.MUTABLE);
    }

    @Override
    default public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    @Override
    default public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    default public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    default public boolean isBlockModifiable() {
        return this.hasAttribute(OCSymbolAttribute.BLOCK_MODIFIABLE);
    }

    default public boolean isPassByReference() {
        return this.hasProperty(Property.IS_PASS_BY_REF);
    }

    @Override
    default public boolean isFromUsing() {
        return this.hasProperty(Property.IS_FROM_USING);
    }

    default public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    default public boolean hasInitializerExpression() {
        return this.getInitializerExpression() != null;
    }

    @Nullable
    default public OCDeclaratorSymbol getDeclarationInParent(@NotNull OCResolveContext context) {
        return OCDeclaratorSymbolImpl.getDeclarationInParent(this, context);
    }

    default public boolean resolveIsStatic(@NotNull OCResolveContext context) {
        return OCDeclaratorSymbolImpl.resolveIsStatic(this, context);
    }

    @Override
    default public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result = this.getBaseIcon();
        if (result == null) {
            return null;
        }
        return this.getKind() == OCSymbolKind.GLOBAL_VARIABLE && OCTestFrameworks.isTestGlobalVar(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull PsiElement context) {
        return OCTypeUtils.changeTypeReferences(this.getEffectiveType(context.getProject()), OCSymbolReference.getLocalReference(this.getName(), context));
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_PASS_BY_REF = new Property();
        public static final /* enum */ Property IS_DECLARED_IN_LAMBDA_CAPTURE = new Property();
        public static final /* enum */ Property IS_SYNTHETIC = new Property();
        public static final /* enum */ Property IS_ENCODED_PARAM_INDEX = new Property();
        public static final /* enum */ Property IS_FROM_USING = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        private static /* synthetic */ Property[] $values() {
            return new Property[]{IS_PASS_BY_REF, IS_DECLARED_IN_LAMBDA_CAPTURE, IS_SYNTHETIC, IS_ENCODED_PARAM_INDEX, IS_FROM_USING};
        }

        static {
            $VALUES = Property.$values();
        }
    }
}

