/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum OCSymbolKind {
    CATCH_EXCEPTION_VARIABLE,
    LOCAL_VARIABLE,
    PARAMETER,
    LABEL,
    STRUCT_FIELD,
    PROPERTY,
    INSTANCE_VARIABLE,
    METHOD,
    FUNCTION_PREDECLARATION,
    FUNCTION_DECLARATION,
    TYPEDEF,
    COMPATIBILITY_ALIAS,
    INTERFACE,
    PROTOCOL,
    IMPLEMENTATION,
    STRUCT,
    USING_SYMBOL_ALIAS,
    ENUM,
    UNION,
    NAMESPACE_ALIAS,
    NAMESPACE,
    NAMESPACE_USING_SYMBOL,
    SYMBOL_USING_SYMBOL,
    ENUM_CONST,
    GLOBAL_VARIABLE,
    GLOBAL_VARIABLE_PREDECLARATION,
    CPP_CONSTRUCTOR_PREDECLARATION,
    CPP_CONSTRUCTOR_DECLARATION,
    CPP_DEDUCTION_GUIDE,
    CPP_CTAD_DEDUCTION_CANDIDATE,
    CPP_CONCEPT,
    MACRO,
    MACRO_PARAMETER,
    UNDEF_MACRO,
    TEMPLATE_TYPE_PARAMETER,
    TEMPLATE_VALUE_PARAMETER,
    BUILTIN_SYMBOL,
    SYNTHESIZE,
    BLOCK,
    LAMBDA,
    IMPORT,
    LOCALIZED_STRING,
    EXPRESSION,
    ARGUMENT_LIST,
    GENERIC_PARAMETER,
    EXCEPTION_SPECIFIER,
    FOREIGN_ELEMENT,
    KEYWORD,
    FILE,
    FOLDER,
    UNKNOWN;


    @NotNull
    @Nls
    public String getName() {
        return switch (this) {
            case TYPEDEF -> OCBundle.message("symbol.kind.name.uppercase.type", new Object[0]);
            case ENUM_CONST -> OCBundle.message("symbol.kind.name.uppercase.enum.constant", new Object[0]);
            case STRUCT_FIELD -> OCBundle.message("symbol.kind.name.uppercase.field", new Object[0]);
            case FUNCTION_PREDECLARATION, FUNCTION_DECLARATION -> OCBundle.message("symbol.kind.name.uppercase.function", new Object[0]);
            case CPP_CONSTRUCTOR_DECLARATION, CPP_CONSTRUCTOR_PREDECLARATION -> OCBundle.message("symbol.kind.name.uppercase.constructor", new Object[0]);
            case PARAMETER -> OCBundle.message("symbol.kind.name.uppercase.parameter", new Object[0]);
            case GLOBAL_VARIABLE, GLOBAL_VARIABLE_PREDECLARATION -> OCBundle.message("symbol.kind.name.uppercase.global.variable", new Object[0]);
            case BUILTIN_SYMBOL -> OCBundle.message("symbol.kind.name.uppercase.built.in.symbol", new Object[0]);
            case LOCAL_VARIABLE -> OCBundle.message("symbol.kind.name.uppercase.local.variable", new Object[0]);
            case CATCH_EXCEPTION_VARIABLE -> OCBundle.message("symbol.kind.name.uppercase.exception.variable", new Object[0]);
            case IMPLEMENTATION -> OCBundle.message("symbol.kind.name.uppercase.implementation", new Object[0]);
            case INSTANCE_VARIABLE -> OCBundle.message("symbol.kind.name.uppercase.instance.variable", new Object[0]);
            case INTERFACE -> OCBundle.message("symbol.kind.name.uppercase.interface", new Object[0]);
            case LABEL -> OCBundle.message("symbol.kind.name.uppercase.label", new Object[0]);
            case MACRO, UNDEF_MACRO -> OCBundle.message("symbol.kind.name.uppercase.macro", new Object[0]);
            case MACRO_PARAMETER -> OCBundle.message("symbol.kind.name.uppercase.macro.parameter", new Object[0]);
            case IMPORT -> OCBundle.message("symbol.kind.name.uppercase.import", new Object[0]);
            case COMPATIBILITY_ALIAS -> OCBundle.message("symbol.kind.name.uppercase.compatibility.alias", new Object[0]);
            case METHOD -> OCBundle.message("symbol.kind.name.uppercase.method1", new Object[0]);
            case BLOCK -> OCBundle.message("symbol.kind.name.uppercase.block", new Object[0]);
            case LAMBDA -> OCBundle.message("symbol.kind.name.uppercase.lambda", new Object[0]);
            case PROPERTY -> OCBundle.message("symbol.kind.name.uppercase.property", new Object[0]);
            case SYNTHESIZE -> OCBundle.message("symbol.kind.name.uppercase.synthesize.statement", new Object[0]);
            case PROTOCOL -> OCBundle.message("symbol.kind.name.uppercase.protocol", new Object[0]);
            case STRUCT -> OCBundle.message("symbol.kind.name.uppercase.struct", new Object[0]);
            case UNION -> OCBundle.message("symbol.kind.name.uppercase.union", new Object[0]);
            case ENUM -> OCBundle.message("symbol.kind.name.uppercase.enum", new Object[0]);
            case NAMESPACE, NAMESPACE_ALIAS -> OCBundle.message("symbol.kind.name.uppercase.namespace", new Object[0]);
            case TEMPLATE_TYPE_PARAMETER -> OCBundle.message("symbol.kind.name.uppercase.type.parameter", new Object[0]);
            case TEMPLATE_VALUE_PARAMETER -> OCBundle.message("symbol.kind.name.uppercase.template.parameter", new Object[0]);
            case SYMBOL_USING_SYMBOL, NAMESPACE_USING_SYMBOL, USING_SYMBOL_ALIAS -> OCBundle.message("symbol.kind.name.uppercase.using", new Object[0]);
            case LOCALIZED_STRING -> OCBundle.message("symbol.kind.name.uppercase.localized.string", new Object[0]);
            case EXPRESSION -> OCBundle.message("symbol.kind.name.uppercase.expression", new Object[0]);
            case GENERIC_PARAMETER -> OCBundle.message("symbol.kind.name.uppercase.generic.parameter", new Object[0]);
            case CPP_CONCEPT -> OCBundle.message("symbol.kind.name.uppercase.concept", new Object[0]);
            case KEYWORD -> OCBundle.message("symbol.kind.name.uppercase.keyword", new Object[0]);
            case FILE -> OCBundle.message("symbol.kind.name.uppercase.file", new Object[0]);
            case FOLDER -> OCBundle.message("symbol.kind.name.uppercase.folder", new Object[0]);
            default -> OCBundle.message("symbol.kind.name.uppercase.default", new Object[0]);
        };
    }

    @NotNull
    @Nls
    public String getNameLowercase() {
        return switch (this) {
            case TYPEDEF -> OCBundle.message("symbol.kind.name.lowercase.type", new Object[0]);
            case ENUM_CONST -> OCBundle.message("symbol.kind.name.lowercase.enum.constant", new Object[0]);
            case STRUCT_FIELD -> OCBundle.message("symbol.kind.name.lowercase.field", new Object[0]);
            case FUNCTION_PREDECLARATION, FUNCTION_DECLARATION -> OCBundle.message("symbol.kind.name.lowercase.function", new Object[0]);
            case CPP_CONSTRUCTOR_DECLARATION, CPP_CONSTRUCTOR_PREDECLARATION -> OCBundle.message("symbol.kind.name.lowercase.constructor", new Object[0]);
            case PARAMETER -> OCBundle.message("symbol.kind.name.lowercase.parameter", new Object[0]);
            case GLOBAL_VARIABLE, GLOBAL_VARIABLE_PREDECLARATION -> OCBundle.message("symbol.kind.name.lowercase.global.variable", new Object[0]);
            case BUILTIN_SYMBOL -> OCBundle.message("symbol.kind.name.lowercase.built.in.symbol", new Object[0]);
            case LOCAL_VARIABLE -> OCBundle.message("symbol.kind.name.lowercase.local.variable", new Object[0]);
            case CATCH_EXCEPTION_VARIABLE -> OCBundle.message("symbol.kind.name.lowercase.exception.variable", new Object[0]);
            case IMPLEMENTATION -> OCBundle.message("symbol.kind.name.lowercase.implementation", new Object[0]);
            case INSTANCE_VARIABLE -> OCBundle.message("symbol.kind.name.lowercase.instance.variable", new Object[0]);
            case INTERFACE -> OCBundle.message("symbol.kind.name.lowercase.interface", new Object[0]);
            case LABEL -> OCBundle.message("symbol.kind.name.lowercase.label", new Object[0]);
            case MACRO, UNDEF_MACRO -> OCBundle.message("symbol.kind.name.lowercase.macro", new Object[0]);
            case MACRO_PARAMETER -> OCBundle.message("symbol.kind.name.lowercase.macro.parameter", new Object[0]);
            case IMPORT -> OCBundle.message("symbol.kind.name.lowercase.import", new Object[0]);
            case COMPATIBILITY_ALIAS -> OCBundle.message("symbol.kind.name.lowercase.compatibility.alias", new Object[0]);
            case METHOD -> OCBundle.message("symbol.kind.name.lowercase.method1", new Object[0]);
            case BLOCK -> OCBundle.message("symbol.kind.name.lowercase.block", new Object[0]);
            case LAMBDA -> OCBundle.message("symbol.kind.name.lowercase.lambda", new Object[0]);
            case PROPERTY -> OCBundle.message("symbol.kind.name.lowercase.property", new Object[0]);
            case SYNTHESIZE -> OCBundle.message("symbol.kind.name.lowercase.synthesize.statement", new Object[0]);
            case PROTOCOL -> OCBundle.message("symbol.kind.name.lowercase.protocol", new Object[0]);
            case STRUCT -> OCBundle.message("symbol.kind.name.lowercase.struct", new Object[0]);
            case UNION -> OCBundle.message("symbol.kind.name.lowercase.union", new Object[0]);
            case ENUM -> OCBundle.message("symbol.kind.name.lowercase.enum", new Object[0]);
            case NAMESPACE, NAMESPACE_ALIAS -> OCBundle.message("symbol.kind.name.lowercase.namespace", new Object[0]);
            case TEMPLATE_TYPE_PARAMETER -> OCBundle.message("symbol.kind.name.lowercase.type.parameter", new Object[0]);
            case TEMPLATE_VALUE_PARAMETER -> OCBundle.message("symbol.kind.name.lowercase.template.parameter", new Object[0]);
            case SYMBOL_USING_SYMBOL, NAMESPACE_USING_SYMBOL, USING_SYMBOL_ALIAS -> OCBundle.message("symbol.kind.name.lowercase.using", new Object[0]);
            case LOCALIZED_STRING -> OCBundle.message("symbol.kind.name.lowercase.localized.string", new Object[0]);
            case EXPRESSION -> OCBundle.message("symbol.kind.name.lowercase.expression", new Object[0]);
            case GENERIC_PARAMETER -> OCBundle.message("symbol.kind.name.lowercase.generic.parameter", new Object[0]);
            case CPP_CONCEPT -> OCBundle.message("symbol.kind.name.lowercase.concept", new Object[0]);
            case KEYWORD -> OCBundle.message("symbol.kind.name.lowercase.keyword", new Object[0]);
            case FILE -> OCBundle.message("symbol.kind.name.lowercase.file", new Object[0]);
            case FOLDER -> OCBundle.message("symbol.kind.name.lowercase.folder", new Object[0]);
            default -> OCBundle.message("symbol.kind.name.lowercase.default", new Object[0]);
        };
    }

    public Class<? extends PsiElement> getPsiElementClass() {
        return switch (this) {
            case BUILTIN_SYMBOL -> PsiElement.class;
            case IMPLEMENTATION -> OCImplementation.class;
            case INTERFACE, PROTOCOL -> OCClassDeclaration.class;
            case LABEL -> OCLabeledStatement.class;
            case MACRO -> OCDefineDirective.class;
            case UNDEF_MACRO -> OCUndefDirective.class;
            case MACRO_PARAMETER -> OCMacroParameter.class;
            case IMPORT -> OCIncludeDirective.class;
            case COMPATIBILITY_ALIAS -> OCCompatibilityAlias.class;
            case METHOD -> OCMethod.class;
            case BLOCK -> OCBlockExpression.class;
            case SYNTHESIZE -> OCSynthesizeProperty.class;
            case STRUCT -> OCStruct.class;
            case UNION -> OCUnion.class;
            case ENUM -> OCEnum.class;
            case NAMESPACE -> OCCppNamespace.class;
            case NAMESPACE_ALIAS -> OCCppNamespaceAlias.class;
            case TEMPLATE_TYPE_PARAMETER -> OCTypeParameterDeclaration.class;
            case SYMBOL_USING_SYMBOL, NAMESPACE_USING_SYMBOL, USING_SYMBOL_ALIAS -> OCCppUsingStatement.class;
            case LOCALIZED_STRING -> OCLocalizedString.class;
            case EXPRESSION -> OCExpression.class;
            case GENERIC_PARAMETER -> OCGenericParameter.class;
            case CPP_CONCEPT -> OCConceptDeclaration.class;
            default -> OCDeclarator.class;
        };
    }

    public Icon getIcon() {
        return switch (this) {
            case NAMESPACE, NAMESPACE_ALIAS, NAMESPACE_USING_SYMBOL -> CidrLangIcons.CodeAssistantNamespace;
            case TYPEDEF, TEMPLATE_TYPE_PARAMETER, SYMBOL_USING_SYMBOL, USING_SYMBOL_ALIAS -> CidrLangIcons.CodeAssistantType;
            case ENUM_CONST -> CidrLangIcons.CodeAssistantEnumConst;
            case FUNCTION_PREDECLARATION, FUNCTION_DECLARATION, CPP_CONSTRUCTOR_DECLARATION, CPP_CONSTRUCTOR_PREDECLARATION -> CidrLangIcons.CodeAssistantFunction;
            case STRUCT_FIELD, INSTANCE_VARIABLE -> CidrLangIcons.CodeAssistantField;
            case IMPLEMENTATION, INTERFACE -> CidrLangIcons.CodeAssistantClass;
            case MACRO, UNDEF_MACRO, MACRO_PARAMETER, IMPORT -> CidrLangIcons.CodeAssistantMacro;
            case COMPATIBILITY_ALIAS -> CidrLangIcons.CodeAssistantClass;
            case METHOD -> CidrLangIcons.CodeAssistantMember;
            case PROPERTY -> CidrLangIcons.CodeAssistantProperty;
            case PROTOCOL -> CidrLangIcons.CodeAssistantProtocol;
            case STRUCT -> CidrLangIcons.CodeAssistantStruct;
            case UNION -> CidrLangIcons.CodeAssistantUnion;
            case ENUM -> CidrLangIcons.CodeAssistantEnum;
            case PARAMETER, TEMPLATE_VALUE_PARAMETER, GENERIC_PARAMETER -> CidrLangIcons.CodeAssistantParameter;
            case LOCAL_VARIABLE, CATCH_EXCEPTION_VARIABLE, LABEL -> CidrLangIcons.CodeAssistantLocal;
            case GLOBAL_VARIABLE, GLOBAL_VARIABLE_PREDECLARATION, BUILTIN_SYMBOL -> CidrLangIcons.CodeAssistantGlobal;
            case BLOCK, LAMBDA, SYNTHESIZE, LOCALIZED_STRING, EXPRESSION -> null;
            default -> null;
        };
    }

    @NotNull
    @Nls
    public String getNameUppercase() {
        return this.getName();
    }

    public boolean isClass() {
        return switch (this) {
            case IMPLEMENTATION, INTERFACE, COMPATIBILITY_ALIAS, PROTOCOL -> true;
            default -> false;
        };
    }

    public boolean isClassOrTypedef() {
        return this.isClass() || this == TYPEDEF || this == USING_SYMBOL_ALIAS;
    }

    public boolean isType() {
        return this.isClassOrTypedef() || this.isStructLike() || this == TEMPLATE_TYPE_PARAMETER || this == COMPATIBILITY_ALIAS || this == GENERIC_PARAMETER;
    }

    public boolean isStructLike() {
        return switch (this) {
            case STRUCT, UNION, ENUM -> true;
            default -> false;
        };
    }

    @NlsSafe
    @NotNull
    public String getStructKeyword() {
        return switch (this) {
            case STRUCT -> "struct";
            case UNION -> "union";
            case ENUM -> "enum";
            default -> {
                OCLog.LOG.error("getStructKeyword should be called on isStructLike symbol kind");
                yield "";
            }
        };
    }

    public boolean isStructOrUnion() {
        return this == STRUCT || this == UNION;
    }

    public boolean isFunction() {
        return this == FUNCTION_PREDECLARATION || this == FUNCTION_DECLARATION;
    }

    public boolean isFunctionOrConstructor() {
        return this.isFunction() || this.isConstructorOrDestructor();
    }

    public boolean isCallable() {
        return this.isFunction() || this == METHOD || this == BLOCK || this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == LAMBDA;
    }

    public boolean isPredeclaration() {
        return this == FUNCTION_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == STRUCT_FIELD;
    }

    public boolean isLocal() {
        return this == LOCAL_VARIABLE || this == CATCH_EXCEPTION_VARIABLE || this == LABEL || this == PARAMETER;
    }

    public boolean isConst() {
        return this == ENUM_CONST || this == TEMPLATE_VALUE_PARAMETER || this == GENERIC_PARAMETER || this.isFunction();
    }

    public OCSymbolKind toDeclarationKind() {
        return switch (this) {
            case FUNCTION_PREDECLARATION -> FUNCTION_DECLARATION;
            case CPP_CONSTRUCTOR_PREDECLARATION -> CPP_CONSTRUCTOR_DECLARATION;
            case GLOBAL_VARIABLE_PREDECLARATION -> GLOBAL_VARIABLE;
            default -> this;
        };
    }

    public boolean isExpression() {
        return switch (this) {
            case ENUM_CONST, STRUCT_FIELD, FUNCTION_PREDECLARATION, FUNCTION_DECLARATION, CPP_CONSTRUCTOR_DECLARATION, CPP_CONSTRUCTOR_PREDECLARATION, PARAMETER, GLOBAL_VARIABLE, GLOBAL_VARIABLE_PREDECLARATION, BUILTIN_SYMBOL, LOCAL_VARIABLE, CATCH_EXCEPTION_VARIABLE, INSTANCE_VARIABLE, LAMBDA, PROPERTY, TEMPLATE_VALUE_PARAMETER -> true;
            default -> false;
        };
    }

    public boolean isVariable() {
        return switch (this) {
            case ENUM_CONST, PARAMETER, GLOBAL_VARIABLE, GLOBAL_VARIABLE_PREDECLARATION, LOCAL_VARIABLE, CATCH_EXCEPTION_VARIABLE, INSTANCE_VARIABLE, PROPERTY, TEMPLATE_VALUE_PARAMETER -> true;
            default -> false;
        };
    }

    public boolean isGlobalVariable() {
        return this == GLOBAL_VARIABLE || this == GLOBAL_VARIABLE_PREDECLARATION;
    }

    public boolean isConstructorOrDestructor() {
        return this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION;
    }

    public boolean isTemplateParameter() {
        return this == TEMPLATE_VALUE_PARAMETER || this == TEMPLATE_TYPE_PARAMETER || this == GENERIC_PARAMETER;
    }

    public boolean isTypedefOrAlias() {
        return this == TYPEDEF || this == COMPATIBILITY_ALIAS || this == USING_SYMBOL_ALIAS;
    }

    public boolean canBeNamespace() {
        return switch (this) {
            case TYPEDEF, STRUCT, UNION, ENUM, NAMESPACE, NAMESPACE_ALIAS, TEMPLATE_TYPE_PARAMETER -> true;
            default -> false;
        };
    }

    public static OCSymbolKind parse(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("struct") || name.equals("class")) {
            return STRUCT;
        }
        if (name.equals("enum")) {
            return ENUM;
        }
        if (name.equals("union")) {
            return UNION;
        }
        if (name.equals("concept")) {
            return CPP_CONCEPT;
        }
        return null;
    }

    public boolean isSame(@NotNull OCSymbolKind kind) {
        return this == kind || this == FUNCTION_DECLARATION && kind == FUNCTION_PREDECLARATION || this == FUNCTION_PREDECLARATION && kind == FUNCTION_DECLARATION || this == CPP_CONSTRUCTOR_DECLARATION && kind == CPP_CONSTRUCTOR_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION && kind == CPP_CONSTRUCTOR_DECLARATION || this == GLOBAL_VARIABLE && kind == GLOBAL_VARIABLE_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION && kind == GLOBAL_VARIABLE;
    }
}

