/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDelegatingSymbol
implements OCSymbol {
    @NotNull
    private OCSymbol myDelegate;

    public OCDelegatingSymbol(@NotNull OCSymbol delegate) {
        this.myDelegate = delegate;
    }

    public OCDelegatingSymbol() {
    }

    public static Processor<OCSymbol> getDelegateProcessor(@NotNull Processor<? super OCSymbol> processor2) {
        return symbol -> processor2.process((Object)symbol.getDelegate());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.myDelegate.equals(((OCDelegatingSymbol)object).myDelegate);
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @NotNull
    public OCSymbol getRawDelegate() {
        return this.myDelegate;
    }

    @Override
    @NotNull
    public OCSymbol getDelegate() {
        return this.myDelegate.getDelegate();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.myDelegate.getPresentableText();
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.myDelegate.getType();
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.myDelegate.getResolvedType(context);
    }

    @Override
    public OCType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        return this.myDelegate.getResolvedType(context, ignoringImports);
    }

    @Override
    public boolean isGlobal() {
        return this.myDelegate.isGlobal();
    }

    @Override
    public boolean isCallable() {
        return this.myDelegate.isCallable();
    }

    @Override
    public boolean isDefinition() {
        return this.myDelegate.isDefinition();
    }

    @Override
    public boolean isPredeclaration() {
        return this.myDelegate.isPredeclaration();
    }

    @Override
    @NotNull
    public List<String> getAttributes() {
        return this.myDelegate.getAttributes();
    }

    @Override
    public boolean isUnnamed() {
        return this.myDelegate.isUnnamed();
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project) {
        return this.myDelegate.locateDefinition(project);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
    }

    @Override
    public void compact() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.myDelegate.getName();
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project) {
        return this.myDelegate.getSignature(project);
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myDelegate.getScope();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myDelegate.getPresentableName();
    }

    @Override
    @Nullable
    public String getLocationString() {
        return this.myDelegate.getLocationString();
    }

    @Override
    public boolean isSynthetic() {
        return this.myDelegate.isSynthetic();
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.myDelegate.getKind();
    }

    @Override
    @NotNull
    public String getNameWithKindLowercase(@NotNull OCCompilationContext context) {
        return this.myDelegate.getNameWithKindLowercase(context);
    }

    @Override
    @NotNull
    public String getNameWithKindUppercase(@NotNull OCCompilationContext context) {
        return this.myDelegate.getNameWithKindUppercase(context);
    }

    @Override
    public String getKindLowercase(@NotNull OCCompilationContext context) {
        return this.myDelegate.getKindLowercase(context);
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        return this.myDelegate.getKindUppercase(context);
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol(@NotNull Project project) {
        return this.myDelegate.getDefinitionSymbol(project);
    }

    @Override
    public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        return this.myDelegate.processAssociatedSymbols(processor2, project);
    }

    @Override
    @Nullable
    public OCSymbol getAssociatedSymbol(@NotNull Project project) {
        return this.myDelegate.getAssociatedSymbol(project);
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        return this.myDelegate.processSameSymbols(processor2, project);
    }

    @Override
    @Nullable
    public PsiFile getContainingPsiFile(@NotNull Project project) {
        return this.myDelegate.getContainingPsiFile(project);
    }

    @Override
    @Nullable
    public OCFile getContainingOCFile(@NotNull Project project) {
        return this.myDelegate.getContainingOCFile(project);
    }

    @Override
    public int getOffset() {
        return this.myDelegate.getOffset();
    }

    @Override
    public long getComplexOffset() {
        return this.myDelegate.getComplexOffset();
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull Project project) {
        return this.myDelegate.getIcon(project);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myDelegate.getBaseIcon();
    }

    @Override
    @Nullable
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        return this.myDelegate.computeFullIconNow(symbolElement, project);
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project) {
        return this.myDelegate.isSameSymbol(symbol, project);
    }

    @Override
    public int hashCodeExcludingOffset() {
        return this.myDelegate.hashCodeExcludingOffset();
    }

    @Override
    @NotNull
    public OCType getEffectiveType(@NotNull Project project) {
        return this.myDelegate.getEffectiveType(project);
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        return this.myDelegate.getEffectiveResolvedType(context);
    }

    @Override
    public boolean isDeprecated() {
        return this.myDelegate.isDeprecated();
    }

    @Override
    @NotNull
    public String getDeprecatedMessage(@NotNull OCCompilationContext context) {
        return this.myDelegate.getDeprecatedMessage(context);
    }

    @Override
    public boolean isUnavailable() {
        return this.myDelegate.isUnavailable();
    }

    @Override
    public boolean isUnused() {
        return this.myDelegate.isUnused();
    }

    @Override
    @NotNull
    public String getUnavailableMessage(@NotNull OCCompilationContext context) {
        return this.myDelegate.getUnavailableMessage(context);
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return this.myDelegate.isForbiddenByARC(context);
    }

    @Override
    public boolean isTransparentUnion() {
        return this.myDelegate.isTransparentUnion();
    }

    @Override
    public boolean hasAttribute(@NotNull String attribute2) {
        return this.myDelegate.hasAttribute(attribute2);
    }

    @Override
    @Nullable
    public String getAttributeParameters(@NotNull String attribute2) {
        return this.myDelegate.getAttributeParameters(attribute2);
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myDelegate.getContainingFile();
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        return this.myDelegate.deepEqualStep(c, ((OCDelegatingSymbol)first).myDelegate, ((OCDelegatingSymbol)second).myDelegate);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.getRawDelegate().getLanguage();
    }
}

