/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBestSymbolInSelectedConfiguration<T extends OCSymbol>
implements Condition<T>,
Processor<T> {
    @Nullable
    private final OCResolveConfiguration mySelectedConfiguration;
    @Nullable
    private final VirtualFile myContainingFile;
    @NotNull
    private final OCWorkspace myWorkspace;
    private int myBestScore = -1;
    @Nullable
    private T myBestCandidate;

    public OCBestSymbolInSelectedConfiguration(@NotNull Project project, @Nullable VirtualFile containingFile) {
        this.myWorkspace = OCWorkspace.getInstance((Project)project);
        this.mySelectedConfiguration = containingFile == null ? OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration((Project)project) : OCFileActiveConfigurationCache.getActiveConfiguration(containingFile, project);
        this.myContainingFile = containingFile;
        this.myBestCandidate = null;
    }

    public boolean value(@NotNull T symbol) {
        boolean inSelectedConfiguration;
        VirtualFile vtCandidate = symbol.getContainingFile();
        int scope = OCBestSymbolInSelectedConfiguration.getScore(this.myContainingFile, vtCandidate);
        boolean bl = inSelectedConfiguration = vtCandidate != null && this.mySelectedConfiguration != null && this.myWorkspace.getConfigurationsForFile(vtCandidate).contains(this.mySelectedConfiguration);
        if (scope >= this.myBestScore || inSelectedConfiguration) {
            this.myBestScore = scope;
            this.myBestCandidate = symbol;
        }
        return inSelectedConfiguration;
    }

    public boolean process(@NotNull T symbol) {
        return !this.value(symbol);
    }

    private static int getScore(@Nullable VirtualFile base, @Nullable VirtualFile candidate) {
        int scope;
        if (base == null || candidate == null) {
            return 0;
        }
        String basePath = base.getPath();
        String candidatePath = candidate.getPath();
        int maxScope = Integer.min(basePath.length(), candidatePath.length());
        for (scope = 0; scope < maxScope && basePath.charAt(scope) == candidatePath.charAt(scope); ++scope) {
        }
        if (base.getNameWithoutExtension().equals(candidate.getNameWithoutExtension())) {
            scope *= 10;
        }
        return scope;
    }

    @Nullable
    public T getBestCandidate() {
        return this.myBestCandidate;
    }
}

