/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.util.Function;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.symbols.DeepEqualImpl;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DeepEqual {
    private DeepEqual() {
    }

    public static boolean equalObjects(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        return DeepEqual.newResolver().equalObjects(o1, o2);
    }

    @NotNull
    public static Resolver newResolver() {
        return new DeepEqualImpl();
    }

    @TestOnly
    public static Resolver newResolver(@NotNull BiConsumer<Object, Object> preEqualCustom) {
        return DeepEqual.newResolver(true, preEqualCustom, null);
    }

    @TestOnly
    public static Resolver.Debug newResolver(final boolean strictClassComparison, final @NotNull BiConsumer<Object, Object> preEqualCustom, final @Nullable TriConsumer<? super @NotNull Resolver.Debug, ? super @NotNull Pair<Object, Object>, ? super @NotNull Boolean> afterEqualCustom) {
        return new DeepEqualImpl(){

            @Override
            protected boolean equalClass(@NotNull Class<?> klass, @NotNull Object o2) {
                return strictClassComparison ? super.equalClass(klass, o2) : klass.isInstance(o2);
            }

            @Override
            protected <T> void afterDeepEqualStep(T o1, T o2, boolean isEqual) {
                if (afterEqualCustom != null) {
                    afterEqualCustom.accept((Object)this, (Object)new Pair(o1, o2), (Object)isEqual);
                }
            }

            @Override
            protected <T> boolean equalObjects(Equality<T> equality, T o1, T o2) {
                preEqualCustom.accept(o1, o2);
                return super.equalObjects(equality, o1, o2);
            }
        };
    }

    public static interface Resolver
    extends Comparator {
        public void clearCaches();

        public <T> void setEquality(@NotNull Class<T> var1, @Nullable Function<T, Equality<T>> var2);

        public static interface Debug
        extends Resolver {
            @NotNull
            public String getComparisonStackTrace();
        }
    }

    public static interface Equality<T> {
        public boolean deepEqualStep(@NotNull Comparator var1, @NotNull T var2, @NotNull T var3);
    }

    public static interface Comparator {
        public <T> boolean equalObjects(@Nullable Equality<T> var1, @Nullable Equality<T> var2);

        public boolean equalLists(@Nullable List var1, @Nullable List var2);

        public <T> boolean equalArrays(T @Nullable [] var1, T @Nullable [] var2);

        public <K, V> boolean equalMultiMaps(@Nullable MostlySingularMultiMap<K, V> var1, @Nullable MostlySingularMultiMap<K, V> var2);

        public <K, V> boolean equalMaps(@Nullable Map<K, V> var1, @Nullable Map<K, V> var2);

        public boolean equalObjects(@Nullable Object var1, @Nullable Object var2);
    }
}

