/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.CidrCodeStylePreview;
import com.jetbrains.cidr.lang.settings.OCBaseLanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCustomOption;
import com.jetbrains.cidr.lang.settings.OCCustomOptionCpp;
import com.jetbrains.cidr.lang.settings.OCCustomOptionObjC;
import com.jetbrains.cidr.lang.settings.OCGenerateCodeConfigurable;
import com.jetbrains.cidr.lang.settings.OCIndentOptionsEditor;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageCodeStyleSettingsProvider
extends OCBaseLanguageCodeStyleSettingsProvider {
    public OCLanguageCodeStyleSettingsProvider() {
        super(OCLanguageUtils.getConfigLanguage());
    }

    @NotNull
    private static OCCustomOption getCustomOption() {
        return OCLanguage.enableObjectiveCSettings() ? new OCCustomOptionObjC() : new OCCustomOptionCpp();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        OCLanguageCodeStyleSettingsProvider.configureDefaultSettings(commonSettings);
    }

    public static void configureDefaultSettings(@NotNull CommonCodeStyleSettings settings) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PluginUtils.hasAppCode()) {
            settings.ALIGN_MULTILINE_BINARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ASSIGNMENT = true;
            settings.ALIGN_MULTILINE_TERNARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
            settings.SPACE_WITHIN_BRACES = true;
            settings.BINARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
            settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
            settings.ARRAY_INITIALIZER_WRAP = 1;
            settings.ENUM_CONSTANTS_WRAP = 5;
        }
    }

    public static void configureCustomSettings(@NotNull OCCodeStyleSettings ocSettings) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PluginUtils.hasAppCode()) {
            ocSettings.FUNCTION_PARAMETERS_WRAP = 1;
            ocSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
            ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP = 1;
            ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
            ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 1;
            ocSettings.ALIGN_INIT_LIST_IN_COLUMNS = true;
            ocSettings.SPACE_BETWEEN_ADJACENT_BRACKETS = false;
        }
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExt) {
        String defExampleExtension = OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
        return CidrCodeStylePreview.getCodeSample((String)fileNameWithoutExt, (String)defExampleExtension);
    }

    public static OCCustomOption.CustomOption @NotNull [] getFoldingCustomOptions() {
        return OCLanguageCodeStyleSettingsProvider.getCustomOption().getFoldingCustomOptions();
    }

    public static AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        return OCLanguageCodeStyleSettingsProvider.getCustomOption().getAttributeDescriptors();
    }

    @Override
    @NotNull
    protected String getCodeSampleContent(@NotNull String fileNameWithoutExt) {
        return OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt);
    }

    public String getFileExt() {
        return OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new OCIndentOptionsEditor(this);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable c, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        OCCustomOption customOption = OCLanguageCodeStyleSettingsProvider.getCustomOption();
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            c.showStandardOptions(customOption.getWrappingAndBracesOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getWrappingAndBracesRenames()) {
                c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
            }
            for (OCCustomOption.CustomOption customOption2 : customOption.getWrappingAndBracesCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption2.getFieldName(), customOption2.getTitle(), customOption2.getGroupName(), customOption2.getAnchor(), customOption2.getAnchorFieldName(), customOption2.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            c.showStandardOptions(customOption.getSpacingOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getSpacingRenames()) {
                c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
            }
            for (OCCustomOption.CustomOption customOption3 : customOption.getSpacingCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption3.getFieldName(), customOption3.getTitle(), customOption3.getGroupName(), customOption3.getAnchor(), customOption3.getAnchorFieldName(), customOption3.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            for (OCCustomOption.CustomOption customOption4 : customOption.getIndentCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption4.getFieldName(), customOption4.getTitle(), customOption4.getGroupName(), customOption4.getAnchor(), customOption4.getAnchorFieldName(), customOption4.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            OCGenerateCodeConfigurable.customizeSettings(c);
        } else {
            c.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
        }
        for (OCCustomOption.RenameAction renameAction : customOption.getBlankLinesRenames()) {
            c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
        }
    }

    @NotNull
    public String getExternalLanguageId() {
        return "c";
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        OCCodeStyleSettings.NewLineConstant newLineConstantAnnotation = field.getAnnotation(OCCodeStyleSettings.NewLineConstant.class);
        if (newLineConstantAnnotation != null) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"never", "always", "if_long"});
        }
        return null;
    }
}

