/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEnumOption<T> {
    private final T[] myValues;
    private final JLabel myLabel;
    private final List<JRadioButton> myButtons = new ArrayList<JRadioButton>();

    public OCEnumOption(@NlsContexts.Label String groupName, T[] values, String ... choices) {
        assert (values.length == choices.length);
        this.myValues = values;
        this.myLabel = new JLabel(groupName);
        ButtonGroup group = new ButtonGroup();
        for (String choice : choices) {
            JRadioButton button = new JRadioButton(choice);
            group.add(button);
            this.myButtons.add(button);
        }
    }

    @NotNull
    public List<JRadioButton> getButtons() {
        return this.myButtons;
    }

    @NotNull
    public JLabel getLabel() {
        return this.myLabel;
    }

    @Nullable
    public T getSelected() {
        for (int i = 0; i < this.myButtons.size(); ++i) {
            if (!this.myButtons.get(i).isSelected()) continue;
            return this.myValues[i];
        }
        return null;
    }

    public void selectedValue(T val) {
        for (int i = 0; i < this.myValues.length; ++i) {
            if (this.myValues[i] != val) continue;
            this.myButtons.get(i).setSelected(true);
            break;
        }
    }
}

