/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorReferenceFromCompoundInit;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCConstructorReferenceSearchBase
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        boolean unusedInspectionMode = element.getUserData(OCUnusedVisitor.UNUSED_INSPECTION_MODE_KEY) == Boolean.TRUE;
        PsiElement parent = (PsiElement)ReadAction.compute(() -> ((PsiElement)element).getParent());
        if (!(parent instanceof OCFunctionDeclaration)) {
            return true;
        }
        OCFunctionDeclaration constructor = (OCFunctionDeclaration)parent;
        SearchWordAndProcessor searchWordAndProcessor = (SearchWordAndProcessor)ReadAction.compute(() -> this.getSearchWordAndProcessor(queryParameters, consumer, constructor, unusedInspectionMode));
        if (searchWordAndProcessor == null) {
            return true;
        }
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> {
            Project project = element.getProject();
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return PsiSearchHelper.getInstance((Project)project);
        });
        return helper.processElementsWithWord(searchWordAndProcessor.myProcessor, queryParameters.getEffectiveSearchScope(), searchWordAndProcessor.mySearchWord, (short)1, true);
    }

    @Nullable
    private SearchWordAndProcessor getSearchWordAndProcessor(ReferencesSearch.SearchParameters queryParameters, Processor<? super PsiReference> consumer, OCFunctionDeclaration constructor, boolean unusedInspectionMode) {
        OCFunctionSymbol constructorPredefinition;
        OCSymbolWithQualifiedName constructorSymbol = (OCSymbolWithQualifiedName)constructor.getSymbol();
        if (!(constructorSymbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
            return null;
        }
        String searchWord = constructor.getName();
        if (searchWord == null) {
            return null;
        }
        OCFunctionSymbol predefinition = (OCFunctionSymbol)OCSearchUtil.getFirstPredeclaration(constructorSymbol, constructor.getProject());
        OCFunctionSymbol oCFunctionSymbol = constructorPredefinition = predefinition != null ? predefinition : (OCFunctionSymbol)constructorSymbol;
        if (!(constructorPredefinition.getParent() instanceof OCStructSymbol)) {
            return null;
        }
        OCStructSymbol structSymbol = (OCStructSymbol)constructorPredefinition.getParent();
        OCStructType structType = structSymbol.getType();
        CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
        constructors.process((Object)structSymbol);
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)constructors, OCResolveContext.forPsi(constructor));
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        TextOccurenceProcessor processor2 = (element, offsetInElement) -> {
            PsiElement parent = element.getParent();
            if (parent instanceof OCTypeElement && parent.getContext() instanceof OCDeclaration) {
                OCDeclaration declaration = (OCDeclaration)parent.getContext();
                if (PsiTreeUtil.getContextOfType((PsiElement)declaration, (Class[])new Class[]{OCParameterList.class}) != null) {
                    return true;
                }
                if (declaration.getParent() instanceof OCStruct) {
                    OCStructSymbol symbol = (OCStructSymbol)((OCStruct)declaration.getParent()).getSymbol();
                    OCResolveContext context = OCResolveContext.forPsi(declaration);
                    for (OCDeclarator declarator : declaration.getDeclarators()) {
                        if (!declarator.getType().resolve(context).equals(structType, context)) {
                            return true;
                        }
                        if (this.processStructFieldInitializers(symbol, declarator, structType, constructorPredefinition, constructors.getResults(), consumer, searchScope)) continue;
                        this.onReferenceFromStruct((OCStruct)declaration.getParent(), declarator, constructorPredefinition, consumer);
                    }
                    return true;
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    for (PsiReference ref : declarator.getReferences()) {
                        if (!ref.isReferenceTo((PsiElement)constructor) || this.onReferenceFromDeclarator(declarator, constructorPredefinition, consumer)) continue;
                        return false;
                    }
                }
            } else if (parent instanceof OCCppBaseClause) {
                OCStructSymbol symbol;
                OCStruct struct = (OCStruct)parent.getContext().getContext();
                OCStructSymbol oCStructSymbol = symbol = struct != null ? (OCStructSymbol)struct.getSymbol() : null;
                if (symbol != null && !this.processStructFieldInitializers(symbol, constructor, structType, constructorPredefinition, constructors.getResults(), consumer, searchScope)) {
                    this.onReferenceFromStruct(struct, constructor, constructorPredefinition, consumer);
                }
            } else if (parent instanceof OCCppUsingStatement) {
                OCSymbol symbol = ((OCCppUsingStatement)parent).getLocalSymbol();
                if (symbol instanceof OCUsingSymbol && ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(OCResolveContext.forPsi(element)).contains(constructorPredefinition) && !this.onReferenceFromUsing((OCCppUsingStatement)parent, constructorPredefinition, consumer)) {
                    return false;
                }
            } else if (element instanceof OCFunctionDefinition) {
                OCFunctionDefinition funcDef = (OCFunctionDefinition)element;
                OCType returntype = funcDef.getReturnType();
                if (returntype.getTerminalType().getName().equals(searchWord)) {
                    OCConstructorReferenceSearchBase.processReturnStatements(constructor, constructorPredefinition, funcDef, consumer);
                }
            } else if (unusedInspectionMode && element instanceof OCReferenceElement && PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCTemplateArgumentList.class, OCTypeParameterDeclaration.class}) != null) {
                consumer.process((Object)((OCReferenceElement)element));
            }
            return true;
        };
        return new SearchWordAndProcessor(searchWord, processor2);
    }

    private static void processReturnStatements(@NotNull OCFunctionDeclaration constructor, final @NotNull OCFunctionSymbol constructorPredefinition, @NotNull OCFunctionDefinition funcDef, final @NotNull Processor<? super PsiReference> consumer) {
        OCBlockStatement funcBody = funcDef.getBody();
        if (funcBody == null) {
            return;
        }
        List<OCDeclarator> constructorParams = constructor.getParameters();
        if (constructorParams == null) {
            return;
        }
        final int numCtorParams = constructorParams.size();
        OCRecursiveVisitor retVisitor = new OCRecursiveVisitor(){

            @Override
            public void visitCompoundInitializer(@NotNull OCCompoundInitializer initializer) {
                OCReturnStatement retStmt = (OCReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)initializer, OCReturnStatement.class);
                if (retStmt == null) {
                    return;
                }
                if (initializer.getInitializers().size() == numCtorParams && initializer.getResolvedType() instanceof OCBracedInitListType && !(initializer.getParent() instanceof OCCastExpression)) {
                    consumer.process((Object)new OCConstructorReferenceFromCompoundInit(retStmt, initializer, constructorPredefinition));
                }
            }
        };
        retVisitor.visitOCElement(funcBody);
    }

    private boolean processStructFieldInitializers(@Nullable OCStructSymbol symbol, @NotNull OCSymbolDeclarator member, OCStructType constructorOwner, OCFunctionSymbol constructor, Collection<OCSymbol> constructors, Processor<? super PsiReference> consumer, SearchScope searchScope) {
        if (symbol == null) {
            return false;
        }
        Ref hasConstructors = new Ref((Object)false);
        OCResolveContext context = OCResolveContext.forPsi(member);
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)symbol1 -> {
            hasConstructors.set((Object)true);
            if (symbol1.getKind().isConstructorOrDestructor() && !symbol1.isPredeclaration()) {
                PsiElement psiElement = symbol1.locateDefinition(member.getProject());
                if (!(psiElement instanceof OCDeclarator)) {
                    return true;
                }
                OCFunctionDefinition definition = (OCFunctionDefinition)psiElement.getParent();
                OCConstructorInitializationList initializationList = definition.getConstructorInitializationList();
                boolean found = false;
                if (initializationList != null) {
                    if (!OCConstructorReferenceSearchBase.isInScope(searchScope, initializationList)) {
                        return true;
                    }
                    for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                        OCReferenceElement field = initializer.getReferenceElement();
                        if (field == null || !field.getReference().isReferenceTo((PsiElement)member)) continue;
                        if (member instanceof OCFunctionDefinition) {
                            found = true;
                            break;
                        }
                        OCSymbol fieldSymbol = field.resolveToSymbol();
                        if (fieldSymbol == null || !constructorOwner.equals(fieldSymbol.getResolvedType(context), context) || !OCConstructorReferenceSearchBase.tryResolveBraceInitializer(constructors, constructor, initializer.getBraceInitializers(), context, psiElement) && !OCConstructorReferenceSearchBase.tryResolveBraceInitializer(constructors, constructor, initializer.getInitializers(), context, psiElement)) continue;
                        found = true;
                        this.onReferenceFromInitializer(initializer, member, constructor, consumer);
                        break;
                    }
                }
                if (!found && constructor.getNonInitializedParametersCount(context) == 0) {
                    this.onReferenceFromOtherConstructor(definition, member, constructor, consumer);
                }
            }
            return true;
        }), true, context);
        symbol.processFields((Processor<? super OCDeclaratorSymbol>)((Processor)field -> {
            if (!field.hasInitializer()) {
                return true;
            }
            PsiElement psiElement = field.locateDefinition(member.getProject());
            if (!(psiElement instanceof OCDeclarator)) {
                return true;
            }
            OCCompoundInitializer initializationList = ((OCDeclarator)psiElement).getInitializerList();
            if (initializationList != null) {
                if (!OCConstructorReferenceSearchBase.isInScope(searchScope, initializationList)) {
                    return true;
                }
                List<OCExpression> initializers = initializationList.getInitializerExpressions();
                if (OCConstructorReferenceSearchBase.tryResolveBraceInitializer(constructors, constructor, initializers, context, psiElement) || OCConstructorReferenceSearchBase.tryResolveBraceInitializer(constructors, constructor, initializers, context, psiElement)) {
                    this.onReferenceFromDeclarator((OCDeclarator)psiElement, constructor, consumer);
                    hasConstructors.set((Object)true);
                }
            }
            return true;
        }));
        return (Boolean)hasConstructors.get();
    }

    private static boolean tryResolveBraceInitializer(@NotNull Collection<OCSymbol> constructors, @NotNull OCFunctionSymbol constructor, @NotNull List<OCExpression> initializers, @NotNull OCResolveContext context, @NotNull PsiElement psiElement) {
        OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(initializers);
        OCSymbol resolved = OCResolveOverloadsUtil.resolveOverloads(constructors, argumentsList, null, null, null, false, false, context, psiElement);
        return Comparing.equal((Object)resolved, (Object)constructor);
    }

    private static boolean isInScope(SearchScope scope, PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (scope instanceof GlobalSearchScope) {
            return scope.contains(file.getVirtualFile());
        }
        if (scope instanceof LocalSearchScope) {
            return ((LocalSearchScope)scope).containsRange(file, element.getTextRange());
        }
        return false;
    }

    protected abstract boolean onReferenceFromInitializer(OCConstructorFieldInitializer var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<? super PsiReference> var4);

    protected abstract boolean onReferenceFromOtherConstructor(OCFunctionDefinition var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<? super PsiReference> var4);

    protected abstract boolean onReferenceFromStruct(OCStruct var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<? super PsiReference> var4);

    protected abstract boolean onReferenceFromDeclarator(OCDeclarator var1, OCFunctionSymbol var2, Processor<? super PsiReference> var3);

    protected abstract boolean onReferenceFromUsing(OCCppUsingStatement var1, OCFunctionSymbol var2, Processor<? super PsiReference> var3);

    private static class SearchWordAndProcessor {
        final String mySearchWord;
        final TextOccurenceProcessor myProcessor;

        SearchWordAndProcessor(String searchWord, TextOccurenceProcessor processor2) {
            this.mySearchWord = searchWord;
            this.myProcessor = processor2;
        }
    }
}

