/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import java.io.File;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceFilesProvider {
    private static final int MAX_LANGUAGE_LENGTH = 40;
    public static final ExtensionPointName<OCResourceFilesProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.resourceFilesProvider");

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        TreeMap<String, VirtualFile> result = new TreeMap<String, VirtualFile>();
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            result.putAll(provider2.getAccessibleResourceFiles(project, virtualFile));
        }
        return result;
    }

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull PsiElement element) {
        return OCResourceFilesProvider.getAccessibleResources(element.getProject(), OCResourceFilesProvider.getFileFromElement(element));
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile from, @NotNull VirtualFile who) {
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            if (!provider2.isAccessibleInner(project, from, who)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(@NotNull PsiElement element, @NotNull VirtualFile file) {
        return OCResourceFilesProvider.isAccessible(element.getProject(), OCResourceFilesProvider.getFileFromElement(element), file);
    }

    @NotNull
    private static VirtualFile getFileFromElement(@NotNull PsiElement element) {
        return OCFileUtil.getVirtualFile(element.getContainingFile());
    }

    @NotNull
    protected abstract SortedMap<String, VirtualFile> getAccessibleResourceFiles(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isAccessibleInner(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable VirtualFile var3);

    @NlsSafe
    @NotNull
    public static String getLocalizationName(@NotNull PsiFile file) {
        return OCResourceFilesProvider.getLocalizationName(file.getProject(), file.getVirtualFile());
    }

    @NlsSafe
    @NotNull
    public static String getLocalizationName(@NotNull Project project, @NotNull VirtualFile file) {
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            String localizationName = provider2.getLocalizationNameInner(project, file);
            if (localizationName == null) continue;
            return OCResourceFilesProvider.shortenStringBeginning(localizationName);
        }
        return OCBundle.message("resource.language.unknown", new Object[0]);
    }

    @NotNull
    private static String shortenStringBeginning(@NotNull String localizationName) {
        return StringUtil.shortenTextWithEllipsis((String)localizationName, (int)40, (int)39, (boolean)true);
    }

    @NlsSafe
    @Nullable
    protected abstract String getLocalizationNameInner(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    public static String withoutLocalization(String fileName) {
        String locationExtension = ".lproj" + File.separator;
        int extensionIndex = fileName.lastIndexOf(locationExtension);
        if (extensionIndex <= 0) {
            return null;
        }
        int separatorIndex = fileName.lastIndexOf(File.separator, extensionIndex - 1);
        if (separatorIndex == extensionIndex - 1) {
            return null;
        }
        return fileName.substring(0, separatorIndex + 1) + fileName.substring(extensionIndex + locationExtension.length());
    }
}

