/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCGenericParametersList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import org.jetbrains.annotations.NotNull;

public class OCTypeParameterSymbolResolver {
    public static boolean processTemplateSymbols(String name, PsiElement element, Processor<OCSymbol> processor2, @NotNull OCResolveContext resolveContext) {
        OCElement context = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCDeclaration.class, OCCppUsingStatement.class});
        if (context == null || !context.getContainingOCFile().isCpp()) {
            return true;
        }
        while (context != null) {
            OCTemplateParameterList[] templates = (OCTemplateParameterList[])PsiTreeUtil.getChildrenOfType((PsiElement)context, OCTemplateParameterList.class);
            if (templates != null) {
                for (OCTemplateParameterList template : templates) {
                    for (OCDeclaration oCDeclaration : template.getParameterDeclarations()) {
                        OCDeclarator declarator = oCDeclaration.getDeclarators().get(0);
                        if (name != null && !name.equals(declarator.getName())) continue;
                        return processor2.process((Object)resolveContext.getSubstitution().substitute(declarator.getLocalSymbol(), resolveContext));
                    }
                    for (OCTypeParameterDeclaration oCTypeParameterDeclaration : template.getTypeParameterDeclarations()) {
                        OCTypeParameterTypeSymbol localSymbol;
                        if (name != null && !name.equals(oCTypeParameterDeclaration.getName()) || (localSymbol = (OCTypeParameterTypeSymbol)oCTypeParameterDeclaration.getLocalSymbol()) == null) continue;
                        return processor2.process((Object)localSymbol);
                    }
                }
            }
            context = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)context, (boolean)true, (Class[])new Class[]{OCDeclaration.class});
        }
        return true;
    }

    static boolean processGenericSymbols(String name, PsiElement element, Processor<OCSymbol> processor2, @NotNull OCResolveContext resolveContext) {
        OCElement context = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCClassDeclaration.class});
        while (context != null) {
            OCGenericParametersList[] genericParameterLists = (OCGenericParametersList[])PsiTreeUtil.getChildrenOfType((PsiElement)context, OCGenericParametersList.class);
            if (genericParameterLists != null) {
                for (OCGenericParametersList template : genericParameterLists) {
                    for (OCGenericParameter param : template.getParameters()) {
                        OCGenericParameterSymbol localSymbol;
                        if (name != null && !name.equals(param.getName()) || (localSymbol = param.getLocalSymbol()) == null) continue;
                        return processor2.process((Object)localSymbol);
                    }
                }
            }
            context = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)context, (boolean)true, (Class[])new Class[]{OCClassDeclaration.class});
        }
        return true;
    }
}

