/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCallParameterUnwrapper
extends OCUnwrapper {
    public OCCallParameterUnwrapper() {
        super("");
    }

    @NotNull
    private static PsiElement adjustElement(@NotNull PsiElement element) {
        element = OCCallParameterUnwrapper.adjustElementToTheLeft(element);
        element = OCCallParameterUnwrapper.adjustFromMacroToExpansion(element);
        return element;
    }

    @NotNull
    private static PsiElement adjustElementToTheLeft(@NotNull PsiElement element) {
        LeafPsiElement leaf;
        if (element instanceof LeafPsiElement && OCTokenTypes.RPAR == (leaf = (LeafPsiElement)element).getElementType()) {
            PsiElement left = element;
            while ((left = left.getPrevSibling()) instanceof PsiWhiteSpace) {
            }
            if (left != null) {
                return left;
            }
        }
        return element;
    }

    @NotNull
    private static PsiElement adjustFromMacroToExpansion(@NotNull PsiElement element) {
        OCMacroCall macroCall;
        if (element instanceof OCMacroCall && (macroCall = (OCMacroCall)element).getExpansionExpression() != null) {
            return macroCall.getExpansionExpression();
        }
        return element;
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        Object text = OCElementUtil.getTextWithMacros(OCCallParameterUnwrapper.adjustElement(e));
        if (((String)text).length() > 20) {
            text = ((String)text).substring(0, 17) + "...";
        }
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{text});
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if ((e = OCCallParameterUnwrapper.adjustElement(e)) instanceof OCExpression) {
            return OCCallParameterUnwrapper.isCallExpr(e);
        }
        return false;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        e = OCCallParameterUnwrapper.adjustElement(e);
        super.collectAffectedElements(e, toExtract);
        return e.getParent().getParent();
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context) {
        element = OCCallParameterUnwrapper.adjustElement(element);
        PsiElement methodCall = element.getParent().getParent();
        context.extractElement(element, methodCall);
        context.deleteExactly(methodCall);
    }

    private static boolean isCallExpr(@NotNull PsiElement el) {
        if (!OCCallParameterUnwrapper.isInArgList(el)) {
            return false;
        }
        PsiElement argList = el.getParent();
        assert (argList instanceof OCArgumentList);
        return !(argList.getParent() instanceof OCDeclarator);
    }
}

