/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import org.jetbrains.annotations.NotNull;

public class OCVetoRenameCondition
implements Condition<PsiElement> {
    public boolean value(PsiElement context) {
        PsiElement maybeDeclaration;
        PsiElement psiElement = maybeDeclaration = context instanceof OCDeclarator ? context.getParent() : context;
        if (maybeDeclaration instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)maybeDeclaration).isOperator()) {
            return !((OCFunctionDeclaration)maybeDeclaration).isUDL();
        }
        if (maybeDeclaration instanceof OCDeclaration) {
            for (OCDeclarator decl : ((OCDeclaration)maybeDeclaration).getDeclarators()) {
                if (!OCVetoRenameCondition.isForbiddenForRename(decl)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isForbiddenForRename(@NotNull OCDeclarator declarator) {
        OCSymbol symbol = declarator.getSymbol();
        if (symbol != null && declarator.getType() instanceof OCEllipsisType && symbol.getName().equals("<unnamed>")) {
            return true;
        }
        return declarator.getNode().findChildByType((IElementType)OCLexerTokenTypes.OPERATOR_CPP_KEYWORD) != null;
    }
}

