/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameHandlerExtension;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCVetoRenameCondition;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedVirtualPsiElement;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        if (!(file instanceof OCFile)) {
            return false;
        }
        if (!(element instanceof PsiFile) && !OCRenameUtil.isInProjectSources(element)) {
            return false;
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        if (!(element == null || element.getContainingFile() instanceof OCFile && file.getManager().isInProject(element))) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
        if (reference != null) {
            PsiElement atCursor = reference.getElement();
            if (OCRenameHandlerExtension.shouldIgnoreElement(atCursor)) {
                return false;
            }
            if (atCursor instanceof OCReferenceElement || atCursor instanceof OCQualifiedExpression) {
                return true;
            }
        }
        if (element == null) {
            return false;
        }
        if (OCRenameHandlerExtension.shouldIgnoreElement(element)) {
            return false;
        }
        if (element instanceof OCMethod) {
            symbol = (OCMethodSymbol)((OCMethod)element).getSymbol();
            OCSymbol oCSymbol = symbol = symbol != null ? symbol.getAssociatedSymbol(element.getProject()) : null;
            if (symbol != null && symbol.getGeneratedFromProperty() != null) {
                return false;
            }
        } else if (element instanceof OCDeclarator) {
            symbol = ((OCDeclarator)element).getSymbol();
            if (symbol instanceof OCPropertySymbol) {
                if (reference != null && reference.getElement() instanceof OCSendMessageExpression && !symbol.getName().equals(((OCSendMessageExpression)reference.getElement()).getMessageSelector())) {
                    return false;
                }
            } else {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                    if (!((OCFunctionSymbol)symbol).isUDL()) {
                        return false;
                    }
                    PsiElement at = file.findElementAt(offset);
                    return OCTokenTypes.POSSIBLE_ID_NAMES.contains(OCElementUtil.getElementType(at)) || offset > 0 && at != null && at.getTextOffset() == offset && OCTokenTypes.POSSIBLE_ID_NAMES.contains(OCElementUtil.getElementType(file.findElementAt(offset - 1)));
                }
                if (symbol == null && OCVetoRenameCondition.isForbiddenForRename((OCDeclarator)element)) {
                    return false;
                }
            }
        }
        return OCInplaceRenameHandler.canRenameInElementAtOffset(element, offset, element instanceof OCUDLiteralExpression || element instanceof OCTypeParameterDeclaration);
    }

    @Contract(value="null, _, _ -> false")
    private static boolean canRenameInElementAtOffset(@Nullable PsiElement element, int offset, boolean checkOffsetIsOverId) {
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement id = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            return id != null && !id.getTextRange().isEmpty() && (!checkOffsetIsOverId || id.getTextRange().containsOffset(offset));
        }
        return false;
    }

    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        return OCInplaceRenameHandler.createRenamer(elementToRename, editor, null, null);
    }

    @Nullable
    static VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor, @Nullable String initialName, @Nullable String oldName) {
        if (elementToRename instanceof OCCategoryName) {
            OCClassSymbol symbol = ((OCClassDeclaration)elementToRename.getParent()).getSymbol();
            if (symbol != null) {
                return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, true, initialName, oldName);
            }
        } else {
            PsiElement element;
            OCSymbol symbol = OCRenameUtil.getSymbolToRename(elementToRename);
            if (symbol == null) {
                return null;
            }
            if (symbol instanceof OCFunctionGroupSymbol) {
                CommonRefactoringUtil.showErrorHint((Project)elementToRename.getProject(), (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), null);
                return null;
            }
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)elementToRename.getProject()).getPsiFile(editor.getDocument());
            PsiElement originalElementAtCaret = element = currentFile != null ? currentFile.findElementAt(editor.getCaretModel().getOffset()) : null;
            if (currentFile != null && OCElementUtil.getElementType(element) != OCLexerTokenTypes.IDENTIFIER) {
                element = currentFile.findElementAt(editor.getCaretModel().getOffset() - 1);
            }
            if (element != elementToRename && element != originalElementAtCaret && PsiTreeUtil.getParentOfType((PsiElement)element, OCArgumentList.class) != null && (OCElementUtil.getElementType(originalElementAtCaret) == OCLexerTokenTypes.RPAR || OCElementUtil.getElementType(element) == OCLexerTokenTypes.LPAR)) {
                return null;
            }
            if (elementToRename instanceof OCMethod) {
                OCMethod method = (OCMethod)elementToRename;
                if (symbol instanceof OCMethodSymbol && element != null && OCElementUtil.getElementType(element) == OCLexerTokenTypes.IDENTIFIER) {
                    PsiElement parent = element.getParent();
                    OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol;
                    int index = -1;
                    if (parent instanceof OCMethodSelectorPart && ((OCMethodSelectorPart)parent).getSelectorIdentifier() == element) {
                        index = method.getSelectors().indexOf(element);
                    } else if (parent instanceof OCArgumentSelector && ((OCArgumentSelector)parent).getSelectorIdentifier() == element) {
                        OCSendMessageExpression sendMessageExpr = (OCSendMessageExpression)parent.getParent().getParent();
                        index = sendMessageExpr.getArgumentSelectors().indexOf(parent);
                    } else if (parent instanceof OCQualifiedExpression) {
                        index = 0;
                    } else if (parent instanceof OCSelectorExpression) {
                        index = ((OCSelectorExpression)parent).getSelectorParts().indexOf(element);
                    }
                    if (index != -1) {
                        return new OCInplaceRenamer(method, methodSymbol, element, index, editor, initialName, oldName);
                    }
                }
                return new OCInplaceRenamer((OCMethod)elementToRename, symbol, editor, false, initialName, oldName){

                    @Override
                    public boolean performInplaceRename() {
                        return true;
                    }
                };
            }
            if (symbol instanceof OCInstanceVariableSymbol && elementToRename instanceof OCReferenceElement) {
                return new OCInplaceRenamer((PsiNamedElement)new OCSymbolHolderVirtualPsiElement(symbol, elementToRename.getProject()), symbol, editor, false, initialName, oldName);
            }
            if (symbol instanceof OCPropertySymbol && element != null && element.getParent() instanceof OCSelectorExpression && OCNameSuggester.isObjCSetter(((OCSelectorExpression)element.getParent()).getSelector())) {
                return null;
            }
            if (elementToRename instanceof OCLocalizedString) {
                int offset;
                if (OCElementUtil.getElementType(elementToRename.getFirstChild()) != OCLexerTokenTypes.STRING_LITERAL || ((OCLocalizedString)elementToRename).getKey().isEmpty()) {
                    return null;
                }
                if (currentFile != null && (element = currentFile.findElementAt(offset = editor.getCaretModel().getOffset())) != null && OCElementUtil.getElementType(element) == OCLexerTokenTypes.STRING_LITERAL && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                }
            } else if (symbol instanceof OCStructSymbol && elementToRename instanceof OCCompilerGeneratedVirtualPsiElement && (elementToRename = symbol.locateDefinition(elementToRename.getProject())) == null) {
                return null;
            }
            return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, false, initialName, oldName);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        OCReferenceElement refElement;
        PsiElement element;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset());
        PsiElement psiElement = element = dataContext != null ? PsiElementRenameHandler.getElement((DataContext)dataContext) : null;
        if (reference instanceof OCReferenceElement && !((refElement = (OCReferenceElement)reference) instanceof OCMacroReferenceElementImpl) && refElement.resolveToSymbol() == null && refElement.resolveToSymbolIgnoringSymbolContext() != null) {
            return;
        }
        if (element == null) {
            PsiElement psiElement2 = element = reference != null && reference.resolve() == null ? reference.getElement() : null;
            if (element != null) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                if (ApplicationManager.getApplication().isUnitTestMode() || this.checkAvailable(element, editor, dataContext)) {
                    String initialName = dataContext != null ? (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext) : null;
                    OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, editor, file, project, reference, initialName, reference.getCanonicalText());
                    renamer.performInplaceRename();
                }
                return;
            }
        }
        super.invoke(project, editor, file, dataContext);
    }
}

