/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractExtractDialog
extends OCAbstractMoveDialog {
    protected JLabel myClassNameLabel;
    protected JTextField myExtractedClassNameField;

    protected OCAbstractExtractDialog(@Nullable OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Project project) {
        super(clazz, classSymbol, selectedCondition, project);
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        this.myClassNameLabel = new JLabel();
        this.myClassNameLabel.setText(OCBundle.message("abstract.extract.dialog.class.name", StringUtil.capitalize((String)this.getClassType())));
        this.myExtractedClassNameField = new JTextField();
        this.myExtractedClassNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                OCAbstractExtractDialog.this.validateButtons();
            }
        });
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedClassNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedClassNameField;
    }

    @NotNull
    public String getClassName() {
        return ApplicationManager.getApplication().isUnitTestMode() ? "zzz_source_new" : this.myExtractedClassNameField.getText().trim();
    }

    @Override
    public boolean allowsEmptySelection() {
        return true;
    }

    @Override
    public void checkCanRun() throws ConfigurationException {
        super.checkCanRun();
        String superClassName = this.getClassName();
        if (!StringUtil.isJavaIdentifier((String)superClassName)) {
            String classType = StringUtil.decapitalize((String)this.getClassType());
            String message = OCRefactoringBundle.message("extract.invalid.name.for.class.type.error", classType);
            throw new ConfigurationException(message);
        }
    }

    @Override
    public boolean checkConflicts() {
        String className = this.getClassName();
        OCSymbol existing = OCCodeInsightUtil.resolveNameInScope(this.getSymbolKind(), className, null, null, this.myProject);
        if (existing != null) {
            Messages.showErrorDialog((String)OCBundle.message("extract.symbol.already.exist", existing.getNameWithKindUppercase(OCCompilationContext.create(existing, this.myProject))), (String)OCBundle.message("abstract.extract.dialog.unable.create.file", new Object[0]));
            return false;
        }
        return super.checkConflicts();
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return symbol.getNameWithKindUppercase(OCCompilationContext.create(symbol, this.myProject)) + " will be inaccessible in the extracted code";
    }

    @NotNull
    protected abstract String getClassType();

    protected OCSymbolKind getSymbolKind() {
        return OCSymbolKind.INTERFACE;
    }

    @Override
    protected String getOKButtonText() {
        return OCRefactoringBundle.message("extract.dialog.button.extract", new Object[0]);
    }
}

